/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.flow.Flow;
import azkaban.jobcallback.JobCallbackValidator;
import azkaban.project.FlowTrigger;
import azkaban.project.NodeBean;
import azkaban.project.NodeBeanLoader;
import azkaban.project.ProjectManagerException;
import azkaban.project.ProjectWhitelist;
import azkaban.project.validator.ValidationReport;
import azkaban.utils.MemConfValue;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class FlowLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlowLoaderUtils.class);
    private static final String XMS = "Xms";
    private static final String XMX = "Xmx";

    public static void setPropsInYamlFile(String path, File flowFile, Props prop) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        NodeBean nodeBean = FlowLoaderUtils.setPropsInNodeBean(path, flowFile, prop);
        try (BufferedWriter writer = Files.newBufferedWriter(flowFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            new Yaml(options).dump((Object)nodeBean, (Writer)writer);
        }
        catch (IOException e) {
            throw new ProjectManagerException("Failed to set properties in flow file " + flowFile.getName());
        }
    }

    public static NodeBean setPropsInNodeBean(String path, File flowFile, Props prop) {
        NodeBeanLoader loader = new NodeBeanLoader();
        try {
            NodeBean nodeBean = loader.load(flowFile);
            String[] pathList = path.split(":");
            if (FlowLoaderUtils.overridePropsInNodeBean(nodeBean, pathList, 0, prop)) {
                return nodeBean;
            }
            logger.error("Error setting props for " + path);
        }
        catch (Exception e) {
            logger.error("Failed to set props, error loading flow YAML file " + flowFile);
        }
        return null;
    }

    private static boolean overridePropsInNodeBean(NodeBean nodeBean, String[] pathList, int idx, Props prop) {
        if (idx < pathList.length && nodeBean.getName().equals(pathList[idx])) {
            if (idx == pathList.length - 1) {
                if (prop.containsKey((Object)"type")) {
                    nodeBean.setType(prop.get((Object)"type"));
                }
                Map config = prop.getFlattened();
                config.remove("type");
                nodeBean.setConfig(config);
                return true;
            }
            for (NodeBean bean : nodeBean.getNodes()) {
                if (!FlowLoaderUtils.overridePropsInNodeBean(bean, pathList, idx + 1, prop)) continue;
                return true;
            }
        }
        return false;
    }

    public static Props getPropsFromYamlFile(String path, File flowFile) {
        ArrayList<Props> propsList = new ArrayList<Props>();
        NodeBeanLoader loader = new NodeBeanLoader();
        try {
            NodeBean nodeBean = loader.load(flowFile);
            String[] pathList = path.split(":");
            if (FlowLoaderUtils.findPropsFromNodeBean(nodeBean, pathList, 0, propsList)) {
                if (!propsList.isEmpty()) {
                    return (Props)propsList.get(0);
                }
                logger.error("Error getting props for " + path);
            }
        }
        catch (Exception e) {
            logger.error("Failed to get props, error loading flow YAML file. ", (Throwable)e);
        }
        return null;
    }

    private static boolean findPropsFromNodeBean(NodeBean nodeBean, String[] pathList, int idx, List<Props> propsList) {
        if (idx < pathList.length && nodeBean.getName().equals(pathList[idx])) {
            if (idx == pathList.length - 1) {
                propsList.add(nodeBean.getProps());
                return true;
            }
            for (NodeBean bean : nodeBean.getNodes()) {
                if (!FlowLoaderUtils.findPropsFromNodeBean(bean, pathList, idx + 1, propsList)) continue;
                return true;
            }
        }
        return false;
    }

    public static FlowTrigger getFlowTriggerFromYamlFile(File flowFile) {
        NodeBeanLoader loader = new NodeBeanLoader();
        try {
            NodeBean nodeBean = loader.load(flowFile);
            return loader.toFlowTrigger(nodeBean.getTrigger());
        }
        catch (Exception e) {
            logger.error("Failed to get flow trigger, error loading flow YAML file. ", (Throwable)e);
            return null;
        }
    }

    public static void addEmailPropsToFlow(Flow flow, Props prop) {
        List successEmailList = prop.getStringList("success.emails", Collections.EMPTY_LIST);
        HashSet<String> successEmail = new HashSet<String>();
        for (String email : successEmailList) {
            successEmail.add(email.toLowerCase());
        }
        List failureEmailList = prop.getStringList("failure.emails", Collections.EMPTY_LIST);
        HashSet<String> failureEmail = new HashSet<String>();
        for (String email : failureEmailList) {
            failureEmail.add(email.toLowerCase());
        }
        List notifyEmailList = prop.getStringList("notify.emails", Collections.EMPTY_LIST);
        for (String email : notifyEmailList) {
            email = email.toLowerCase();
            successEmail.add(email);
            failureEmail.add(email);
        }
        flow.addFailureEmails(failureEmail);
        flow.addSuccessEmails(successEmail);
    }

    public static ValidationReport generateFlowLoaderReport(Set<String> errors) {
        ValidationReport report = new ValidationReport();
        report.addErrorMsgs(errors);
        return report;
    }

    public static void checkJobProperties(int projectId, Props props, Map<String, Props> jobPropsMap, Set<String> errors) {
        if (ProjectWhitelist.isProjectWhitelisted(projectId, ProjectWhitelist.WhitelistType.MemoryCheck)) {
            return;
        }
        MemConfValue maxXms = MemConfValue.parseMaxXms((Props)props);
        MemConfValue maxXmx = MemConfValue.parseMaxXmx((Props)props);
        for (String jobName : jobPropsMap.keySet()) {
            String xmx;
            Props jobProps = jobPropsMap.get(jobName);
            String xms = jobProps.getString(XMS, null);
            if (xms != null && !PropsUtils.isVariableReplacementPattern((String)xms) && Utils.parseMemString((String)xms) > maxXms.getSize()) {
                errors.add(String.format("%s: Xms value has exceeded the allowed limit (max Xms = %s)", jobName, maxXms.getString()));
            }
            if ((xmx = jobProps.getString(XMX, null)) != null && !PropsUtils.isVariableReplacementPattern((String)xmx) && Utils.parseMemString((String)xmx) > maxXmx.getSize()) {
                errors.add(String.format("%s: Xmx value has exceeded the allowed limit (max Xmx = %s)", jobName, maxXmx.getString()));
            }
            JobCallbackValidator.validate(jobName, props, jobProps, errors);
        }
    }

    public static void cleanUpDir(File dir) {
        try {
            if (dir != null && dir.exists()) {
                FileUtils.deleteDirectory((File)dir);
            }
        }
        catch (IOException e) {
            logger.error("Failed to delete the directory", (Throwable)e);
            dir.deleteOnExit();
        }
    }

    public static boolean isAzkabanFlowVersion20(double azkabanFlowVersion) {
        return Double.compare(azkabanFlowVersion, 2.0) == 0;
    }

    public static class DirFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    public static class SuffixFilter
    implements FileFilter {
        private final String suffix;

        public SuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return pathname.isFile() && !pathname.isHidden() && name.length() > this.suffix.length() && name.endsWith(this.suffix);
        }
    }
}

