/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.flow.ConditionOnJobStatus;
import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.project.AzkabanFlow;
import azkaban.project.AzkabanNode;
import azkaban.project.FlowLoader;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.NodeBean;
import azkaban.project.NodeBeanLoader;
import azkaban.project.Project;
import azkaban.project.validator.ValidationReport;
import azkaban.utils.Props;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryYamlFlowLoader
implements FlowLoader {
    public static final Pattern CONDITION_VARIABLE_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{([^:{}]+):([^:{}]+)\\}");
    public static final Pattern CONDITION_ON_JOB_STATUS_PATTERN = Pattern.compile("(?i)\\b(" + StringUtils.join((Object[])ConditionOnJobStatus.values(), (String)"|") + ")\\b");
    private static final Logger logger = LoggerFactory.getLogger(DirectoryYamlFlowLoader.class);
    private static final Pattern DIGIT_STRING_PATTERN = Pattern.compile("\\d+|'.*'|\".*\"");
    private static final String VALID_CONDITION_OPERATORS = "&&|\\|\\||==|!=|>|>=|<|<=";
    private final Props props;
    private final Set<String> errors = new HashSet<String>();
    private final Map<String, Flow> flowMap = new HashMap<String, Flow>();
    private final Map<String, List<Edge>> edgeMap = new HashMap<String, List<Edge>>();
    private final Map<String, Props> jobPropsMap = new HashMap<String, Props>();

    public DirectoryYamlFlowLoader(Props props) {
        this.props = props;
    }

    @Override
    public Map<String, Flow> getFlowMap() {
        return this.flowMap;
    }

    @Override
    public Set<String> getErrors() {
        return this.errors;
    }

    public Map<String, List<Edge>> getEdgeMap() {
        return this.edgeMap;
    }

    @Override
    public ValidationReport loadProjectFlow(Project project, File projectDir) {
        this.convertYamlFiles(projectDir);
        FlowLoaderUtils.checkJobProperties(project.getId(), this.props, this.jobPropsMap, this.errors);
        return FlowLoaderUtils.generateFlowLoaderReport(this.errors);
    }

    private void convertYamlFiles(File projectDir) {
        for (File file : projectDir.listFiles(new FlowLoaderUtils.SuffixFilter(".flow"))) {
            NodeBeanLoader loader = new NodeBeanLoader();
            try {
                NodeBean nodeBean = loader.load(file);
                if (!loader.validate(nodeBean)) {
                    this.errors.add("Failed to validate nodeBean for " + file.getName() + ". Duplicate nodes found or dependency undefined.");
                    continue;
                }
                AzkabanFlow azkabanFlow = (AzkabanFlow)loader.toAzkabanNode(nodeBean);
                if (this.flowMap.containsKey(azkabanFlow.getName())) {
                    this.errors.add("Duplicate flows found in the project with name " + azkabanFlow.getName());
                    continue;
                }
                Flow flow = this.convertAzkabanFlowToFlow(azkabanFlow, azkabanFlow.getName(), file);
                this.flowMap.put(flow.getId(), flow);
            }
            catch (Exception e) {
                this.errors.add("Error loading flow yaml file " + file.getName() + ":" + e.getMessage());
            }
        }
        for (File file : projectDir.listFiles(new FlowLoaderUtils.DirFilter())) {
            this.convertYamlFiles(file);
        }
    }

    private Flow convertAzkabanFlowToFlow(AzkabanFlow azkabanFlow, String flowName, File flowFile) {
        Flow flow = new Flow(flowName);
        flow.setAzkabanFlowVersion(2.0);
        Props props = azkabanFlow.getProps();
        FlowLoaderUtils.addEmailPropsToFlow(flow, props);
        props.setSource(flowFile.getName());
        flow.addAllFlowProperties((Collection<FlowProps>)ImmutableList.of((Object)new FlowProps(props)));
        azkabanFlow.getNodes().values().stream().map(n -> this.convertAzkabanNodeToNode((AzkabanNode)n, flowName, flowFile, azkabanFlow)).forEach(n -> flow.addNode((Node)n));
        this.buildFlowEdges(azkabanFlow, flowName);
        if (this.edgeMap.containsKey(flowName)) {
            flow.addAllEdges((Collection<Edge>)this.edgeMap.get(flowName));
        }
        flow.initialize();
        return flow;
    }

    private Node convertAzkabanNodeToNode(AzkabanNode azkabanNode, String flowName, File flowFile, AzkabanFlow azkabanFlow) {
        Node node = new Node(azkabanNode.getName());
        node.setType(azkabanNode.getType());
        this.validateCondition(node, azkabanNode, azkabanFlow);
        node.setCondition(azkabanNode.getCondition());
        node.setPropsSource(flowFile.getName());
        node.setJobSource(flowFile.getName());
        if (azkabanNode.getType().equals("flow")) {
            String embeddedFlowId = flowName + ":" + node.getId();
            node.setEmbeddedFlowId(embeddedFlowId);
            Flow flowNode = this.convertAzkabanFlowToFlow((AzkabanFlow)azkabanNode, embeddedFlowId, flowFile);
            flowNode.setEmbeddedFlow(true);
            flowNode.setCondition(node.getCondition());
            this.flowMap.put(flowNode.getId(), flowNode);
        }
        this.jobPropsMap.put(flowName + ":" + node.getId(), azkabanNode.getProps());
        return node;
    }

    private void buildFlowEdges(AzkabanFlow azkabanFlow, String flowName) {
        HashSet<String> recStack = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (AzkabanNode node : azkabanFlow.getNodes().values()) {
            this.addEdges(node, azkabanFlow, flowName, recStack, visited);
        }
    }

    private void addEdges(AzkabanNode node, AzkabanFlow azkabanFlow, String flowName, HashSet<String> recStack, HashSet<String> visited) {
        if (!visited.contains(node.getName())) {
            recStack.add(node.getName());
            visited.add(node.getName());
            List<String> dependsOnList = node.getDependsOn();
            for (String parent : dependsOnList) {
                Edge edge = new Edge(parent, node.getName());
                if (!this.edgeMap.containsKey(flowName)) {
                    this.edgeMap.put(flowName, new ArrayList());
                }
                this.edgeMap.get(flowName).add(edge);
                if (recStack.contains(parent)) {
                    edge.setError("Cycles found.");
                    this.errors.add("Cycles found at " + edge.getId());
                    continue;
                }
                this.addEdges(azkabanFlow.getNode(parent), azkabanFlow, flowName, recStack, visited);
            }
            recStack.remove(node.getName());
        }
    }

    private void validateCondition(Node node, AzkabanNode azkabanNode, AzkabanFlow azkabanFlow) {
        boolean foundConditionOnJobStatus = false;
        String condition = azkabanNode.getCondition();
        if (condition == null) {
            return;
        }
        String replacedCondition = condition.replaceAll("\\s+|\\(|\\)", "");
        String[] operands = replacedCondition.split(VALID_CONDITION_OPERATORS);
        for (int i = 0; i < operands.length; ++i) {
            Matcher matcher = CONDITION_ON_JOB_STATUS_PATTERN.matcher(operands[i]);
            if (matcher.matches()) {
                logger.info("Operand " + operands[i] + " is a condition on job status.");
                if (foundConditionOnJobStatus) {
                    this.errors.add("Invalid condition for " + node.getId() + ": cannot combine more than one conditionOnJobStatus macros.");
                }
                foundConditionOnJobStatus = true;
                node.setConditionOnJobStatus(ConditionOnJobStatus.fromString(matcher.group(1)));
                continue;
            }
            if (operands[i].startsWith("!")) {
                operands[i] = operands[i].substring(1);
            }
            if (operands[i].equals("")) {
                this.errors.add("Invalid condition for " + node.getId() + ": operand is an empty string.");
                continue;
            }
            if (DIGIT_STRING_PATTERN.matcher(operands[i]).matches()) continue;
            this.validateVariableSubstitution(operands[i], azkabanNode, azkabanFlow);
        }
    }

    private void validateVariableSubstitution(String operand, AzkabanNode azkabanNode, AzkabanFlow azkabanFlow) {
        Matcher matcher = CONDITION_VARIABLE_REPLACEMENT_PATTERN.matcher(operand);
        if (matcher.matches()) {
            String jobName = matcher.group(1);
            AzkabanNode conditionNode = azkabanFlow.getNode(jobName);
            if (conditionNode == null) {
                this.errors.add("Invalid condition for " + azkabanNode.getName() + ": " + jobName + " doesn't exist in the flow.");
            } else if (this.isDescendantNode(conditionNode, azkabanNode, azkabanFlow)) {
                this.errors.add("Invalid condition for " + azkabanNode.getName() + ": should not define condition on its descendant node " + jobName + ".");
            }
        } else {
            this.errors.add("Invalid condition for " + azkabanNode.getName() + ": cannot resolve the condition. Please check the syntax for supported conditions.");
        }
    }

    private boolean isDescendantNode(AzkabanNode current, AzkabanNode target, AzkabanFlow azkabanFlow) {
        if (current == null || target == null) {
            return false;
        }
        if (current.getDependsOn() == null) {
            return false;
        }
        if (current.getDependsOn().contains(target.getName())) {
            return true;
        }
        for (String nodeName : current.getDependsOn()) {
            if (!this.isDescendantNode(azkabanFlow.getNode(nodeName), target, azkabanFlow)) continue;
            return true;
        }
        return false;
    }
}

