/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metric;

import azkaban.metric.AbstractMetric;
import azkaban.metric.MetricException;
import azkaban.metric.MetricReportManager;
import java.util.Timer;
import java.util.TimerTask;

public abstract class TimeBasedReportingMetric<T>
extends AbstractMetric<T> {
    protected long MAX_MILLISEC_INTERVAL = 3600000L;
    protected long MIN_MILLISEC_INTERVAL = 3000L;
    private Timer timer;

    public TimeBasedReportingMetric(String metricName, String metricType, T initialValue, MetricReportManager manager, long interval) throws MetricException {
        super(metricName, metricType, initialValue, manager);
        if (!this.isValidInterval(interval)) {
            throw new MetricException("Invalid interval: Cannot instantiate timer");
        }
        this.timer = new Timer();
        this.timer.schedule(this.getTimerTask(), interval, interval);
    }

    private TimerTask getTimerTask() {
        final TimeBasedReportingMetric lockObject = this;
        TimerTask recurringReporting = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimeBasedReportingMetric timeBasedReportingMetric = lockObject;
                synchronized (timeBasedReportingMetric) {
                    TimeBasedReportingMetric.this.preTrackingEventMethod();
                    TimeBasedReportingMetric.this.notifyManager();
                    TimeBasedReportingMetric.this.postTrackingEventMethod();
                }
            }
        };
        return recurringReporting;
    }

    public void updateInterval(long interval) throws MetricException {
        if (!this.isValidInterval(interval)) {
            throw new MetricException("Invalid interval: Cannot update timer");
        }
        logger.debug((Object)String.format("Updating tracking interval to %d milisecond for %s metric", interval, this.getName()));
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.schedule(this.getTimerTask(), interval, interval);
    }

    private boolean isValidInterval(long interval) {
        return interval >= this.MIN_MILLISEC_INTERVAL && interval <= this.MAX_MILLISEC_INTERVAL;
    }

    protected abstract void preTrackingEventMethod();

    protected abstract void postTrackingEventMethod();
}

