/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.db.EncodingType;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.utils.GZIPUtils;
import azkaban.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;

@Singleton
public class FetchActiveFlowDao {
    private static final Logger logger = Logger.getLogger(FetchActiveFlowDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    public FetchActiveFlowDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    private static Pair<ExecutionReference, ExecutableFlow> getExecutableFlowHelper(ResultSet rs) throws SQLException {
        int id = rs.getInt("exec_id");
        int encodingType = rs.getInt("enc_type");
        byte[] data = rs.getBytes("flow_data");
        if (data != null) {
            ExecutableFlow exFlow;
            EncodingType encType = EncodingType.fromInteger((int)encodingType);
            try {
                exFlow = ExecutableFlow.createExecutableFlowFromObject(GZIPUtils.transformBytesToObject(data, encType));
            }
            catch (IOException e) {
                throw new SQLException("Error retrieving flow data " + id, e);
            }
            return FetchActiveFlowDao.getPairWithExecutorInfo(rs, exFlow);
        }
        logger.warn((Object)("Execution id " + id + " has flow_data = null. To clean up, update status to FAILED manually, eg. SET status = " + Status.FAILED.getNumVal() + " WHERE id = " + id));
        return null;
    }

    private static Pair<ExecutionReference, ExecutableFlow> getPairWithExecutorInfo(ResultSet rs, ExecutableFlow exFlow) throws SQLException {
        Executor executor;
        int executorId = rs.getInt("executorId");
        String host = rs.getString("host");
        int port = rs.getInt("port");
        if (host == null) {
            logger.warn((Object)("Executor id " + executorId + " (on execution " + exFlow.getExecutionId() + ") wasn't found"));
            executor = null;
        } else {
            boolean executorStatus = rs.getBoolean("executorStatus");
            executor = new Executor(executorId, host, port, executorStatus);
        }
        ExecutionReference ref = new ExecutionReference(exFlow.getExecutionId(), executor);
        return new Pair<ExecutionReference, ExecutableFlow>(ref, exFlow);
    }

    private static Pair<ExecutionReference, ExecutableFlow> getExecutableFlowMetadataHelper(ResultSet rs) throws SQLException {
        Flow flow = new Flow(rs.getString("flow_id"));
        Project project = new Project(rs.getInt("project_id"), null);
        project.setVersion(rs.getInt("version"));
        ExecutableFlow exFlow = new ExecutableFlow(project, flow);
        exFlow.setExecutionId(rs.getInt("exec_id"));
        exFlow.setStatus(Status.fromInteger(rs.getInt("status")));
        exFlow.setSubmitTime(rs.getLong("submit_time"));
        exFlow.setStartTime(rs.getLong("start_time"));
        exFlow.setEndTime(rs.getLong("end_time"));
        exFlow.setSubmitUser(rs.getString("submit_user"));
        return FetchActiveFlowDao.getPairWithExecutorInfo(rs, exFlow);
    }

    Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchUnfinishedFlows() throws ExecutorManagerException {
        try {
            return (Map)this.dbOperator.query(FetchActiveExecutableFlows.FETCH_UNFINISHED_EXECUTABLE_FLOWS, (ResultSetHandler)new FetchActiveExecutableFlows(), new Object[0]);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching unfinished flows", e);
        }
    }

    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchUnfinishedFlowsMetadata() throws ExecutorManagerException {
        try {
            return (Map)this.dbOperator.query(FetchUnfinishedFlowsMetadata.FETCH_UNFINISHED_FLOWS_METADATA, (ResultSetHandler)new FetchUnfinishedFlowsMetadata(), new Object[0]);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching unfinished flows metadata", e);
        }
    }

    Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchActiveFlows() throws ExecutorManagerException {
        try {
            return (Map)this.dbOperator.query(FetchActiveExecutableFlows.FETCH_ACTIVE_EXECUTABLE_FLOWS, (ResultSetHandler)new FetchActiveExecutableFlows(), new Object[0]);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching active flows", e);
        }
    }

    Pair<ExecutionReference, ExecutableFlow> fetchActiveFlowByExecId(int execId) throws ExecutorManagerException {
        try {
            return (Pair)this.dbOperator.query(FetchActiveExecutableFlow.FETCH_ACTIVE_EXECUTABLE_FLOW_BY_EXEC_ID, (ResultSetHandler)new FetchActiveExecutableFlow(), new Object[]{execId});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching active flow by exec id" + execId, e);
        }
    }

    private static class FetchActiveExecutableFlow
    implements ResultSetHandler<Pair<ExecutionReference, ExecutableFlow>> {
        private static final String FETCH_ACTIVE_EXECUTABLE_FLOW_BY_EXEC_ID = "SELECT ex.exec_id exec_id, ex.enc_type enc_type, ex.flow_data flow_data, et.host host, et.port port, ex.executor_id executorId, et.active executorStatus FROM execution_flows ex LEFT JOIN  executors et ON ex.executor_id = et.id Where ex.exec_id = ? AND ex.status NOT IN (" + Status.SUCCEEDED.getNumVal() + ", " + Status.KILLED.getNumVal() + ", " + Status.FAILED.getNumVal() + ") AND NOT (   ex.executor_id IS NULL   AND ex.status = " + Status.PREPARING.getNumVal() + " )";

        private FetchActiveExecutableFlow() {
        }

        public Pair<ExecutionReference, ExecutableFlow> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return null;
            }
            return FetchActiveFlowDao.getExecutableFlowHelper(rs);
        }
    }

    @VisibleForTesting
    static class FetchUnfinishedFlowsMetadata
    implements ResultSetHandler<Map<Integer, Pair<ExecutionReference, ExecutableFlow>>> {
        private static final String FETCH_UNFINISHED_FLOWS_METADATA = "SELECT ex.exec_id exec_id, ex.project_id project_id, ex.version version, ex.flow_id flow_id, et.host host, et.port port, ex.executor_id executorId, ex.status status, ex.submit_time submit_time, ex.start_time start_time, ex.end_time end_time, ex.submit_user submit_user, et.active executorStatus FROM execution_flows ex LEFT JOIN  executors et ON ex.executor_id = et.id Where ex.status NOT IN (" + Status.SUCCEEDED.getNumVal() + ", " + Status.KILLED.getNumVal() + ", " + Status.FAILED.getNumVal() + ")";

        FetchUnfinishedFlowsMetadata() {
        }

        public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyMap();
            }
            HashMap<Integer, Pair<ExecutionReference, ExecutableFlow>> execFlows = new HashMap<Integer, Pair<ExecutionReference, ExecutableFlow>>();
            do {
                Pair exFlow;
                if ((exFlow = FetchActiveFlowDao.getExecutableFlowMetadataHelper(rs)) == null) continue;
                execFlows.put(rs.getInt("exec_id"), exFlow);
            } while (rs.next());
            return execFlows;
        }
    }

    @VisibleForTesting
    static class FetchActiveExecutableFlows
    implements ResultSetHandler<Map<Integer, Pair<ExecutionReference, ExecutableFlow>>> {
        private static final String FETCH_UNFINISHED_EXECUTABLE_FLOWS = "SELECT ex.exec_id exec_id, ex.enc_type enc_type, ex.flow_data flow_data, et.host host, et.port port, ex.executor_id executorId, et.active executorStatus FROM execution_flows ex LEFT JOIN  executors et ON ex.executor_id = et.id Where ex.status NOT IN (" + Status.SUCCEEDED.getNumVal() + ", " + Status.KILLED.getNumVal() + ", " + Status.FAILED.getNumVal() + ")";
        private static final String FETCH_ACTIVE_EXECUTABLE_FLOWS = "SELECT ex.exec_id exec_id, ex.enc_type enc_type, ex.flow_data flow_data, et.host host, et.port port, ex.executor_id executorId, et.active executorStatus FROM execution_flows ex LEFT JOIN  executors et ON ex.executor_id = et.id Where ex.status NOT IN (" + Status.SUCCEEDED.getNumVal() + ", " + Status.KILLED.getNumVal() + ", " + Status.FAILED.getNumVal() + ") AND NOT (   ex.executor_id IS NULL   AND ex.status = " + Status.PREPARING.getNumVal() + " )";

        FetchActiveExecutableFlows() {
        }

        public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyMap();
            }
            HashMap<Integer, Pair<ExecutionReference, ExecutableFlow>> execFlows = new HashMap<Integer, Pair<ExecutionReference, ExecutableFlow>>();
            do {
                Pair exFlow;
                if ((exFlow = FetchActiveFlowDao.getExecutableFlowHelper(rs)) == null) continue;
                execFlows.put(rs.getInt("exec_id"), exFlow);
            } while (rs.next());
            return execFlows;
        }
    }
}

