/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import java.util.Date;

public class ExecutorLogEvent {
    private final int executorId;
    private final String user;
    private final Date time;
    private final EventType type;
    private final String message;

    public ExecutorLogEvent(int executorId, String user, Date time, EventType type, String message) {
        this.executorId = executorId;
        this.user = user;
        this.time = time;
        this.type = type;
        this.message = message;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public String getUser() {
        return this.user;
    }

    public Date getTime() {
        return this.time;
    }

    public EventType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum EventType {
        ERROR(128),
        HOST_UPDATE(1),
        PORT_UPDATE(2),
        ACTIVATION(3),
        INACTIVATION(4),
        CREATED(5);

        private final int numVal;

        private EventType(int numVal) {
            this.numVal = numVal;
        }

        public static EventType fromInteger(int x) throws IllegalArgumentException {
            switch (x) {
                case 1: {
                    return HOST_UPDATE;
                }
                case 2: {
                    return PORT_UPDATE;
                }
                case 3: {
                    return ACTIVATION;
                }
                case 4: {
                    return INACTIVATION;
                }
                case 5: {
                    return CREATED;
                }
                case 128: {
                    return ERROR;
                }
            }
            throw new IllegalArgumentException(String.format("inalid status code %d", x));
        }

        public int getNumVal() {
            return this.numVal;
        }
    }
}

