/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutorInfo;
import azkaban.utils.Utils;
import java.util.Date;

public class Executor
implements Comparable<Executor> {
    private final int id;
    private final String host;
    private final int port;
    private boolean isActive;
    private ExecutorInfo cachedExecutorStats;
    private Date lastStatsUpdatedTime;

    public Executor(int id, String host, int port, boolean isActive) {
        if (!Utils.isValidPort((int)port)) {
            throw new IllegalArgumentException(String.format("Invalid port number %d for host %s, executor_id %d", port, host, id));
        }
        this.id = id;
        this.host = host;
        this.port = port;
        this.isActive = isActive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isActive ? 1231 : 1237);
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Executor)) {
            return false;
        }
        Executor other = (Executor)obj;
        if (this.isActive != other.isActive) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return String.format("%s:%s (id: %s), active=%s", null == this.host || this.host.length() == 0 ? "(empty)" : this.host, this.port, this.id, this.isActive);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public int getId() {
        return this.id;
    }

    public ExecutorInfo getExecutorInfo() {
        return this.cachedExecutorStats;
    }

    public void setExecutorInfo(ExecutorInfo info) {
        this.cachedExecutorStats = info;
        this.lastStatsUpdatedTime = new Date();
    }

    public Date getLastStatsUpdatedTime() {
        return this.lastStatsUpdatedTime;
    }

    @Override
    public int compareTo(Executor o) {
        return null == o ? 1 : this.hashCode() - o.hashCode();
    }
}

