/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.executor.ExecutorDao;
import azkaban.executor.ExecutorManagerException;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AssignExecutorDao {
    private final ExecutorDao executorDao;
    private final DatabaseOperator dbOperator;

    @Inject
    public AssignExecutorDao(DatabaseOperator dbOperator, ExecutorDao executorDao) {
        this.dbOperator = dbOperator;
        this.executorDao = executorDao;
    }

    public void assignExecutor(int executorId, int executionId) throws ExecutorManagerException {
        String UPDATE = "UPDATE execution_flows SET executor_id=? where exec_id=?";
        try {
            if (this.executorDao.fetchExecutor(executorId) == null) {
                throw new ExecutorManagerException(String.format("Failed to assign non-existent executor Id: %d to execution : %d  ", executorId, executionId));
            }
            if (this.dbOperator.update("UPDATE execution_flows SET executor_id=? where exec_id=?", new Object[]{executorId, executionId}) == 0) {
                throw new ExecutorManagerException(String.format("Failed to assign executor Id: %d to non-existent execution : %d  ", executorId, executionId));
            }
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error updating executor id " + executorId, e);
        }
    }

    void unassignExecutor(int executionId) throws ExecutorManagerException {
        String UPDATE = "UPDATE execution_flows SET executor_id=NULL where exec_id=?";
        try {
            int rows = this.dbOperator.update("UPDATE execution_flows SET executor_id=NULL where exec_id=?", new Object[]{executionId});
            if (rows == 0) {
                throw new ExecutorManagerException(String.format("Failed to unassign executor for execution : %d  ", executionId));
            }
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error updating execution id " + executionId, e);
        }
    }
}

