/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.utils.Props;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;

public class DataSourceUtils {
    private static final Logger logger = Logger.getLogger(DataSourceUtils.class);

    private DataSourceUtils() {
    }

    public static AzkabanDataSource getDataSource(Props props) {
        String databaseType = props.getString("database.type");
        AzkabanDataSource dataSource = null;
        if (databaseType.equals("mysql")) {
            int port = props.getInt("mysql.port");
            String host = props.getString("mysql.host");
            String database = props.getString("mysql.database");
            String user = props.getString("mysql.user");
            String password = props.getString("mysql.password");
            int numConnections = props.getInt("mysql.numconnections");
            dataSource = DataSourceUtils.getMySQLDataSource(host, port, database, user, password, numConnections);
        } else if (databaseType.equals("h2")) {
            String path = props.getString("h2.path");
            Path h2DbPath = Paths.get(path, new String[0]).toAbsolutePath();
            logger.info((Object)("h2 DB path: " + h2DbPath));
            dataSource = DataSourceUtils.getH2DataSource(h2DbPath);
        }
        return dataSource;
    }

    public static AzkabanDataSource getMySQLDataSource(String host, Integer port, String dbName, String user, String password, Integer numConnections) {
        return new MySQLBasicDataSource(host, port, dbName, user, password, numConnections);
    }

    public static AzkabanDataSource getH2DataSource(Path file) {
        return new EmbeddedH2BasicDataSource(file);
    }

    public static class EmbeddedH2BasicDataSource
    extends AzkabanDataSource {
        private EmbeddedH2BasicDataSource(Path filePath) {
            String url = "jdbc:h2:file:" + filePath + ";IGNORECASE=TRUE";
            this.setDriverClassName("org.h2.Driver");
            this.setUrl(url);
        }

        @Override
        public boolean allowsOnDuplicateKey() {
            return false;
        }

        @Override
        public String getDBType() {
            return "h2";
        }
    }

    public static class MySQLBasicDataSource
    extends AzkabanDataSource {
        private final String url;

        private MySQLBasicDataSource(String host, int port, String dbName, String user, String password, int numConnections) {
            this.url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
            this.addConnectionProperty("useUnicode", "yes");
            this.addConnectionProperty("characterEncoding", "UTF-8");
            this.setDriverClassName("com.mysql.jdbc.Driver");
            this.setUsername(user);
            this.setPassword(password);
            this.setUrl(this.url);
            this.setMaxTotal(numConnections);
            this.setValidationQuery("/* ping */ select 1");
            this.setTestOnBorrow(true);
        }

        @Override
        public boolean allowsOnDuplicateKey() {
            return true;
        }

        @Override
        public String getDBType() {
            return "mysql";
        }
    }

    public static enum PropertyType {
        DB(1);

        private final int numVal;

        private PropertyType(int numVal) {
            this.numVal = numVal;
        }

        public static PropertyType fromInteger(int x) {
            switch (x) {
                case 1: {
                    return DB;
                }
            }
            return DB;
        }

        public int getNumVal() {
            return this.numVal;
        }
    }
}

