/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.reflection.util;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb2_commons.reflection.util.Accessor;

public class FieldAccessor<T>
implements Accessor<T> {
    private final Field field;

    public FieldAccessor(Class<?> theClass, String fieldName, Class<T> type) {
        try {
            this.field = theClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfex) {
            throw new IllegalArgumentException(MessageFormat.format("Could not retrieve the field [{0}] from the class [{1}].", fieldName, theClass), nsfex);
        }
        catch (SecurityException sex) {
            throw new IllegalArgumentException(MessageFormat.format("Could not retrieve the field [{0}] from the class [{1}].", fieldName, theClass), sex);
        }
        if (!type.equals(this.field.getType())) {
            throw new IllegalArgumentException(MessageFormat.format("The fieldfield [{0}] does not have the expected type [{1}].", this.field, type));
        }
        try {
            this.field.setAccessible(true);
        }
        catch (SecurityException sex) {
            throw new IllegalArgumentException(MessageFormat.format("Could not make the field [{0}] of the class [{1}] accessible.", this.field, theClass), sex);
        }
    }

    @Override
    public T get(Object target) {
        Validate.notNull((Object)target);
        try {
            return (T)this.field.get(target);
        }
        catch (IllegalAccessException iaex) {
            throw new IllegalArgumentException(iaex);
        }
    }

    @Override
    public void set(Object target, T value) {
        Validate.notNull((Object)target);
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException iaex) {
            throw new IllegalArgumentException(iaex);
        }
    }
}

