/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ColumnSet;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.MetadataListStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"serialization.format", "serialization.null.format", "serialization.lib", "serialization.last.column.takes.rest"})
public class MetadataTypedColumnsetSerDe
extends AbstractSerDe {
    public static final Logger LOG = LoggerFactory.getLogger((String)MetadataTypedColumnsetSerDe.class.getName());
    public static final String DefaultSeparator = "\u0001";
    private String separator = "\u0001";
    public static final String defaultNullString = "\\N";
    private String nullString;
    private List<String> columnNames;
    private ObjectInspector cachedObjectInspector;
    private boolean lastColumnTakesRest = false;
    private int splitLimit = -1;
    ColumnSet deserializeCache = new ColumnSet();
    Text serializeCache = new Text();

    public String toString() {
        return "MetaDataTypedColumnsetSerDe[" + this.separator + "," + this.columnNames + "]";
    }

    private String getByteValue(String altValue, String defaultVal) {
        if (altValue != null && altValue.length() > 0) {
            try {
                byte[] b = new byte[]{Byte.parseByte(altValue)};
                return new String(b);
            }
            catch (NumberFormatException e) {
                return altValue;
            }
        }
        return defaultVal;
    }

    @Override
    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        String altSep = tbl.getProperty("serialization.format");
        this.separator = this.getByteValue(altSep, DefaultSeparator);
        String altNull = tbl.getProperty("serialization.null.format");
        this.nullString = this.getByteValue(altNull, defaultNullString);
        String columnProperty = tbl.getProperty("columns");
        String serdeName = tbl.getProperty("serialization.lib");
        boolean columnsetSerDe = false;
        if (serdeName != null && serdeName.equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
            columnsetSerDe = true;
        }
        if (columnProperty == null || columnProperty.length() == 0 || columnsetSerDe) {
            this.cachedObjectInspector = ObjectInspectorFactory.getReflectionObjectInspector(ColumnSet.class, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        } else {
            this.columnNames = Arrays.asList(columnProperty.split(","));
            this.cachedObjectInspector = MetadataListStructObjectInspector.getInstance(this.columnNames);
        }
        String lastColumnTakesRestString = tbl.getProperty("serialization.last.column.takes.rest");
        this.lastColumnTakesRest = lastColumnTakesRestString != null && lastColumnTakesRestString.equalsIgnoreCase("true");
        this.splitLimit = this.lastColumnTakesRest && this.columnNames != null ? this.columnNames.size() : -1;
        LOG.debug(this.getClass().getName() + ": initialized with columnNames: " + this.columnNames + " and separator code=" + this.separator.charAt(0) + " lastColumnTakesRest=" + this.lastColumnTakesRest + " splitLimit=" + this.splitLimit);
    }

    public static Object deserialize(ColumnSet c, String row, String sep, String nullString, int limit) throws Exception {
        String[] l1;
        if (c.col == null) {
            c.col = new ArrayList();
        } else {
            c.col.clear();
        }
        for (String s : l1 = row.split(sep, limit)) {
            if (s.equals(nullString)) {
                c.col.add(null);
                continue;
            }
            c.col.add(s);
        }
        return c;
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        String row = null;
        if (field instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)field;
            try {
                row = Text.decode((byte[])b.getBytes(), (int)0, (int)b.getLength());
            }
            catch (CharacterCodingException e) {
                throw new SerDeException(e);
            }
        } else if (field instanceof Text) {
            row = field.toString();
        }
        try {
            MetadataTypedColumnsetSerDe.deserialize(this.deserializeCache, row, this.separator, this.nullString, this.splitLimit);
            if (this.columnNames != null) assert (this.columnNames.size() == this.deserializeCache.col.size());
            return this.deserializeCache;
        }
        catch (ClassCastException e) {
            throw new SerDeException(this.getClass().getName() + " expects Text or BytesWritable", e);
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(this.separator);
            }
            Object column = soi.getStructFieldData(obj, fields.get(i));
            if (fields.get(i).getFieldObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                sb.append(column == null ? this.nullString : column.toString());
                continue;
            }
            sb.append(SerDeUtils.getJSONString(column, fields.get(i).getFieldObjectInspector()));
        }
        this.serializeCache.set(sb.toString());
        return this.serializeCache;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }
}

