/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.util;

import com.github.pagehelper.PageException;
import com.github.pagehelper.PageProperties;
import com.github.pagehelper.util.StringUtil;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class ClassUtil {
    public static <T> T newInstance(String classStr, Class<T> spi, Properties properties, Supplier<T> defaultSupplier) {
        ServiceLoader<T> loader;
        Iterator<T> iterator;
        if (StringUtil.isNotEmpty(classStr)) {
            try {
                Class<?> cls = Class.forName(classStr);
                return (T)ClassUtil.newInstance(cls, properties);
            }
            catch (Exception cls) {
                // empty catch block
            }
        }
        T result = null;
        if (spi != null && (iterator = (loader = ServiceLoader.load(spi)).iterator()).hasNext()) {
            T t = iterator.next();
            result = t;
        }
        if (result == null) {
            result = defaultSupplier.get();
        }
        if (result instanceof PageProperties) {
            ((PageProperties)result).setProperties(properties);
        }
        return result;
    }

    public static <T> T newInstance(String classStr, Properties properties) {
        try {
            Class<?> cls = Class.forName(classStr);
            return (T)ClassUtil.newInstance(cls, properties);
        }
        catch (Exception e) {
            throw new PageException(e);
        }
    }

    public static <T> T newInstance(Class<T> cls, Properties properties) {
        try {
            T instance = cls.newInstance();
            if (instance instanceof PageProperties) {
                ((PageProperties)instance).setProperties(properties);
            }
            return instance;
        }
        catch (Exception e) {
            throw new PageException(e);
        }
    }
}

