/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwProject;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Function;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowType;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.enums.EngineType;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.assistant.converter.AbstractDwNodeConverter;
import com.aliyun.migration.workflow.migration.assistant.converter.DwConverterFactory;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwAssistantPackageTransform {
    private static final Logger log = LoggerFactory.getLogger(DwAssistantPackageTransform.class);
    private BwmConfiguration taskContextConf;

    public DataWorksPackage translate(WorkflowProjectPackage workflowProjectPackage, BwmConfiguration taskContextConf) {
        this.taskContextConf = taskContextConf;
        DataWorksPackage assistantPackage = new DataWorksPackage();
        try {
            assistantPackage.setUuid(workflowProjectPackage.getWorkflowProject().getProjectId());
        }
        catch (Exception e) {
            log.error("Cannot get projectId in workflowPackage", (Throwable)e);
            return null;
        }
        try {
            DwProject assistantProject = new DwProject();
            assistantProject.setUniqueId(Long.valueOf(Long.parseLong(workflowProjectPackage.getWorkflowProject().getProjectId())));
            assistantProject.setName(workflowProjectPackage.getWorkflowProject().getName());
            assistantProject.setWorkflows(this.workflowTrans(workflowProjectPackage.getWorkflowList(), workflowProjectPackage.getFilePath()));
            assistantPackage.setDwProject(assistantProject);
        }
        catch (Exception e) {
            log.error("AssistantProject\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        return assistantPackage;
    }

    private List<Workflow> workflowTrans(List<com.aliyun.migration.teleport.common.element.meta.workflow.Workflow> workflowList, String filePath) throws IOException {
        ArrayList<Workflow> assistantWorkflowList = new ArrayList<Workflow>();
        for (com.aliyun.migration.teleport.common.element.meta.workflow.Workflow workflow : workflowList) {
            Workflow assistantWorkflow = new Workflow();
            assistantWorkflow.setUniqueId(Long.valueOf(Long.parseLong(workflow.getProjectId())));
            assistantWorkflow.setName(workflow.getWorkflowName());
            assistantWorkflow.setOwner(workflow.getOwner());
            assistantWorkflow.setResources(this.resourceTrans(workflow.getFiles(), workflow.getWorkflowName()));
            assistantWorkflow.setFunctions(this.functionTrans(workflow.getFunctions(), workflow.getWorkflowName()));
            assistantWorkflow.setNodes(this.nodeTrans(workflow.getWorkflowNodes(), filePath));
            if (workflow.getCustomProperties() != null && workflow.getCustomProperties().containsKey("UseType") && workflow.getCustomProperties().get("UseType").equals("MANUAL_BIZ")) {
                assistantWorkflow.setType(WorkflowType.MANUAL_BUSINESS);
                assistantWorkflow.setScheduled(Boolean.valueOf(false));
                for (Node assistantNode : assistantWorkflow.getNodes()) {
                    assistantNode.setPauseSchedule(Boolean.valueOf(true));
                    assistantNode.setNodeUseType(NodeUseType.MANUAL);
                    if (assistantNode.getFolder().startsWith("\u624b\u52a8")) continue;
                    assistantNode.setFolder("\u624b\u52a8" + assistantNode.getFolder());
                }
            } else {
                assistantWorkflow.setType(WorkflowType.BUSINESS);
                assistantWorkflow.setScheduled(Boolean.valueOf(true));
                for (Node assistantNode : assistantWorkflow.getNodes()) {
                    if (!assistantNode.getNodeUseType().equals((Object)NodeUseType.MANUAL)) continue;
                    assistantNode.setPauseSchedule(Boolean.valueOf(false));
                    assistantNode.setNodeUseType(NodeUseType.SCHEDULED);
                    if (!assistantNode.getFolder().startsWith("\u624b\u52a8")) continue;
                    assistantNode.setFolder(assistantNode.getFolder().substring("\u624b\u52a8".length()));
                }
            }
            assistantWorkflowList.add(assistantWorkflow);
        }
        return assistantWorkflowList;
    }

    private List<Resource> resourceTrans(List<WorkflowFileResource> resourceList, String projectName) {
        ArrayList<Resource> assistantResourceList = new ArrayList<Resource>();
        for (WorkflowFileResource resource : resourceList) {
            Resource assistantResource = new Resource();
            try {
                assistantResource.setUniqueId(Long.valueOf(Long.parseLong(resource.getId())));
            }
            catch (NumberFormatException e) {
                log.warn("Resource Id\u975e\u6570\u5b57\u6216\u7f3a\u5931");
            }
            assistantResource.setGlobalUuid(resource.getId());
            assistantResource.setName(resource.getName());
            assistantResource.setType(resource.getFileType());
            if (resource.getFolder().length() == 0) {
                assistantResource.setPath(resource.getName());
            } else {
                assistantResource.setPath(resource.getFolder() + resource.getName());
            }
            assistantResource.setOriginResourceName(resource.getName());
            if (resource.getFileType() != null && resource.getFileType().contains("ODPS")) {
                assistantResource.setFolder("Business Flow/" + projectName + "/folder" + EngineType.MAXCOMPUTE.getEngineName());
                assistantResource.setOdps(Boolean.valueOf(true));
                assistantResource.setConnection(EngineType.MAXCOMPUTE.getEngineName());
            } else if (resource.getFileType() != null && resource.getFileType().contains("EMR")) {
                assistantResource.setFolder("Business Flow/" + projectName + "/folder" + EngineType.EMR.getEngineName());
                assistantResource.setOdps(Boolean.valueOf(false));
                if (resource.getCustomProperties() != null && resource.getCustomProperties().get("workflow.converter.target.engine.datasource.name") != null) {
                    assistantResource.setConnection(resource.getCustomProperties().get("workflow.converter.target.engine.datasource.name").toString());
                } else {
                    assistantResource.setConnection(EngineType.EMR.getEngineName());
                }
            } else {
                log.error("cannot recognize resource type, resource: {}", (Object)resource);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)resource.getFolder())) {
                assistantResource.setFolder(assistantResource.getFolder() + "/" + resource.getFolder());
            }
            assistantResourceList.add(assistantResource);
        }
        return assistantResourceList;
    }

    private List<Function> functionTrans(List<WorkflowFunctionResource> functionList, String projectName) {
        ArrayList<Function> assistantFunctionList = new ArrayList<Function>();
        for (WorkflowFunctionResource functionResource : functionList) {
            Function assistantFunction = new Function();
            if (functionResource.getDatasource() != null) {
                assistantFunction.setUniqueId(functionResource.getDatasource().getId());
            }
            assistantFunction.setName(functionResource.getName());
            assistantFunction.setType(functionResource.getType());
            assistantFunction.setClazz(functionResource.getClassName());
            assistantFunction.setResource(functionResource.getFileResources());
            assistantFunction.setDescription(functionResource.getUsageDescription());
            if (functionResource.getType().contains("ODPS")) {
                assistantFunction.setFolder("Business Flow/" + projectName + "/folder" + EngineType.MAXCOMPUTE.getEngineName());
                assistantFunction.setIsOdps(Boolean.valueOf(true));
                assistantFunction.setConnection(EngineType.MAXCOMPUTE.getEngineName());
            } else if (functionResource.getType().contains("EMR")) {
                assistantFunction.setFolder("Business Flow/" + projectName + "/folder" + EngineType.EMR.getEngineName());
                assistantFunction.setIsOdps(Boolean.valueOf(false));
                if (functionResource.getCustomProperties().get("workflow.converter.target.engine.datasource.name") != null) {
                    assistantFunction.setConnection(functionResource.getCustomProperties().get("workflow.converter.target.engine.datasource.name").toString());
                } else {
                    assistantFunction.setConnection(EngineType.EMR.getEngineName());
                }
            }
            assistantFunctionList.add(assistantFunction);
        }
        return assistantFunctionList;
    }

    private List<Node> nodeTrans(List<WorkflowNode> nodeList, String filePath) throws IOException {
        ArrayList<Node> assistantWorkflowNodeList = new ArrayList<Node>();
        for (WorkflowNode node : nodeList) {
            AbstractDwNodeConverter converter = DwConverterFactory.buildConvert(node.getNodeType(), this.taskContextConf);
            Node assistantNode = new Node();
            try {
                assistantNode = converter.convert(node);
            }
            catch (Exception e) {
                log.error("Node\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            assistantWorkflowNodeList.add(assistantNode);
        }
        return assistantWorkflowNodeList;
    }

    private Date dateTimeTrans(LocalDateTime localDateTime) {
        try {
            return Date.from(localDateTime.toInstant(ZoneOffset.ofTotalSeconds(0)));
        }
        catch (Exception e) {
            log.warn("Trigger\u4e2d\u7684DateTime\u8f6c\u6362\u5931\u8d25\u6216\u7f3a\u5931", (Throwable)e);
            return null;
        }
    }

    private List<NodeIo> outputTrans(WorkflowNode node) {
        ArrayList<NodeIo> assistantOutputList = new ArrayList<NodeIo>();
        NodeIo localNodeOutput = new NodeIo();
        localNodeOutput.setData(node.getProjectName() + "." + node.getNodeName());
        localNodeOutput.setParseType(Integer.valueOf(1));
        assistantOutputList.add(localNodeOutput);
        NodeIo downflowNodeOutput = new NodeIo();
        downflowNodeOutput.setData(node.getProjectName() + "." + node.getNodeName() + "_out");
        downflowNodeOutput.setParseType(Integer.valueOf(2));
        assistantOutputList.add(downflowNodeOutput);
        return assistantOutputList;
    }

    private List<NodeIo> inputTrans(WorkflowNode node, List<WorkflowNode> nodeList) {
        ArrayList<NodeIo> assistantInputList = new ArrayList<NodeIo>();
        for (WorkflowNode parent : nodeList) {
            try {
                for (WorkflowNode child : parent.getChildren()) {
                    try {
                        if (!StringUtils.equals((CharSequence)child.getNodeName(), (CharSequence)node.getNodeName())) continue;
                        NodeIo assistantDatasource = new NodeIo();
                        assistantDatasource.setData(parent.getProjectName() + "." + parent.getNodeName() + "_out");
                        assistantDatasource.setParseType(Integer.valueOf(1));
                        assistantInputList.add(assistantDatasource);
                    }
                    catch (Exception e) {
                        log.error("\u5b50\u8282\u70b9\u975e\u6cd5\uff1a{}", (Object)child.getNodeName());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u7236\u8282\u70b9\u975e\u6cd5\uff1a{}", (Object)parent.getNodeName());
            }
        }
        return assistantInputList;
    }
}

