/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.module;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Writer;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.assistant.utils.DwAssisantPackageFileService;
import com.aliyun.migration.workflow.migration.assistant.utils.DwAssisantTaskTool;
import com.aliyun.migration.workflow.migration.assistant.utils.DwAssistantClient;
import com.aliyun.migration.workflow.migration.common.AbstractWriter;
import com.aliyun.migration.workflow.migration.common.config.WriterProjectMappingRuleGroup;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwAssistantWriter
extends AbstractWriter {
    private static final Logger log = LoggerFactory.getLogger(DwAssistantWriter.class);
    private Long projectId;
    private DwAssistantClient dwAssistantClient;
    private DwAssisantTaskTool dwAssisantTaskTool;
    private WorkflowProjectPackage workflowProjectPackage;
    private String filePath;

    public Writer init(TaskContext taskContext) {
        this.taskContext = taskContext;
        Datasource scheduleDataSource = taskContext.getWriterDatasource();
        Map properties = scheduleDataSource.getProperties();
        String endpoint = (String)properties.get("endpoint");
        String projectStr = (String)properties.get("project_id");
        String projectNameStr = (String)properties.get("project_name");
        this.filePath = (String)properties.get("export-file-path");
        if (!NumberUtils.isDigits((String)projectStr)) {
            log.error("project not number or not found");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PROJECT_CONF_NOT_FOUND);
        }
        this.projectId = Long.parseLong(projectStr);
        String ak = (String)properties.get("ak");
        String sk = (String)properties.get("sk");
        String env_ak = System.getenv("LHM_DW_AK");
        String env_sk = System.getenv("LHM_DW_SK");
        if (StringUtils.isNotBlank((CharSequence)env_ak) && StringUtils.isNotBlank((CharSequence)env_sk)) {
            ak = env_ak;
            sk = env_sk;
        }
        this.dwAssisantTaskTool = new DwAssisantTaskTool(endpoint, ak, sk);
        this.dwAssistantClient = this.dwAssisantTaskTool.getDwAssistantClient();
        this.workflowProjectPackage = this.getWorkflowProjectPackage(scheduleDataSource, taskContext);
        if (StringUtils.isBlank((CharSequence)taskContext.getBwmConfiguration())) {
            taskContext.setBwmConfiguration("{}");
        }
        log.info("\u5f53\u524d\u914d\u7f6e\u63d0\u4ea4\u89c4\u5219\uff1a{}", (Object)JSONObject.toJSONString((Object)taskContext.getBwmConfiguration(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        WriterProjectMappingRuleGroup writerProjectMappingRuleGroup = taskContext.getBwmConfiguration() == null || !taskContext.getBwmConfiguration().contains("project.mapping") ? new WriterProjectMappingRuleGroup(null, projectStr, projectNameStr) : new WriterProjectMappingRuleGroup(JSONObject.parseObject((String)taskContext.getBwmConfiguration()).get("project.mapping").toString(), projectStr, projectNameStr);
        this.freshProjectInfoInPackage(writerProjectMappingRuleGroup);
        this.splitWorkflowByTargetProject();
        this.globalCheckNodeNameOnlyValidate(this.workflowProjectPackage.getWorkflowList());
        this.freshParentOutputInPackage();
        this.taskContext.setWorkflowProjectPackage(this.workflowProjectPackage);
        return this;
    }

    private void freshParentOutputInPackage() {
        HashMap nodeIdOutputMap = new HashMap();
        HashMap nodeMap = new HashMap();
        this.workflowProjectPackage.getWorkflowList().forEach(wf -> wf.getWorkflowNodes().forEach(node -> {
            nodeIdOutputMap.put(node.getNodeId(), String.format("%s.%s_out", node.getProjectName(), node.getNodeId()));
            nodeMap.put(node.getNodeId(), node);
        }));
        this.workflowProjectPackage.getWorkflowList().forEach(wf -> wf.getNodeRelations().forEach(relation -> {
            if (relation.getReType().equals((Object)RelationPackage.ReType.NODE)) {
                String from = relation.getFrom();
                String to = relation.getTo();
                if (nodeMap.containsKey(from) && nodeMap.containsKey(to)) {
                    if (((WorkflowNode)nodeMap.get(to)).getParentTargetIds() == null) {
                        ((WorkflowNode)nodeMap.get(to)).setParentTargetIds(new ArrayList());
                    }
                    if (!((WorkflowNode)nodeMap.get(to)).getParentTargetIds().contains(nodeIdOutputMap.get(from))) {
                        ((WorkflowNode)nodeMap.get(to)).getParentTargetIds().add((String)nodeIdOutputMap.get(from));
                    }
                }
            }
        }));
        this.workflowProjectPackage.getWorkflowList().forEach(wf -> wf.getWorkflowNodes().forEach(node -> {
            if (node.getParentTargetIds() == null) {
                node.setParentTargetIds(List.of(node.getProjectName() + "_root"));
            }
        }));
    }

    private void splitWorkflowByTargetProject() {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        ArrayList newWorkflowList = new ArrayList();
        for (Workflow workflow : workflowList) {
            HashMap<String, Workflow> projectWorkflowMap = new HashMap<String, Workflow>();
            Workflow defaultWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
            defaultWorkflow.setWorkflowNodes(new ArrayList());
            projectWorkflowMap.put(defaultWorkflow.getProjectId(), defaultWorkflow);
            for (WorkflowNode node : workflow.getWorkflowNodes()) {
                String targetProjectId = node.getProjectId();
                if (!projectWorkflowMap.containsKey(targetProjectId)) {
                    Workflow newWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)workflow, Workflow.class);
                    newWorkflow.setProjectId(node.getProjectId());
                    newWorkflow.setProjectName(node.getProjectName());
                    newWorkflow.setWorkflowNodes(new ArrayList());
                    projectWorkflowMap.put(targetProjectId, newWorkflow);
                }
                ((Workflow)projectWorkflowMap.get(targetProjectId)).getWorkflowNodes().add(node);
            }
            newWorkflowList.addAll(projectWorkflowMap.values());
        }
        this.workflowProjectPackage.setWorkflowList(newWorkflowList);
    }

    private void freshProjectInfoInPackage(WriterProjectMappingRuleGroup writerProjectMappingRuleGroup) {
        List workflowList = this.workflowProjectPackage.getWorkflowList();
        for (Workflow workflow : workflowList) {
            Pair targetProjectInfo = writerProjectMappingRuleGroup.getTargetProjectId4Workflow(workflow);
            workflow.setProjectId((String)targetProjectInfo.getKey());
            workflow.setProjectName((String)targetProjectInfo.getValue());
            this.supplyFileAndFunction(workflow.getFiles(), workflow.getFunctions(), (String)targetProjectInfo.getKey());
            List workflowNodes = workflow.getWorkflowNodes();
            for (WorkflowNode node : workflowNodes) {
                node.setWorkflowName(workflow.getWorkflowName());
                node.setWorkflowId(workflow.getWorkflowId());
                targetProjectInfo = writerProjectMappingRuleGroup.getTargetProjectId4Node(node);
                node.setProjectName((String)targetProjectInfo.getValue());
                node.setProjectId((String)targetProjectInfo.getKey());
                this.supplyFileAndFunction(node.getFiles(), node.getFunctions(), (String)targetProjectInfo.getKey());
                node.setWorkflowName(workflow.getWorkflowName());
                if (Objects.isNull(this.workflowProjectPackage.getFilePath())) {
                    log.warn("not.found.project.prefix.path");
                }
                this.supplyTriggerNode(workflow.getTriggers(), node);
                node.setScriptPathPreFix(this.workflowProjectPackage.getFilePath());
                this.adaptNodeType(node);
            }
        }
    }

    private void supplyTriggerNode(List<WorkflowTrigger> triggers, WorkflowNode workflowNode) {
        if (CollectionUtils.isEmpty(triggers)) {
            return;
        }
        WorkflowTrigger workflowTrigger = triggers.get(0);
        workflowNode.setTrigger(workflowTrigger);
    }

    private void supplyFileAndFunction(List<WorkflowFileResource> fileResources, List<WorkflowFunctionResource> functionResources, String projectIdStr) {
        ((List)Optional.ofNullable(fileResources).orElse(new ArrayList())).forEach(fileResource -> {
            if (!StringUtils.equals((CharSequence)fileResource.getProjectId(), (CharSequence)projectIdStr)) {
                fileResource.setProjectId(projectIdStr);
            }
        });
        ((List)Optional.ofNullable(functionResources).orElse(new ArrayList())).forEach(functionResource -> {
            if (!StringUtils.equals((CharSequence)functionResource.getProjectId(), (CharSequence)projectIdStr)) {
                functionResource.setProjectId(projectIdStr);
            }
        });
    }

    private WorkflowProjectPackage getWorkflowProjectPackage(Datasource scheduleDataSource, TaskContext taskContext) {
        if (Objects.nonNull(taskContext) && Objects.nonNull(taskContext.getWorkflowProjectPackage())) {
            this.filePath = (String)scheduleDataSource.getProperties().get("export-file-path");
            return taskContext.getWorkflowProjectPackage();
        }
        Map properties = scheduleDataSource.getProperties();
        String filePath = (String)properties.get("source-file-path");
        WorkflowProjectPackage workflowProjectPackage = BwmPackageFileOperator.readFile((String)filePath);
        if (Objects.isNull(workflowProjectPackage)) {
            log.error("get.workflowProjectPackage.error");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.WORKFLOW_PACKAGE_NOT_FOUND);
        }
        return workflowProjectPackage;
    }

    private void adaptNodeType(WorkflowNode node) {
        if (node.getNodeType().equals("VI")) {
            node.setNodeType(String.valueOf(CodeProgramType.VIRTUAL.getCode()));
        } else if (node.getNodeType().equals("SQL")) {
            node.setNodeType(String.valueOf(CodeProgramType.ODPS_SQL.getCode()));
        } else {
            CodeProgramType codeProgramType = BwmCommonUtil.getCodeType((String)node.getNodeType());
            Optional.ofNullable(codeProgramType).ifPresent(x -> {
                int code = x.getCode();
                node.setNodeType(String.valueOf(code));
            });
        }
    }

    public String write() {
        DwAssisantPackageFileService dwAssisantPackageFileService = new DwAssisantPackageFileService();
        List<WorkflowProjectPackage> workflowProjectPackages = this.splitPackageByTargetProject();
        workflowProjectPackages = this.splitPackageBySize(workflowProjectPackages);
        BwmConfiguration bwmConf = this.taskContext.getBwmConfiguration() == null ? BwmConfiguration.newDefault() : BwmConfiguration.from((String)this.taskContext.getBwmConfiguration());
        HashMap<String, List<String>> filePathList = new HashMap<String, List<String>>();
        for (WorkflowProjectPackage pkg : workflowProjectPackages) {
            try {
                String pkgFilePath = this.filePath;
                if (pkgFilePath.endsWith(".zip")) {
                    pkgFilePath = pkgFilePath.substring(0, pkgFilePath.length() - 4);
                }
                pkgFilePath = pkg.getVersion() == null || pkg.getVersion().equals("0") ? String.format("%s_%s.zip", pkgFilePath, pkg.getWorkflowProject().getProjectId()) : String.format("%s_%s_%s.zip", pkgFilePath, pkg.getWorkflowProject().getProjectId(), pkg.getVersion());
                dwAssisantPackageFileService.savePackageZip(pkg, pkgFilePath, bwmConf);
                if (!filePathList.containsKey(pkg.getWorkflowProject().getProjectId())) {
                    filePathList.put(pkg.getWorkflowProject().getProjectId(), new ArrayList());
                }
                ((List)filePathList.get(pkg.getWorkflowProject().getProjectId())).add(pkgFilePath);
            }
            catch (Exception e) {
                log.error("WorkflowProjectPackage\u751f\u6210\u8fc1\u79fb\u52a9\u624b\u5bfc\u5165\u5305\u5931\u8d25\uff01", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        Map<String, Object> commitRule = this.getCommitRuleFromConf();
        try {
            this.dwAssistantClient.importFilesOneByOne(filePathList, JSONObject.toJSONString(commitRule, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        catch (Exception e) {
            log.error("\u8fc1\u79fb\u52a9\u624b\u5bfc\u5165\u5931\u8d25\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    protected Map<String, Object> getCommitRuleFromConf() {
        HashMap<String, Object> commitRule = new HashMap<String, Object>();
        JSONObject bwmConf = JSONObject.parseObject((String)this.taskContext.getBwmConfiguration());
        if (bwmConf != null && bwmConf.containsKey("conf")) {
            if (bwmConf.getJSONObject("conf").containsKey("resourceAutoCommit")) {
                commitRule.put("resourceAutoCommit", bwmConf.getJSONObject("conf").getBoolean("resourceAutoCommit"));
            } else {
                commitRule.put("resourceAutoCommit", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("resourceAutoDeploy")) {
                commitRule.put("resourceAutoDeploy", bwmConf.getJSONObject("conf").getBoolean("resourceAutoDeploy"));
            } else {
                commitRule.put("resourceAutoDeploy", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("functionAutoCommit")) {
                commitRule.put("functionAutoCommit", bwmConf.getJSONObject("conf").getBoolean("functionAutoCommit"));
            } else {
                commitRule.put("functionAutoCommit", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("functionAutoDeploy")) {
                commitRule.put("functionAutoDeploy", bwmConf.getJSONObject("conf").getBoolean("functionAutoDeploy"));
            } else {
                commitRule.put("functionAutoDeploy", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("tableAutoCommitToDev")) {
                commitRule.put("tableAutoCommitToDev", bwmConf.getJSONObject("conf").getBoolean("tableAutoCommitToDev"));
            } else {
                commitRule.put("tableAutoCommitToDev", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("tableAutoCommitToProd")) {
                commitRule.put("tableAutoCommitToProd", bwmConf.getJSONObject("conf").getBoolean("tableAutoCommitToProd"));
            } else {
                commitRule.put("tableAutoCommitToProd", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("ignoreLock")) {
                commitRule.put("ignoreLock", bwmConf.getJSONObject("conf").getBoolean("ignoreLock"));
            } else {
                commitRule.put("ignoreLock", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("fileAutoCommit")) {
                commitRule.put("fileAutoCommit", bwmConf.getJSONObject("conf").getBoolean("fileAutoCommit"));
            } else {
                commitRule.put("fileAutoCommit", false);
            }
            if (bwmConf.getJSONObject("conf").containsKey("fileAutoDeploy")) {
                commitRule.put("fileAutoDeploy", bwmConf.getJSONObject("conf").getBoolean("fileAutoDeploy"));
            } else {
                commitRule.put("fileAutoDeploy", false);
            }
        } else {
            commitRule.put("resourceAutoCommit", false);
            commitRule.put("resourceAutoDeploy", false);
            commitRule.put("functionAutoCommit", false);
            commitRule.put("functionAutoDeploy", false);
            commitRule.put("tableAutoCommitToDev", false);
            commitRule.put("tableAutoCommitToProd", false);
            commitRule.put("ignoreLock", false);
            commitRule.put("fileAutoCommit", false);
            commitRule.put("fileAutoDeploy", false);
        }
        return commitRule;
    }

    protected List<WorkflowProjectPackage> splitPackageByTargetProject() {
        HashMap<String, WorkflowProjectPackage> workflowProjectPackages = new HashMap<String, WorkflowProjectPackage>();
        for (Workflow workflow : this.workflowProjectPackage.getWorkflowList()) {
            if (!workflowProjectPackages.containsKey(workflow.getProjectId())) {
                WorkflowProjectPackage newPkg = (WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)this.workflowProjectPackage, WorkflowProjectPackage.class);
                newPkg.setWorkflowList(new ArrayList());
                newPkg.getWorkflowProject().setProjectId(workflow.getProjectId());
                newPkg.getWorkflowProject().setName(workflow.getProjectName());
                workflowProjectPackages.put(workflow.getProjectId(), newPkg);
            }
            ((WorkflowProjectPackage)workflowProjectPackages.get(workflow.getProjectId())).getWorkflowList().add(workflow);
        }
        return workflowProjectPackages.values().stream().toList();
    }

    protected List<WorkflowProjectPackage> splitPackageBySize(List<WorkflowProjectPackage> orgPkgs) {
        ArrayList<WorkflowProjectPackage> newPkgs = new ArrayList<WorkflowProjectPackage>();
        for (WorkflowProjectPackage orgPkg : orgPkgs) {
            newPkgs.addAll(this.splitSinglePackageBySize(orgPkg));
        }
        return newPkgs;
    }

    protected List<WorkflowProjectPackage> splitSinglePackageBySize(WorkflowProjectPackage orgPkg) {
        ArrayList<WorkflowProjectPackage> newPkgs = new ArrayList<WorkflowProjectPackage>();
        Long nodeCounter = 0L;
        WorkflowProjectPackage newPkg = new WorkflowProjectPackage();
        for (Workflow wf : orgPkg.getWorkflowList()) {
            if (nodeCounter == 0L) {
                newPkg = (WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)orgPkg, WorkflowProjectPackage.class);
                newPkg.setWorkflowList(new ArrayList());
                newPkgs.add(newPkg);
            }
            newPkg.getWorkflowList().add(wf);
            if ((nodeCounter = Long.valueOf(nodeCounter + (long)wf.getWorkflowNodes().size())) < 10000L) continue;
            nodeCounter = 0L;
        }
        Integer index = 0;
        while (index < newPkgs.size()) {
            ((WorkflowProjectPackage)newPkgs.get(index)).setVersion(String.valueOf(index));
            Integer n = index;
            index = index + 1;
        }
        return newPkgs;
    }

    public String export() {
        return null;
    }

    protected void createFolder(String folderPath, String projectId, String workflowName) {
    }

    protected Long getExistedNode(WorkflowNode workflowNode) {
        return 0L;
    }

    protected Long existWorkflowId(Workflow workflow) {
        return 0L;
    }

    protected Long createWorkflowBaseReal(Workflow workflow) throws Exception {
        return 0L;
    }

    protected Object createResourceFileReal(WorkflowFileResource workflowFileResource, String projectId, String workflowName) throws Exception {
        return null;
    }

    protected void deleteResourceFile(long projectId, long fileId) throws Exception {
    }

    protected Object createFunctionReal(WorkflowFunctionResource workflowFunctionResource, String projectId, String workflowName) throws Exception {
        return null;
    }

    protected Long createNodeReal(WorkflowNode workflowNode) throws Exception {
        return 0L;
    }

    protected Long updateNodeReal(WorkflowNode workflowNode, String fieldId) throws Exception {
        return 0L;
    }

    protected void submitReal(String projectId, String fieldId) {
    }

    protected Long existResourceFileId(WorkflowFileResource workflowFileResource, String projectId) {
        return 0L;
    }

    public void close() {
        try {
            FileUtils.forceDeleteOnExit((File)new File(this.filePath));
        }
        catch (IOException e) {
            log.error("delete filePath error", (Throwable)e);
        }
    }
}

