/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.module;

import com.aliyun.migration.api.context.StatisticOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DwAssistantStatusType {
    DOING("doing", "doingCount", "", "", StatisticOp.StatisticItemEnum.TEMP),
    NOTSTART("notStart", "notStartCount", "", "", StatisticOp.StatisticItemEnum.TEMP),
    SUCCESS("success", "successCount", "IMPORT_SUCCESS", "SuccessStatisticOp", StatisticOp.StatisticItemEnum.SUCCESS),
    TOTAL("total", "totalCount", "", "TotalStatisticOp", StatisticOp.StatisticItemEnum.TOTAL),
    FAILURE("failure", "failureCount", "IMPORT_ERROR", "FailureStatisticOp", StatisticOp.StatisticItemEnum.FAILURE);

    private String name;
    private String countName;
    private String statusName;
    private String pieceNameIntaskContext;
    private StatisticOp.StatisticItemEnum statisticItemEnum;
    private static final Map<String, DwAssistantStatusType> COMMAND_TYPE_MAP;

    private DwAssistantStatusType(String name, String countName, String statusName, String pieceNameIntaskContext, StatisticOp.StatisticItemEnum statisticItemEnum) {
        this.name = name;
        this.countName = countName;
        this.statusName = statusName;
        this.pieceNameIntaskContext = pieceNameIntaskContext;
        this.statisticItemEnum = statisticItemEnum;
    }

    public String getName() {
        return this.name;
    }

    public String getCountName() {
        return this.countName;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getPieceNameIntaskContext() {
        return this.pieceNameIntaskContext;
    }

    public StatisticOp.StatisticItemEnum getStatisticItemEnum() {
        return this.statisticItemEnum;
    }

    public static DwAssistantStatusType of(String name) {
        return COMMAND_TYPE_MAP.get(name);
    }

    public static List<String> getStutusCountNameList() {
        ArrayList<String> statusList = new ArrayList<String>();
        for (DwAssistantStatusType statusType : DwAssistantStatusType.values()) {
            statusList.add(statusType.getCountName());
        }
        return statusList;
    }

    static {
        COMMAND_TYPE_MAP = new HashMap<String, DwAssistantStatusType>();
        for (DwAssistantStatusType dwAssistantStatusType : DwAssistantStatusType.values()) {
            COMMAND_TYPE_MAP.put(dwAssistantStatusType.name, dwAssistantStatusType);
        }
    }
}

