/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.css;

import com.alibaba.security.css.CSSProcessHandler;
import com.alibaba.security.css.handler.LexicalUnitHandler;
import com.alibaba.security.css.handler.RgbColorLexicalUnitHandler;
import com.alibaba.security.css.selector.CSSSelector;
import com.alibaba.security.css.w3cinterface.CSSException;
import com.alibaba.security.css.w3cinterface.InputSource;
import com.alibaba.security.css.w3cinterface.LexicalUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DefaultDocumentHandler
implements CSSProcessHandler {
    public static final DefaultDocumentHandler INSTANCE = new DefaultDocumentHandler(new StringBuilder());
    private static final String ABSOLUTE_PROP_VALUE = "(absolute)";
    private static final String RELATIVE_PROP_VALUE = "(relative)";
    private static final String EXPRESSION_VALUE = "(expression)";
    private static final String OCTALCHAR = "(\\\\[0-9a-zA-Z]{1,2})";
    private static String ZINDEX_PROP = "z-index";
    protected StringBuilder styleSheet = null;
    private static final Pattern forbiddenAttr = Pattern.compile("(absolute)|(relative)|(expression)|(\\\\[0-9a-zA-Z]{1,2})");
    private final Map<Short, LexicalUnitHandler> lexicalUnitHandlerMap = new HashMap<Short, LexicalUnitHandler>(){
        {
            this.put((short)27, new RgbColorLexicalUnitHandler());
        }
    };

    public DefaultDocumentHandler(StringBuilder buffer) {
        this.styleSheet = buffer;
    }

    @Override
    public void startDocument(InputSource source) throws CSSException {
    }

    @Override
    public void endDocument(InputSource source) throws CSSException {
    }

    @Override
    public void comment(String text) throws CSSException {
    }

    @Override
    public void ignorableAtRule(String atRule) throws CSSException {
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    @Override
    public void importStyle(String uri, List<String> media, String defaultNamespaceURI) throws CSSException {
    }

    @Override
    public void startMedia(List<String> media) throws CSSException {
    }

    @Override
    public void endMedia(List<String> media) throws CSSException {
    }

    @Override
    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void startFontFace() throws CSSException {
    }

    @Override
    public void endFontFace() throws CSSException {
    }

    @Override
    public void startSelector(List<CSSSelector> selectors) throws CSSException {
    }

    @Override
    public void endSelector(List<CSSSelector> selectors) throws CSSException {
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (!ZINDEX_PROP.equals(name)) {
            this.styleSheet.append(name);
            this.styleSheet.append(':');
            while (value != null) {
                this.styleSheet.append(' ');
                if (this.lexicalValueToString(value).trim().length() == 0) {
                    if (value.getLexicalUnitType() == 0) {
                        this.styleSheet.append(',');
                    } else if (value.getLexicalUnitType() == 4) {
                        this.styleSheet.append('/');
                    }
                    value = value.getNextLexicalUnit();
                    continue;
                }
                this.styleSheet.append(this.lexicalValueToString(value));
                value = value.getNextLexicalUnit();
            }
            this.styleSheet.append(';');
        }
    }

    @Override
    public void filterSymbol(String filter) {
        this.styleSheet.append("filter: ").append(filter);
    }

    protected synchronized boolean registerLexicalUnitHandler(Short lexicalUnitNum, LexicalUnitHandler handler) {
        if (lexicalUnitNum == null) {
            return false;
        }
        this.lexicalUnitHandlerMap.put(lexicalUnitNum, handler);
        return true;
    }

    private String lexicalValueToString(LexicalUnit lu) {
        LexicalUnitHandler lexicalUnitHandler = this.lexicalUnitHandlerMap.get(lu.getLexicalUnitType());
        if (lexicalUnitHandler != null) {
            return lexicalUnitHandler.handle(lu);
        }
        switch (lu.getLexicalUnitType()) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                return lu.getFloatValue() + lu.getDimensionUnitText();
            }
            case 13: {
                return String.valueOf(lu.getIntegerValue());
            }
            case 14: {
                return String.valueOf(lu.getFloatValue());
            }
            case 35: 
            case 36: {
                String value = lu.getStringValue();
                if (forbiddenAttr.matcher(value).find()) {
                    value = "";
                }
                return value;
            }
            case 24: {
                return "";
            }
            case 10001: {
                return "";
            }
            case 27: {
                return "";
            }
            case 12: {
                return "inherit";
            }
        }
        return " ";
    }
}

