/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.css;

import com.alibaba.security.css.CSSParseException;
import com.alibaba.security.css.CSSReader;
import com.alibaba.security.css.CSSScannerUtilities;
import java.io.IOException;

public class CSSScanner {
    private CSSReader reader;
    private int current;
    private char[] buffer = new char[1024];
    private int position;
    private int type;
    private int start;
    private int end;
    private int blankCharacters;

    public CSSScanner(CSSReader reader) throws CSSParseException {
        try {
            this.reader = reader;
            this.current = this.nextChar();
        }
        catch (IOException e) {
            throw new CSSParseException(e);
        }
    }

    public int getLine() {
        return this.reader.getLine();
    }

    public int getColumn() {
        return this.reader.getColumn();
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void clearBuffer() {
        if (this.position <= 0) {
            this.position = 0;
        } else {
            this.buffer[0] = this.buffer[this.position - 1];
            this.position = 1;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getStringValue() {
        return new String(this.buffer, this.start, this.end - this.start);
    }

    public String getStringWithQuotation() {
        return new String(this.buffer, this.start - 1, this.end - this.start + 2);
    }

    public void scanAtRule() throws CSSParseException {
        try {
            block11: while (true) {
                switch (this.current) {
                    case 123: {
                        int brackets = 1;
                        block12: while (true) {
                            this.nextChar();
                            switch (this.current) {
                                case 125: {
                                    if (--brackets > 0) continue block12;
                                }
                                case -1: {
                                    break block11;
                                }
                                case 123: {
                                    ++brackets;
                                }
                            }
                        }
                    }
                    case -1: 
                    case 59: {
                        break block11;
                    }
                    default: {
                        this.nextChar();
                        continue block11;
                    }
                }
                break;
            }
            this.end = this.position;
        }
        catch (IOException e) {
            throw new CSSParseException(e);
        }
    }

    public int nextChar() throws IOException {
        this.current = this.reader.read();
        if (this.current == -1) {
            return this.current;
        }
        if (this.position == this.buffer.length) {
            char[] t = new char[1 + this.position + this.position / 2];
            System.arraycopy(this.buffer, 0, t, 0, this.position);
            this.buffer = t;
        }
        char c = (char)this.current;
        this.buffer[this.position++] = c;
        return c;
    }

    public void nextToken() throws CSSParseException {
        try {
            switch (this.current) {
                case -1: {
                    this.type = 0;
                    return;
                }
                case 123: {
                    this.nextChar();
                    this.type = 1;
                    return;
                }
                case 125: {
                    this.nextChar();
                    this.type = 2;
                    return;
                }
                case 61: {
                    this.nextChar();
                    this.type = 3;
                    return;
                }
                case 43: {
                    this.nextChar();
                    if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                        while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            this.nextChar();
                        }
                        if (this.current == 40) {
                            this.nextChar();
                            this.type = 52;
                            return;
                        }
                        this.type = 20;
                        return;
                    }
                    this.type = 4;
                    return;
                }
                case 44: {
                    this.nextChar();
                    this.type = 6;
                    return;
                }
                case 59: {
                    this.nextChar();
                    this.type = 8;
                    return;
                }
                case 62: {
                    this.nextChar();
                    this.type = 9;
                    return;
                }
                case 91: {
                    this.nextChar();
                    this.type = 11;
                    return;
                }
                case 93: {
                    this.nextChar();
                    this.type = 12;
                    return;
                }
                case 42: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 59;
                        return;
                    }
                    if (this.current != -1 && CSSScannerUtilities.isCSSIdentifierStartCharacter((char)this.current)) {
                        while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            this.nextChar();
                            while (this.current == 92) {
                                this.nextChar();
                                this.escape();
                            }
                        }
                        this.type = 20;
                        return;
                    }
                    this.type = 13;
                    return;
                }
                case 40: {
                    this.nextChar();
                    this.type = 14;
                    return;
                }
                case 41: {
                    this.nextChar();
                    this.type = 15;
                    return;
                }
                case 58: {
                    this.nextChar();
                    this.type = 16;
                    return;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    do {
                        this.nextChar();
                    } while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current));
                    this.type = 17;
                    return;
                }
                case 47: {
                    this.nextChar();
                    if (this.current != 42) {
                        this.type = 10;
                        return;
                    }
                    this.nextChar();
                    this.start = this.position - 1;
                    while (true) {
                        if (this.current != -1 && this.current != 42) {
                            this.nextChar();
                            continue;
                        }
                        do {
                            this.nextChar();
                        } while (this.current != -1 && this.current == 42);
                        if (this.current == -1 || this.current == 47) break;
                    }
                    if (this.current == -1) {
                        throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                    }
                    this.nextChar();
                    this.type = 18;
                    return;
                }
                case 39: {
                    this.type = this.string1();
                    return;
                }
                case 34: {
                    this.type = this.string2();
                    return;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 33) {
                        throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                    }
                    this.nextChar();
                    if (this.current == 45) {
                        this.nextChar();
                        if (this.current == 45) {
                            this.nextChar();
                            this.type = 21;
                            return;
                        }
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                case 45: {
                    this.nextChar();
                    int off = this.position;
                    int len = 0;
                    boolean sign = false;
                    if (this.current == 45) {
                        this.nextChar();
                        if (this.current == 62) {
                            this.nextChar();
                            this.type = 22;
                            return;
                        }
                        throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                    }
                    if (this.current == 109 || this.current == 77) {
                        this.nextChar();
                        ++len;
                        if (this.current == 115 || this.current == 83) {
                            this.nextChar();
                            ++len;
                            if (this.current == 45) {
                                sign = true;
                            } else if (this.current == 111 || this.current == 79) {
                                this.nextChar();
                                ++len;
                                if (this.current == 45) {
                                    sign = true;
                                }
                            }
                        } else if (this.current == 111 || this.current == 79) {
                            this.nextChar();
                            ++len;
                            if (this.current == 122 || this.current == 90) {
                                this.nextChar();
                                ++len;
                                if (this.current == 45) {
                                    sign = true;
                                }
                            }
                        }
                    } else if (this.current == 111 || this.current == 79) {
                        this.nextChar();
                        ++len;
                        if (this.current == 45) {
                            sign = true;
                        }
                    } else if (this.current == 97 || this.current == 65) {
                        this.nextChar();
                        ++len;
                        if (this.current == 116 || this.current == 84) {
                            this.nextChar();
                            ++len;
                            if (this.current == 115 || this.current == 83) {
                                this.nextChar();
                                ++len;
                                if (this.current == 99 || this.current == 67) {
                                    this.nextChar();
                                    ++len;
                                    if (this.current == 45) {
                                        sign = true;
                                    }
                                }
                            }
                        }
                    } else if (this.current == 119 || this.current == 87) {
                        this.nextChar();
                        ++len;
                        if (this.current == 97 || this.current == 65) {
                            this.nextChar();
                            ++len;
                            if (this.current == 112 || this.current == 80) {
                                this.nextChar();
                                ++len;
                                if (this.current == 45) {
                                    sign = true;
                                }
                            }
                        } else if (this.current == 101 || this.current == 69) {
                            this.nextChar();
                            ++len;
                            if (this.current == 98 || this.current == 66) {
                                this.nextChar();
                                ++len;
                                if (this.current == 107 || this.current == 75) {
                                    this.nextChar();
                                    ++len;
                                    if (this.current == 105 || this.current == 73) {
                                        this.nextChar();
                                        ++len;
                                        if (this.current == 116 || this.current == 84) {
                                            this.nextChar();
                                            ++len;
                                            if (this.current == 45) {
                                                sign = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else if (this.current == 107 || this.current == 75) {
                        this.nextChar();
                        ++len;
                        if (this.current == 104 || this.current == 72) {
                            this.nextChar();
                            ++len;
                            if (this.current == 116 || this.current == 84) {
                                this.nextChar();
                                ++len;
                                if (this.current == 109 || this.current == 77) {
                                    this.nextChar();
                                    ++len;
                                    if (this.current == 108 || this.current == 76) {
                                        this.nextChar();
                                        ++len;
                                        if (this.current == 45) {
                                            sign = true;
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        this.type = 5;
                        return;
                    }
                    if (sign) {
                        do {
                            this.nextChar();
                            while (this.current == 92) {
                                this.nextChar();
                                this.escape();
                            }
                        } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                        this.type = 20;
                        return;
                    }
                    this.reader.pushBack(this.buffer, off, len);
                    this.type = 5;
                    return;
                }
                case 124: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 25;
                        return;
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                case 126: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 26;
                        return;
                    }
                    this.type = 60;
                    return;
                }
                case 36: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 58;
                        return;
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                case 94: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 57;
                        return;
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                case 35: {
                    this.nextChar();
                    if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                        this.start = this.position - 1;
                        do {
                            this.nextChar();
                            while (this.current == 92) {
                                this.nextChar();
                                this.escape();
                            }
                        } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                        this.type = 27;
                        return;
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                case 64: {
                    this.nextChar();
                    switch (this.current) {
                        case 67: 
                        case 99: {
                            this.start = this.position - 1;
                            if (!CSSScanner.isEqualIgnoreCase(this.nextChar(), 'h') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'r') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 's') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 't')) break;
                            this.nextChar();
                            this.type = 30;
                            return;
                        }
                        case 70: 
                        case 102: {
                            this.start = this.position - 1;
                            if (!CSSScanner.isEqualIgnoreCase(this.nextChar(), 'o') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'n') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 't') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), '-') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'f') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'c') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 31;
                            return;
                        }
                        case 73: 
                        case 105: {
                            this.start = this.position - 1;
                            if (!CSSScanner.isEqualIgnoreCase(this.nextChar(), 'm') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'p') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'o') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'r') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 't')) break;
                            this.nextChar();
                            this.type = 28;
                            return;
                        }
                        case 77: 
                        case 109: {
                            this.start = this.position - 1;
                            if (!CSSScanner.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'd') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'i') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'a')) break;
                            this.nextChar();
                            this.type = 32;
                            return;
                        }
                        case 80: 
                        case 112: {
                            this.start = this.position - 1;
                            if (!CSSScanner.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'g') || !CSSScanner.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 33;
                            return;
                        }
                        default: {
                            if (this.current == -1 || !CSSScannerUtilities.isCSSIdentifierStartCharacter((char)this.current)) {
                                throw new CSSParseException("identifier.character", this.reader.getLine(), this.reader.getColumn());
                            }
                            this.start = this.position - 1;
                        }
                    }
                    do {
                        this.nextChar();
                        while (this.current == 92) {
                            this.nextChar();
                            this.escape();
                        }
                    } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                    this.type = 29;
                    return;
                }
                case 33: {
                    do {
                        this.nextChar();
                    } while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current));
                    if (CSSScanner.isEqualIgnoreCase(this.current, 'i') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 'm') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 'p') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 'o') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 'r') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 't') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 'a') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 'n') && CSSScanner.isEqualIgnoreCase(this.nextChar(), 't')) {
                        this.nextChar();
                        this.type = 23;
                        return;
                    }
                    if (this.current == -1) {
                        throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.type = this.number();
                    return;
                }
                case 46: {
                    switch (this.nextChar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.type = this.dotNumber();
                            return;
                        }
                    }
                    this.type = 7;
                    return;
                }
                case 85: 
                case 117: {
                    this.nextChar();
                    switch (this.current) {
                        case 43: {
                            boolean hasQue = false;
                            boolean hasHex = false;
                            this.nextChar();
                            for (int i = 0; i < 6; ++i) {
                                if ((char)this.current == '?') {
                                    hasQue = true;
                                } else {
                                    if (this.current == -1 || !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current) || hasQue) break;
                                    hasHex = true;
                                }
                                this.nextChar();
                            }
                            if (!hasQue && !hasHex) {
                                throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                            }
                            if (hasHex && !hasQue && this.current == 45) {
                                this.nextChar();
                                if (this.current == -1 || !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                                }
                                this.nextChar();
                                if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                this.type = 53;
                                return;
                            }
                            if (this.current == -1) {
                                this.type = 0;
                            }
                            this.type = 53;
                            return;
                        }
                        case 82: 
                        case 114: {
                            this.nextChar();
                            switch (this.current) {
                                case 76: 
                                case 108: {
                                    this.nextChar();
                                    switch (this.current) {
                                        case 40: {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current));
                                            switch (this.current) {
                                                case 39: {
                                                    this.string1();
                                                    this.blankCharacters += 2;
                                                    while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current)) {
                                                        ++this.blankCharacters;
                                                        this.nextChar();
                                                    }
                                                    if (this.current == -1) {
                                                        throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                                                    }
                                                    if (this.current != 41) {
                                                        throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                                                    }
                                                    this.nextChar();
                                                    this.type = 51;
                                                    return;
                                                }
                                                case 34: {
                                                    this.string2();
                                                    this.blankCharacters += 2;
                                                    while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current)) {
                                                        ++this.blankCharacters;
                                                        this.nextChar();
                                                    }
                                                    if (this.current == -1) {
                                                        throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                                                    }
                                                    if (this.current != 41) {
                                                        throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                                                    }
                                                    this.nextChar();
                                                    this.type = 51;
                                                    return;
                                                }
                                                case 41: {
                                                    this.nextChar();
                                                    this.type = 51;
                                                    this.start = this.position - 1;
                                                    return;
                                                }
                                            }
                                            if (this.current != -1 && !CSSScannerUtilities.isCSSURICharacter((char)this.current)) {
                                                throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                                            }
                                            this.start = this.position - 1;
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && this.current != 41);
                                            ++this.blankCharacters;
                                            while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current)) {
                                                ++this.blankCharacters;
                                                this.nextChar();
                                            }
                                            if (this.current == -1) {
                                                throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                                            }
                                            if (this.current != 41) {
                                                throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                                            }
                                            this.nextChar();
                                            this.type = 51;
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                        this.nextChar();
                    }
                    if (this.current == 40) {
                        this.nextChar();
                        this.type = 52;
                        return;
                    }
                    this.type = 20;
                    return;
                }
                case 70: 
                case 102: {
                    this.nextChar();
                    block60 : switch (this.current) {
                        case 73: 
                        case 105: {
                            this.nextChar();
                            switch (this.current) {
                                case 76: 
                                case 108: {
                                    this.nextChar();
                                    switch (this.current) {
                                        case 84: 
                                        case 116: {
                                            this.nextChar();
                                            switch (this.current) {
                                                case 69: 
                                                case 101: {
                                                    this.nextChar();
                                                    switch (this.current) {
                                                        case 82: 
                                                        case 114: {
                                                            do {
                                                                this.nextChar();
                                                            } while (this.current != -1 && CSSScannerUtilities.isCSSSpace((char)this.current));
                                                            if (this.current != 58) break block60;
                                                            this.type = 55;
                                                            return;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                        this.nextChar();
                    }
                    if (this.current == 40) {
                        this.nextChar();
                        this.type = 52;
                        return;
                    }
                    this.type = 20;
                    return;
                }
                case 69: 
                case 101: {
                    this.nextChar();
                    block75 : switch (this.current) {
                        case 88: 
                        case 120: {
                            this.nextChar();
                            switch (this.current) {
                                case 80: 
                                case 112: {
                                    this.nextChar();
                                    switch (this.current) {
                                        case 82: 
                                        case 114: {
                                            this.nextChar();
                                            switch (this.current) {
                                                case 69: 
                                                case 101: {
                                                    this.nextChar();
                                                    switch (this.current) {
                                                        case 83: 
                                                        case 115: {
                                                            this.nextChar();
                                                            switch (this.current) {
                                                                case 83: 
                                                                case 115: {
                                                                    this.nextChar();
                                                                    switch (this.current) {
                                                                        case 73: 
                                                                        case 105: {
                                                                            this.nextChar();
                                                                            switch (this.current) {
                                                                                case 79: 
                                                                                case 111: {
                                                                                    this.nextChar();
                                                                                    switch (this.current) {
                                                                                        case 78: 
                                                                                        case 110: {
                                                                                            this.nextChar();
                                                                                            if (this.current != 40) break block75;
                                                                                            int brackNum = 1;
                                                                                            while (this.current != -1 && brackNum != 0) {
                                                                                                this.nextChar();
                                                                                                if (this.current == 40) {
                                                                                                    ++brackNum;
                                                                                                    continue;
                                                                                                }
                                                                                                if (this.current != 41) continue;
                                                                                                --brackNum;
                                                                                            }
                                                                                            if (this.current == -1) {
                                                                                                throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                                                                                            }
                                                                                            if (brackNum != 0) break block75;
                                                                                            this.nextChar();
                                                                                            this.type = 56;
                                                                                            return;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                        this.nextChar();
                    }
                    if (this.current == 40) {
                        this.nextChar();
                        this.type = 52;
                        return;
                    }
                    this.type = 20;
                    return;
                }
            }
            if (this.current == 92) {
                do {
                    this.nextChar();
                    this.escape();
                } while (this.current == 92);
            } else if (this.current != -1 && !CSSScannerUtilities.isCSSIdentifierStartCharacter((char)this.current)) {
                this.nextChar();
                throw new CSSParseException("identifier.character", this.reader.getLine(), this.reader.getColumn());
            }
            while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                this.nextChar();
                while (this.current == 92) {
                    this.nextChar();
                    this.escape();
                }
            }
            if (this.current == 40) {
                this.nextChar();
                this.type = 52;
                return;
            }
            this.type = 20;
            return;
        }
        catch (IOException e) {
            throw new CSSParseException(e);
        }
    }

    public int next() {
        this.blankCharacters = 0;
        this.start = this.position - 1;
        this.nextToken();
        this.end = this.position - this.endGap();
        return this.type;
    }

    public int nextRightCurlyBrace() throws IOException {
        int ch;
        while ((ch = this.nextChar()) != -1) {
            if (ch != 125) continue;
            return ch;
        }
        return -1;
    }

    private int endGap() {
        int result = this.current == -1 ? 0 : 1;
        switch (this.type) {
            case 19: 
            case 42: 
            case 43: 
            case 52: {
                ++result;
                break;
            }
            case 18: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: {
                result += 2;
                break;
            }
            case 47: 
            case 48: 
            case 50: {
                result += 3;
                break;
            }
            case 49: {
                result += 4;
            }
        }
        return result + this.blankCharacters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int string1() throws IOException {
        this.start = this.position;
        boolean needNextChar = true;
        block9: while (true) {
            if (needNextChar) {
                this.nextChar();
            }
            needNextChar = true;
            switch (this.current) {
                case -1: {
                    throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                }
                case 39: {
                    break block9;
                }
                case 34: {
                    continue block9;
                }
                case 92: {
                    switch (this.nextChar()) {
                        case 10: 
                        case 12: {
                            continue block9;
                        }
                    }
                    this.escape();
                    needNextChar = false;
                    continue block9;
                }
                default: {
                    if (this.current != -1 && !CSSScannerUtilities.isCSSStringCharacter((char)this.current)) throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                    continue block9;
                }
            }
            break;
        }
        this.nextChar();
        return 19;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int string2() throws IOException {
        this.start = this.position;
        boolean needNextChar = true;
        block9: while (true) {
            if (needNextChar) {
                this.nextChar();
            }
            needNextChar = true;
            switch (this.current) {
                case -1: {
                    throw new CSSParseException("eof", this.reader.getLine(), this.reader.getColumn());
                }
                case 39: {
                    continue block9;
                }
                case 34: {
                    break block9;
                }
                case 92: {
                    switch (this.nextChar()) {
                        case 10: 
                        case 12: {
                            continue block9;
                        }
                    }
                    this.escape();
                    needNextChar = false;
                    continue block9;
                }
                default: {
                    if (this.current != -1 && !CSSScannerUtilities.isCSSStringCharacter((char)this.current)) throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                    continue block9;
                }
            }
            break;
        }
        this.nextChar();
        return 19;
    }

    private int number() throws IOException {
        block7: while (true) {
            switch (this.nextChar()) {
                case 46: {
                    switch (this.nextChar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.dotNumber();
                        }
                    }
                    throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
                }
                default: {
                    break block7;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block7;
                }
            }
            break;
        }
        return this.numberUnit(true);
    }

    private int dotNumber() throws IOException {
        block3: while (true) {
            switch (this.nextChar()) {
                default: {
                    break block3;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
            }
            break;
        }
        return this.numberUnit(false);
    }

    private int numberUnit(boolean integer) throws IOException {
        switch (this.current) {
            case 37: {
                this.nextChar();
                return 42;
            }
            case 67: 
            case 99: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 37;
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 68: 
            case 100: {
                switch (this.nextChar()) {
                    case 69: 
                    case 101: {
                        switch (this.nextChar()) {
                            case 71: 
                            case 103: {
                                this.nextChar();
                                if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 47;
                            }
                        }
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 69: 
            case 101: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 36;
                    }
                    case 88: 
                    case 120: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 35;
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 71: 
            case 103: {
                switch (this.nextChar()) {
                    case 82: 
                    case 114: {
                        switch (this.nextChar()) {
                            case 65: 
                            case 97: {
                                switch (this.nextChar()) {
                                    case 68: 
                                    case 100: {
                                        this.nextChar();
                                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 49;
                                    }
                                }
                            }
                        }
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 72: 
            case 104: {
                this.nextChar();
                switch (this.current) {
                    case 90: 
                    case 122: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 41;
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 73: 
            case 105: {
                switch (this.nextChar()) {
                    case 78: 
                    case 110: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 39;
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 75: 
            case 107: {
                switch (this.nextChar()) {
                    case 72: 
                    case 104: {
                        switch (this.nextChar()) {
                            case 90: 
                            case 122: {
                                this.nextChar();
                                if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 50;
                            }
                        }
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 77: 
            case 109: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 38;
                    }
                    case 83: 
                    case 115: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 40;
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 80: 
            case 112: {
                switch (this.nextChar()) {
                    case 67: 
                    case 99: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 44;
                    }
                    case 84: 
                    case 116: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 45;
                    }
                    case 88: 
                    case 120: {
                        this.nextChar();
                        if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 46;
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 82: 
            case 114: {
                switch (this.nextChar()) {
                    case 65: 
                    case 97: {
                        switch (this.nextChar()) {
                            case 68: 
                            case 100: {
                                this.nextChar();
                                if (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 48;
                            }
                        }
                    }
                }
                while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 83: 
            case 115: {
                this.nextChar();
                return 43;
            }
        }
        if (this.current != -1 && CSSScannerUtilities.isCSSIdentifierStartCharacter((char)this.current)) {
            do {
                this.nextChar();
            } while (this.current != -1 && CSSScannerUtilities.isCSSNameCharacter((char)this.current));
            return 34;
        }
        return integer ? 24 : 54;
    }

    private void escape() throws IOException {
        if (this.current != -1 && CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
            this.nextChar();
            if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                if (CSSScannerUtilities.isCSSSpace((char)this.current)) {
                    this.nextChar();
                }
                return;
            }
            this.nextChar();
            if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                if (CSSScannerUtilities.isCSSSpace((char)this.current)) {
                    this.nextChar();
                }
                return;
            }
            this.nextChar();
            if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                if (CSSScannerUtilities.isCSSSpace((char)this.current)) {
                    this.nextChar();
                }
                return;
            }
            this.nextChar();
            if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                if (CSSScannerUtilities.isCSSSpace((char)this.current)) {
                    this.nextChar();
                }
                return;
            }
            this.nextChar();
            if (this.current != -1 && !CSSScannerUtilities.isCSSHexadecimalCharacter((char)this.current)) {
                if (CSSScannerUtilities.isCSSSpace((char)this.current)) {
                    this.nextChar();
                }
                return;
            }
        }
        if (this.current >= 32 && this.current <= 126 || this.current >= 128) {
            this.nextChar();
            return;
        }
        throw new CSSParseException("character", this.reader.getLine(), this.reader.getColumn());
    }

    private static boolean isEqualIgnoreCase(int i, char c) {
        return i == -1 ? false : Character.toLowerCase((char)i) == c;
    }
}

