/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.css;

public class CSSParseException
extends RuntimeException {
    private static final long serialVersionUID = -8998837008549413871L;
    protected Exception exception;
    protected int lineNumber;
    protected int columnNumber;
    protected String uri;

    public CSSParseException(String message, int line, int column) {
        super(message + ",line:" + line + ",column" + column);
        this.exception = null;
        this.lineNumber = line;
        this.columnNumber = column;
    }

    public CSSParseException(String message, String uri, int line, int column) {
        super(message);
        this.exception = null;
        this.lineNumber = line;
        this.columnNumber = column;
    }

    public CSSParseException(Exception e) {
        this.exception = e;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public CSSParseException(String message, Exception e) {
        super(message);
        this.exception = e;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null && this.exception != null) {
            return this.exception.getMessage();
        }
        return message;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getUri() {
        return this.uri;
    }
}

