/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.ResourceType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.Property;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.AbstractParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.parameters.resource.ResourceParametersHelper;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.SqoopJobType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.sources.SourceMysqlParameter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sqoop.targets.TargetMysqlParameter;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SqoopParameters
extends AbstractParameters {
    private String jobType;
    private String customShell;
    private String jobName;
    private String modelType;
    private int concurrency;
    private String splitBy;
    private String sourceType;
    private String targetType;
    private String sourceParams;
    private String targetParams;
    private List<Property> hadoopCustomParams;
    private List<Property> sqoopAdvancedParams;

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public String getSplitBy() {
        return this.splitBy;
    }

    public void setSplitBy(String splitBy) {
        this.splitBy = splitBy;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getSourceParams() {
        return this.sourceParams;
    }

    public void setSourceParams(String sourceParams) {
        this.sourceParams = sourceParams;
    }

    public String getTargetParams() {
        return this.targetParams;
    }

    public void setTargetParams(String targetParams) {
        this.targetParams = targetParams;
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getCustomShell() {
        return this.customShell;
    }

    public void setCustomShell(String customShell) {
        this.customShell = customShell;
    }

    public List<Property> getHadoopCustomParams() {
        return this.hadoopCustomParams;
    }

    public void setHadoopCustomParams(List<Property> hadoopCustomParams) {
        this.hadoopCustomParams = hadoopCustomParams;
    }

    public List<Property> getSqoopAdvancedParams() {
        return this.sqoopAdvancedParams;
    }

    public void setSqoopAdvancedParams(List<Property> sqoopAdvancedParams) {
        this.sqoopAdvancedParams = sqoopAdvancedParams;
    }

    @Override
    public boolean checkParameters() {
        boolean sqoopParamsCheck = false;
        if (StringUtils.isEmpty((CharSequence)this.jobType)) {
            return sqoopParamsCheck;
        }
        if (SqoopJobType.TEMPLATE.getDescp().equals(this.jobType)) {
            sqoopParamsCheck = StringUtils.isEmpty((CharSequence)this.customShell) && StringUtils.isNotEmpty((CharSequence)this.modelType) && StringUtils.isNotEmpty((CharSequence)this.jobName) && this.concurrency != 0 && StringUtils.isNotEmpty((CharSequence)this.sourceType) && StringUtils.isNotEmpty((CharSequence)this.targetType) && StringUtils.isNotEmpty((CharSequence)this.sourceParams) && StringUtils.isNotEmpty((CharSequence)this.targetParams);
        } else if (SqoopJobType.CUSTOM.getDescp().equals(this.jobType)) {
            sqoopParamsCheck = StringUtils.isNotEmpty((CharSequence)this.customShell) && StringUtils.isEmpty((CharSequence)this.jobName);
        }
        return sqoopParamsCheck;
    }

    @Override
    public ResourceParametersHelper getResources() {
        TargetMysqlParameter targetMysqlParameter;
        ResourceParametersHelper resources = super.getResources();
        if (!SqoopJobType.TEMPLATE.getDescp().equals(this.getJobType())) {
            return resources;
        }
        SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)this.getSourceParams(), SourceMysqlParameter.class);
        if (sourceMysqlParameter.getSrcDatasource() != 0) {
            resources.put(ResourceType.DATASOURCE, sourceMysqlParameter.getSrcDatasource());
        }
        if ((targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)this.getTargetParams(), TargetMysqlParameter.class)).getTargetDatasource() != 0) {
            resources.put(ResourceType.DATASOURCE, targetMysqlParameter.getTargetDatasource());
        }
        return resources;
    }
}

