/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DolphinSchedulerV1Context {
    private static DolphinSchedulerV1Context context;
    private List<Project> projects;
    private List<DataSource> dataSources;
    private List<ResourceInfo> resources;
    private List<UdfFunc> udfFuncs;
    private List<ProcessMeta> dagDatas;
    private Map<Long, Project> projectCodeMap = new HashMap<Long, Project>();
    private Map<Integer, List<String>> subProcessCodeOutMap = new HashMap<Integer, List<String>>();
    private Map<Integer, List<Object>> processCodeTaskRelationMap = new HashMap<Integer, List<Object>>();
    private Map<Integer, Object> subProcessCodeNodeMap = new HashMap<Integer, Object>();
    private Map<Integer, Object> subProcessCodeWorkflowMap = new HashMap<Integer, Object>();
    private Map<String, String> taskCodeNodeDataMap = new HashMap<String, String>();
    private Map<String, String> taskCodeNodeIdMap = new HashMap<String, String>();
    private Map<String, Object> taskCodeSpecNodeMap = new HashMap<String, Object>();
    private Map<Object, List<String>> specNodeProcessCodeMap = new HashMap<Object, List<String>>();

    public Map<Integer, List<Object>> getProcessCodeTaskRelationMap() {
        return this.processCodeTaskRelationMap;
    }

    public Map<String, Object> getTaskCodeSpecNodeMap() {
        return this.taskCodeSpecNodeMap;
    }

    private DolphinSchedulerV1Context() {
    }

    public static void initContext(List<Project> projects, List<ProcessMeta> dagDatas, List<DataSource> dataSources, List<ResourceInfo> resources, List<UdfFunc> udfFuncs) {
        DolphinSchedulerV1Context context = new DolphinSchedulerV1Context();
        context.projects = projects;
        context.dagDatas = dagDatas;
        context.dataSources = dataSources;
        context.resources = resources;
        context.udfFuncs = udfFuncs;
        for (Project project : ListUtils.emptyIfNull(projects)) {
            if (!NumberUtils.isDigits((String)project.getCode())) continue;
            context.projectCodeMap.put(Long.parseLong(project.getCode()), project);
        }
        for (ProcessMeta processMeta : dagDatas) {
            List<TaskNode> taskNodes = processMeta.getProcessDefinitionJson().getTasks();
            List<Object> taskDefinitionList = context.processCodeTaskRelationMap.get(processMeta.getProcessDefinitionId());
            if (taskDefinitionList == null) {
                taskDefinitionList = new ArrayList<Object>();
                context.processCodeTaskRelationMap.put(processMeta.getProcessDefinitionId(), taskDefinitionList);
            }
            taskDefinitionList.addAll(taskNodes);
        }
        DolphinSchedulerV1Context.context = context;
    }

    public static DolphinSchedulerV1Context getContext() {
        return context;
    }

    public Map<Long, Project> getProjectCodeMap() {
        return this.projectCodeMap;
    }

    public void setProjectCodeMap(Map<Long, Project> projectCodeMap) {
        this.projectCodeMap = projectCodeMap;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public List<ResourceInfo> getResources() {
        return this.resources;
    }

    public void setResources(List<ResourceInfo> resources) {
        this.resources = resources;
    }

    public List<UdfFunc> getUdfFuncs() {
        return this.udfFuncs;
    }

    public void setUdfFuncs(List<UdfFunc> udfFuncs) {
        this.udfFuncs = udfFuncs;
    }

    public void putSubProcessCodeOutMap(Integer code, String out) {
        List<String> outs = this.subProcessCodeOutMap.get(code);
        if (outs == null) {
            outs = new ArrayList<String>();
            this.subProcessCodeOutMap.put(code, outs);
        }
        outs.add(out);
    }

    public List<String> getSubProcessCodeMap(Long code) {
        return this.subProcessCodeOutMap.get(code);
    }

    public Map<String, String> getTaskCodeNodeDataMap() {
        return this.taskCodeNodeDataMap;
    }

    public Map<String, String> getTaskCodeNodeIdMap() {
        return this.taskCodeNodeIdMap;
    }

    public Map<Integer, Object> getSubProcessCodeNodeMap() {
        return this.subProcessCodeNodeMap;
    }

    public Map<Integer, Object> getSubProcessCodeWorkflowMap() {
        return this.subProcessCodeWorkflowMap;
    }

    public Map<Object, List<String>> getSpecNodeProcessCodeMap() {
        return this.specNodeProcessCodeMap;
    }
}

