/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.PackageInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerV1PackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerV2PackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerV3PackageLoader;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DolphinSchedulerPackageLoader<Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerPackageLoader.class);
    protected static final String PACKAGE_INFO_JSON = "package_info.json";
    protected static final String PROJECTS = "projects";
    protected static final String PROCESS_DEFINITION = "processDefinition";
    protected static final String DATASOURCE = "datasource";
    protected static final String RESOURCE = "resource";
    protected static final String UDF_FUNCTION = "udfFunction";
    private static final String PROJECTS_JSON = "projects.json";
    protected final File packageRoot;

    protected DolphinSchedulerPackageLoader(File packageRoot) {
        this.packageRoot = packageRoot;
    }

    public abstract DolphinSchedulerPackage<Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> getDolphinSchedulerPackage();

    public abstract boolean support(DolphinSchedulerVersion var1);

    public abstract void loadPackage() throws IOException;

    protected List<Project> readProjects(File packageRoot) throws IOException {
        File projectsJson = new File(packageRoot, PROJECTS_JSON);
        String projects = FileUtils.readFileToString((File)projectsJson, (Charset)StandardCharsets.UTF_8);
        List projectList = (List)GsonUtils.fromJsonString((String)projects, (Type)new TypeToken<List<Project>>(){}.getType());
        return Optional.ofNullable(projectList).orElse(ListUtils.emptyIfNull(null));
    }

    protected List<Project> readProjects(File packageRoot, Type type) throws IOException {
        File projectsJson = new File(packageRoot, PROJECTS_JSON);
        String projects = FileUtils.readFileToString((File)projectsJson, (Charset)StandardCharsets.UTF_8);
        List projectList = (List)GsonUtils.fromJsonString((String)projects, (Type)type);
        return Optional.ofNullable(projectList).orElse(ListUtils.emptyIfNull(null));
    }

    protected static PackageInfo readPackageInfo(File rootDir) throws IOException {
        File packageInfoJson = new File(rootDir, PACKAGE_INFO_JSON);
        String jsonContent = FileUtils.readFileToString((File)packageInfoJson, (Charset)StandardCharsets.UTF_8);
        PackageInfo info = (PackageInfo)GsonUtils.fromJsonString((String)jsonContent, (Type)new TypeToken<PackageInfo>(){}.getType());
        if (info == null) {
            throw new RuntimeException("error read pacakge_info.json file");
        }
        return info;
    }

    protected <T> List<T> readJsonFiles(File dir, TypeToken<List<T>> typeToken) {
        if (!dir.exists()) {
            return ListUtils.emptyIfNull(null);
        }
        File[] subJsons = Optional.ofNullable(dir.listFiles(f -> StringUtils.endsWithIgnoreCase((CharSequence)f.getName(), (CharSequence)".json"))).orElse(new File[0]);
        return Arrays.stream(subJsons).map(jsonFile -> {
            try {
                return FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(json -> (List)GsonUtils.fromJsonString((String)json, (Type)typeToken.getType())).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> DolphinSchedulerPackageLoader<Project, ProcessDefinitionType, DataSource, ResourceInfo, UdfFunction> create(File packageDir) throws IOException {
        PackageInfo pacakgeInfo = DolphinSchedulerPackageLoader.readPackageInfo(packageDir);
        DolphinSchedulerVersion version = pacakgeInfo.getDolphinSchedulerVersion();
        switch (version) {
            case V1: {
                return new DolphinSchedulerV1PackageLoader(packageDir);
            }
            case V2: {
                return new DolphinSchedulerV2PackageLoader(packageDir);
            }
            case V3: {
                return new DolphinSchedulerV3PackageLoader(packageDir);
            }
        }
        throw new RuntimeException("unsupported dolphinscheduler version: " + (Object)((Object)version));
    }
}

