/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PackageInfo {
    private String version;

    public DolphinSchedulerVersion getDolphinSchedulerVersion() {
        if (StringUtils.isBlank((CharSequence)this.getVersion())) {
            throw new RuntimeException("pacakge info version is blank");
        }
        String[] versionNumbers = StringUtils.split((String)this.getVersion(), (String)".");
        if (versionNumbers == null || versionNumbers.length == 0 || Arrays.stream(versionNumbers).anyMatch(num -> !StringUtils.isNumeric((CharSequence)num))) {
            throw new RuntimeException("package info version invalid: " + this.getVersion());
        }
        List numbers = Arrays.stream(versionNumbers).map(Integer::valueOf).collect(Collectors.toList());
        if ((Integer)numbers.get(0) < 2) {
            return DolphinSchedulerVersion.V1;
        }
        if ((Integer)numbers.get(0) < 3) {
            return DolphinSchedulerVersion.V2;
        }
        return DolphinSchedulerVersion.V3;
    }

    public String toString() {
        return "PackageInfo(version=" + this.getVersion() + ")";
    }

    public String getVersion() {
        return this.version;
    }

    public PackageInfo setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageInfo)) {
            return false;
        }
        PackageInfo other = (PackageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PackageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

