/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CacheRetrieveFieldManager;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.util.NucleusLogger;

public class L2CachePopulateFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;

    public L2CachePopulateFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Character.valueOf(value));
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Float.valueOf(value));
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        if (value == null) {
            this.cachedPC.setFieldValue(fieldNumber, null);
            return;
        }
        if (mmd.hasContainer()) {
            this.processContainer(fieldNumber, mmd, value);
            return;
        }
        this.processField(fieldNumber, mmd, value);
    }

    protected void processContainer(int fieldNumber, AbstractMemberMetaData mmd, Object inputValue) {
        Object value = inputValue;
        if (inputValue instanceof SCOContainer) {
            if (!((SCOContainer)inputValue).isLoaded()) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            value = ((SCO)inputValue).getValue();
        }
        ApiAdapter api = this.ec.getApiAdapter();
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (mmd.hasMap()) {
            if (RelationType.isRelationMultiValued(relType)) {
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue() || mmd.getMap().keyIsPersistent() && mmd.getMap().isEmbeddedKey() || mmd.getMap().valueIsPersistent() && mmd.getMap().isEmbeddedValue()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                try {
                    Map returnMap = null;
                    returnMap = value.getClass().isInterface() ? new HashMap() : (value instanceof SCO ? (Map)((SCO)value).getValue().getClass().newInstance() : (Map)value.getClass().newInstance());
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        Object mapKey = null;
                        Object mapValue = null;
                        mapKey = mmd.getMap().keyIsPersistent() ? this.getCacheableIdForId(api, entry.getKey()) : (Object)entry.getKey();
                        mapValue = mmd.getMap().valueIsPersistent() ? this.getCacheableIdForId(api, entry.getValue()) : (Object)entry.getValue();
                        returnMap.put(mapKey, mapValue);
                    }
                    this.cachedPC.setFieldValue(fieldNumber, returnMap);
                    return;
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + e.getMessage());
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
            }
            this.cachedPC.setFieldValue(fieldNumber, value);
            return;
        }
        if (mmd.hasCollection()) {
            if (RelationType.isRelationMultiValued(relType)) {
                if (value instanceof List && mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getCollection().isSerializedElement() || mmd.getCollection().isEmbeddedElement()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                Collection collValue = (Collection)value;
                Iterator collIter = collValue.iterator();
                Collection returnColl = null;
                try {
                    returnColl = value.getClass().isInterface() ? (List.class.isAssignableFrom(value.getClass()) || mmd.getOrderMetaData() != null ? new ArrayList() : new HashSet()) : (value instanceof SCO ? (Collection)((SCO)value).getValue().getClass().newInstance() : (ArrayList)value.getClass().newInstance());
                    while (collIter.hasNext()) {
                        Object elem = collIter.next();
                        if (elem == null) {
                            returnColl.add(null);
                            continue;
                        }
                        returnColl.add(this.getCacheableIdForId(api, elem));
                    }
                    this.cachedPC.setFieldValue(fieldNumber, returnColl);
                    return;
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + e.getMessage());
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
            }
            this.cachedPC.setFieldValue(fieldNumber, value);
            return;
        }
        if (mmd.hasArray()) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getArray().isSerializedElement() || mmd.getArray().isEmbeddedElement()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                Object[] returnArr = new Object[Array.getLength(value)];
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    returnArr[i] = element != null ? this.getCacheableIdForId(api, element) : null;
                }
                this.cachedPC.setFieldValue(fieldNumber, returnArr);
                return;
            }
            this.cachedPC.setFieldValue(fieldNumber, value);
            return;
        }
    }

    protected void processField(int fieldNumber, AbstractMemberMetaData mmd, Object value) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            Object unwrappedValue = value instanceof SCO ? ((SCO)value).getValue() : value;
            this.cachedPC.setFieldValue(fieldNumber, L2CacheRetrieveFieldManager.copyValue(unwrappedValue));
            return;
        }
        if (mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, relType, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) {
            if (this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheEmbedded")) {
                ObjectProvider valueOP = this.ec.findObjectProvider(value);
                int[] loadedFields = valueOP.getLoadedFieldNumbers();
                CachedPC valueCachedPC = new CachedPC(value.getClass(), valueOP.getLoadedFields(), null);
                valueOP.provideFields(loadedFields, new L2CachePopulateFieldManager(valueOP, valueCachedPC));
                this.cachedPC.setFieldValue(fieldNumber, valueCachedPC);
            } else {
                this.cachedPC.setLoadedField(fieldNumber, false);
            }
            return;
        }
        this.cachedPC.setFieldValue(fieldNumber, this.getCacheableIdForId(this.ec.getApiAdapter(), value));
    }

    private Object getCacheableIdForId(ApiAdapter api, Object pc) {
        if (pc == null) {
            return null;
        }
        Object id = api.getIdForObject(pc);
        if (IdentityUtils.isDatastoreIdentity(id) || IdentityUtils.isSingleFieldIdentity(id)) {
            return id;
        }
        return new CachedPC.CachedId(pc.getClass().getName(), id);
    }
}

