/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.adf.reader.convert;

import com.aliyun.dataworks.migrationx.domain.adf.AdfPackage;
import com.aliyun.dataworks.migrationx.domain.adf.Pipeline;
import com.aliyun.dataworks.migrationx.domain.adf.Trigger;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.type.AdfActivityType;
import com.aliyun.migration.workflow.migration.common.type.DbType;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AdfConverter {
    private static final Logger log = LoggerFactory.getLogger(AdfConverter.class);

    public WorkflowProjectPackage convert(AdfPackage adfpackage) throws NoSuchAlgorithmException {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(adfpackage.getFactory());
        workflowProject.setName(adfpackage.getFactory());
        workflowProjectPackage.setWorkflowProject(workflowProject);
        ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
        List pipelines = adfpackage.getPipelines();
        if (CollectionUtils.isEmpty((Collection)pipelines)) {
            log.error("not found pipeline from adfpackage");
            return workflowProjectPackage;
        }
        Map triggers = adfpackage.getTriggers();
        for (Pipeline pipeline : pipelines) {
            Trigger trigger = triggers.getOrDefault(pipeline.getName(), null);
            Workflow workflow = this.toWorkflow(workflowProject, pipeline, trigger);
            workflowList.add(workflow);
        }
        workflowProjectPackage.setWorkflowList(workflowList);
        return workflowProjectPackage;
    }

    private Workflow toWorkflow(WorkflowProject workflowProject, Pipeline pipeline, Trigger trigger) throws NoSuchAlgorithmException {
        Workflow workflow = new Workflow();
        workflow.setProjectId(workflowProject.getProjectId());
        workflow.setWorkflowId(AdfConverter.generateId(pipeline.getName()));
        workflow.setWorkflowName(pipeline.getName());
        workflow.setDescription(pipeline.getEtag());
        Pipeline.PipelineProperty properties = pipeline.getProperties();
        if (Objects.isNull(properties)) {
            return workflow;
        }
        if (Objects.nonNull(properties.getFolder())) {
            workflow.setCategoryValue(properties.getFolder().getName());
        }
        HashMap paramMap = new HashMap();
        JsonObject parameters = pipeline.getProperties().getParameters();
        if (Objects.nonNull(parameters)) {
            for (Object entry : parameters.entrySet()) {
                paramMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        workflow.setCustomProperties(paramMap);
        ArrayList<WorkflowNode> nodes = new ArrayList<WorkflowNode>();
        for (Object activity : properties.getActivities()) {
            WorkflowNode node = this.toNode(workflow, (Pipeline.PipelineProperty.Activity)activity);
            nodes.add(node);
        }
        workflow.setWorkflowNodes(nodes);
        ArrayList<RelationPackage> relationPackages = new ArrayList<RelationPackage>();
        for (Pipeline.PipelineProperty.Activity activity : properties.getActivities()) {
            String name = activity.getName();
            String nodeId = AdfConverter.generateId(workflow.getWorkflowName() + name);
            if (AdfActivityType.ExecutePipeline.name().equalsIgnoreCase(activity.getType())) {
                String referencePipeline = activity.getTypeProperties().getPipeline().getReferenceName();
                relationPackages.add(RelationPackage.builder().from(AdfConverter.generateId(referencePipeline)).to(nodeId).reType(RelationPackage.ReType.NODE_WORKFLOW).build());
                continue;
            }
            List dependsOn = activity.getDependsOn();
            if (CollectionUtils.isEmpty((Collection)dependsOn)) continue;
            for (Pipeline.PipelineProperty.Activity.DependActivity dependActivity : dependsOn) {
                String activityName = dependActivity.getActivity();
                String activityId = AdfConverter.generateId(workflow.getWorkflowName() + activityName);
                relationPackages.add(RelationPackage.builder().from(activityId).to(nodeId).reType(RelationPackage.ReType.NODE).build());
            }
        }
        WorkflowTrigger workflowTrigger = this.toWorkflowTrigger(workflow, trigger);
        workflow.setTriggers((List)ImmutableList.of((Object)workflowTrigger));
        return workflow;
    }

    private WorkflowNode toNode(Workflow workflow, Pipeline.PipelineProperty.Activity activity) throws NoSuchAlgorithmException {
        WorkflowNode workflowNode = new WorkflowNode();
        String workflowName = workflow.getWorkflowName();
        workflowNode.setProjectId(workflow.getProjectId());
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setNodeId(AdfConverter.generateId(workflowName + activity.getName()));
        workflowNode.setNodeName(activity.getName());
        workflowNode.setDescription(activity.getDescription());
        workflowNode.setNodeType(activity.getType());
        workflowNode.setScript(AdfConverter.getNodeContent(activity));
        workflowNode.setDbType(this.getDbType(activity));
        return workflowNode;
    }

    private String getDbType(Pipeline.PipelineProperty.Activity activity) {
        String type = activity.getType();
        AdfActivityType adfActivityType = null;
        try {
            adfActivityType = AdfActivityType.valueOf((String)type);
        }
        catch (Exception e) {
            log.error("not support this activiity type {}", (Object)type, (Object)e);
        }
        if (Objects.isNull(adfActivityType)) {
            return "";
        }
        switch (adfActivityType) {
            case DatabricksNotebook: {
                return DbType.DATABRICKS.name();
            }
            case HDInsightHive: {
                return DbType.HIVE.name();
            }
            case HDInsightSpark: {
                return DbType.SPARK.name();
            }
            case SynapseNotebook: {
                return DbType.SYNAPSE.name();
            }
        }
        return "";
    }

    private static String getNodeContent(Pipeline.PipelineProperty.Activity activity) {
        String type = activity.getType();
        AdfActivityType adfActivityType = null;
        try {
            adfActivityType = AdfActivityType.valueOf((String)type);
        }
        catch (Exception e) {
            log.error("not support this activiity type {}", (Object)type, (Object)e);
        }
        if (Objects.isNull(adfActivityType)) {
            return "";
        }
        switch (adfActivityType) {
            case DatabricksNotebook: 
            case HDInsightHive: 
            case HDInsightSpark: 
            case SynapseNotebook: {
                return activity.getTypeProperties().getNotebookPath();
            }
            case WebActivity: {
                return activity.getTypeProperties().getMethod() + " " + activity.getTypeProperties().getUrl();
            }
        }
        return "";
    }

    private WorkflowTrigger toWorkflowTrigger(Workflow workflow, Trigger trigger) {
        WorkflowTrigger workflowTrigger = new WorkflowTrigger();
        workflowTrigger.setProjectId(workflow.getProjectId());
        workflowTrigger.setWorkflowId(workflow.getWorkflowId());
        workflowTrigger.setName(trigger.getName());
        workflowTrigger.setType(trigger.getType());
        workflowTrigger.setCron(trigger.getProperties().getTypeProperties().getRecurrence().toString());
        return workflowTrigger;
    }

    private static String generateId(String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
        ByteBuffer buffer = ByteBuffer.wrap(hashBytes);
        long longValue = buffer.getLong();
        if (longValue == Long.MIN_VALUE) {
            return String.valueOf(Math.abs(buffer.getInt()));
        }
        return String.valueOf(Math.abs(buffer.getLong()));
    }
}

