/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.spec.domain.dataworks.node;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EndPoint {
    CN_BEIJING("\u534e\u53172\uff08\u5317\u4eac\uff09", "cn-beijing", "dataworks.cn-beijing.aliyuncs.com", "dataworks-vpc.cn-beijing.aliyuncs.com"),
    CN_ZHANGJIAKOU("\u534e\u53173\uff08\u5f20\u5bb6\u53e3\uff09", "cn-zhangjiakou", "dataworks.cn-zhangjiakou.aliyuncs.com", "dataworks-vpc.cn-zhangjiakou.aliyuncs.com"),
    CN_WULANCHABU("\u534e\u53176\uff08\u4e4c\u5170\u5bdf\u5e03\uff09", "cn-wulanchabu", "dataworks.cn-wulanchabu.aliyuncs.com", "dataworks-vpc.cn-wulanchabu.aliyuncs.com"),
    CN_HANGZHOU("\u534e\u4e1c1\uff08\u676d\u5dde\uff09", "cn-hangzhou", "dataworks.cn-hangzhou.aliyuncs.com", "dataworks-vpc.cn-hangzhou.aliyuncs.com"),
    CN_SHANGHAI("\u534e\u4e1c2\uff08\u4e0a\u6d77\uff09", "cn-shanghai", "dataworks.cn-shanghai.aliyuncs.com", "dataworks-vpc.cn-shanghai.aliyuncs.com"),
    CN_SHENZHEN("\u534e\u53571\uff08\u6df1\u5733\uff09", "cn-shenzhen", "dataworks.cn-shenzhen.aliyuncs.com", "dataworks-vpc.cn-shenzhen.aliyuncs.com"),
    AP_SOUTHEAST_3("\u9a6c\u6765\u897f\u4e9a\uff08\u5409\u9686\u5761\uff09", "ap-southeast-3", "dataworks.ap-southeast-3.aliyuncs.com", "dataworks-vpc.ap-southeast-3.aliyuncs.com"),
    AP_NORTHEAST_1("\u65e5\u672c\uff08\u4e1c\u4eac\uff09", "ap-northeast-1", "dataworks.ap-northeast-1.aliyuncs.com", "dataworks-vpc.ap-northeast-1.aliyuncs.com"),
    CN_CHENGDU("\u897f\u53571\uff08\u6210\u90fd\uff09", "cn-chengdu", "dataworks.cn-chengdu.aliyuncs.com", "dataworks-vpc.cn-chengdu.aliyuncs.com"),
    AP_SOUTHEAST_1("\u65b0\u52a0\u5761", "ap-southeast-1", "dataworks.ap-southeast-1.aliyuncs.com", "dataworks-vpc.ap-southeast-1.aliyuncs.com"),
    AP_SOUTHEAST_5("\u5370\u5ea6\u5c3c\u897f\u4e9a\uff08\u96c5\u52a0\u8fbe\uff09", "ap-southeast-5", "dataworks.ap-southeast-5.aliyuncs.com", "dataworks-vpc.ap-southeast-5.aliyuncs.com"),
    CN_HONGKONG("\u4e2d\u56fd\u9999\u6e2f", "cn-hongkong", "dataworks.cn-hongkong.aliyuncs.com", "dataworks-vpc.cn-hongkong.aliyuncs.com"),
    EU_CENTRAL_1("\u5fb7\u56fd\uff08\u6cd5\u5170\u514b\u798f\uff09", "eu-central-1", "dataworks.eu-central-1.aliyuncs.com", "dataworks-vpc.eu-central-1.aliyuncs.com"),
    US_EAST_1("\u7f8e\u56fd\uff08\u5f17\u5409\u5c3c\u4e9a\uff09", "us-east-1", "dataworks.us-east-1.aliyuncs.com", "dataworks-vpc.us-east-1.aliyuncs.com"),
    US_WEST_1("\u7f8e\u56fd\uff08\u7845\u8c37\uff09", "us-west-1", "dataworks.us-west-1.aliyuncs.com", "dataworks-vpc.us-west-1.aliyuncs.com"),
    EU_WEST_1("\u82f1\u56fd\uff08\u4f26\u6566\uff09", "eu-west-1", "dataworks.eu-west-1.aliyuncs.com", "dataworks-vpc.eu-west-1.aliyuncs.com"),
    CN_HANGZHOU_FINANCE("\u534e\u4e1c1 \u91d1\u878d\u4e91", "cn-hangzhou-finance", "dataworks.aliyuncs.com", ""),
    CN_SHANGHAI_FINANCE_1("\u534e\u4e1c2 \u91d1\u878d\u4e91", "cn-shanghai-finance-1", "dataworks.cn-shanghai-finance-1.aliyuncs.com", "dataworks-vpc.cn-shanghai-finance-1.aliyuncs.com"),
    CN_SHENZHEN_FINANCE_1("\u534e\u53571 \u91d1\u878d\u4e91", "cn-shenzhen-finance-1", "dataworks.cn-shenzhen-finance-1.aliyuncs.com", "dataworks-vpc.cn-shenzhen-finance-1.aliyuncs.com"),
    ME_EAST_1("\u963f\u8054\u914b\uff08\u8fea\u62dc\uff09", "me-east-1", "dataworks.me-east-1.aliyuncs.com", "dataworks-vpc.me-east-1.aliyuncs.com"),
    ME_CENTRAL_1("\u6c99\u7279\uff08\u5229\u96c5\u5f97\uff09", "me-central-1", "dataworks.me-central-1.aliyuncs.com", "dataworks-vpc.me-central-1.aliyuncs.com");

    private static final Logger log;
    private String description;
    private String name;
    private String url;
    private String vpcUrl;

    private EndPoint(String description, String name, String url, String vpcUrl) {
        this.description = description;
        this.name = name;
        this.url = url;
        this.vpcUrl = vpcUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVpcUrl() {
        return this.vpcUrl;
    }

    public static EndPoint getEndPoint(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            log.warn("DataWorks Endpoint\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u676d\u5dde");
            return CN_HANGZHOU;
        }
        for (EndPoint endPoint : EndPoint.values()) {
            if (!endPoint.getName().equals(name)) continue;
            return endPoint;
        }
        for (EndPoint endPoint : EndPoint.values()) {
            if (!endPoint.getUrl().equals(name)) continue;
            return endPoint;
        }
        for (EndPoint endPoint : EndPoint.values()) {
            if (!endPoint.getVpcUrl().equals(name)) continue;
            return endPoint;
        }
        for (EndPoint endPoint : EndPoint.values()) {
            if (!endPoint.getDescription().equals(name)) continue;
            return endPoint;
        }
        log.warn("DataWorks Endpoint\u8bbe\u7f6e\u975e\u6cd5\uff1a{}\uff0c\u9ed8\u8ba4\u676d\u5dde", (Object)name);
        return CN_HANGZHOU;
    }

    static {
        log = LoggerFactory.getLogger(EndPoint.class);
    }
}

