/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.spec.domain.dataworks;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.common.DependencyNodeSpec;
import com.aliyun.migration.spec.domain.dataworks.common.ElementKind;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class CycleWorkflowBatchSpec {
    private String name;
    private String id;
    private ElementKind type;
    private String owner;
    private List<CycleWorkflowSingleSpec> workflows;
    private List<DependencyNodeSpec> flow;

    public static CycleWorkflowBatchSpec getCycleWorkflowBatchSpec(String jsonStr) {
        CycleWorkflowBatchSpec cycleWorkflowBatchSpec = (CycleWorkflowBatchSpec)JSONObject.parseObject((String)jsonStr, CycleWorkflowBatchSpec.class);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        if (jsonObject.containsKey("workflows")) {
            cycleWorkflowBatchSpec.setWorkflows(new ArrayList<CycleWorkflowSingleSpec>());
            ((JSONArray)jsonObject.get("workflows")).forEach(workflow -> cycleWorkflowBatchSpec.getWorkflows().add(CycleWorkflowSingleSpec.getCycleWorkflowSingleSpec(((JSONObject)workflow).toJSONString(new JSONWriter.Feature[0]))));
        }
        return cycleWorkflowBatchSpec;
    }

    public static JSONObject getCycleWorkflowBatchSpecJson(CycleWorkflowBatchSpec cycleWorkflowBatchSpec) {
        JSONObject jsonObject = JSONObject.from((Object)cycleWorkflowBatchSpec);
        if (cycleWorkflowBatchSpec.getWorkflows() != null && !cycleWorkflowBatchSpec.getWorkflows().isEmpty()) {
            JSONArray workflowsArray = new JSONArray();
            cycleWorkflowBatchSpec.getWorkflows().forEach(workflow -> workflowsArray.add((Object)CycleWorkflowSingleSpec.getCycleWorkflowSingleSpecJson(workflow)));
            jsonObject.put((Object)"workflows", (Object)workflowsArray);
        }
        jsonObject.put((Object)"type", (Object)cycleWorkflowBatchSpec.getType().getKind());
        return jsonObject;
    }

    public static List<Workflow> getWorkflowList(List<CycleWorkflowBatchSpec> cycleWorkflowBatchSpecList, Map<String, String> extraNodeOutputIdMap, Map<String, String> extraWorkflowOutputIdMap) {
        CycleWorkflowBatchSpec spec = new CycleWorkflowBatchSpec();
        spec.setWorkflows(new ArrayList<CycleWorkflowSingleSpec>());
        spec.setFlow(new ArrayList<DependencyNodeSpec>());
        cycleWorkflowBatchSpecList.forEach(cycleWorkflowBatchSpec -> {
            if (cycleWorkflowBatchSpec.getWorkflows() != null && !cycleWorkflowBatchSpec.getWorkflows().isEmpty()) {
                spec.getWorkflows().addAll(cycleWorkflowBatchSpec.getWorkflows());
            }
            if (cycleWorkflowBatchSpec.getFlow() != null && !cycleWorkflowBatchSpec.getFlow().isEmpty()) {
                spec.getFlow().addAll(cycleWorkflowBatchSpec.getFlow());
            }
        });
        return CycleWorkflowBatchSpec.getWorkflowList(spec, extraNodeOutputIdMap, extraWorkflowOutputIdMap);
    }

    public static List<Workflow> getWorkflowList(List<CycleWorkflowBatchSpec> cycleWorkflowBatchSpecList) {
        return CycleWorkflowBatchSpec.getWorkflowList(cycleWorkflowBatchSpecList, null, null);
    }

    public static List<Workflow> getWorkflowList(CycleWorkflowBatchSpec cycleWorkflowBatchSpec, Map<String, String> extraNodeOutputIdMap, Map<String, String> extraWorkflowOutputIdMap) {
        List<Workflow> result = CycleWorkflowSingleSpec.getWorkflowList(cycleWorkflowBatchSpec.getWorkflows(), extraNodeOutputIdMap, extraWorkflowOutputIdMap);
        if (cycleWorkflowBatchSpec.getFlow() != null && !cycleWorkflowBatchSpec.getFlow().isEmpty()) {
            if (MapUtils.isEmpty(extraNodeOutputIdMap)) {
                extraNodeOutputIdMap = new HashMap<String, String>();
            }
            if (MapUtils.isEmpty(extraWorkflowOutputIdMap)) {
                extraWorkflowOutputIdMap = new HashMap<String, String>();
            }
            HashMap<String, String> mxWfOutputIdMap = new HashMap<String, String>();
            HashMap<String, String> mxNodeOutputIdMap = new HashMap<String, String>();
            mxWfOutputIdMap.putAll(extraWorkflowOutputIdMap);
            mxNodeOutputIdMap.putAll(extraNodeOutputIdMap);
            HashMap mxWfIdMap = new HashMap();
            for (CycleWorkflowSingleSpec wfSpec : cycleWorkflowBatchSpec.getWorkflows()) {
                wfSpec.getOutputs().getNodeOutputs().forEach(nodeOutput -> mxWfOutputIdMap.put(nodeOutput.getData(), wfSpec.getId()));
                for (NodeSingleSpec nodeSpec : wfSpec.getNodes()) {
                    nodeSpec.getOutputs().getNodeOutputs().forEach(nodeOutput -> mxNodeOutputIdMap.put(nodeOutput.getData(), nodeSpec.getId()));
                }
            }
            result.forEach(wf -> mxWfIdMap.put(wf.getWorkflowId(), wf));
            cycleWorkflowBatchSpec.getFlow().forEach(flow -> {
                if (mxWfIdMap.containsKey(flow.getNodeId())) {
                    Workflow childWf = (Workflow)mxWfIdMap.get(flow.getNodeId());
                    if (childWf.getNodeRelations() == null) {
                        childWf.setNodeRelations(new ArrayList());
                    }
                    flow.getDepends().forEach(depend -> {
                        if (mxNodeOutputIdMap.containsKey(depend.getOutput())) {
                            String parentNodeId = (String)mxNodeOutputIdMap.get(depend.getOutput());
                            RelationPackage relationPackage = new RelationPackage();
                            relationPackage.setFrom(parentNodeId);
                            relationPackage.setTo(childWf.getWorkflowId());
                            relationPackage.setReType(RelationPackage.ReType.NODE_WORKFLOW);
                            childWf.getNodeRelations().add(relationPackage);
                        } else if (mxWfOutputIdMap.containsKey(depend.getOutput())) {
                            String parentWfId = (String)mxWfOutputIdMap.get(depend.getOutput());
                            RelationPackage relationPackage = new RelationPackage();
                            relationPackage.setFrom(parentWfId);
                            relationPackage.setTo(childWf.getWorkflowId());
                            relationPackage.setReType(RelationPackage.ReType.WORKFLOW);
                            childWf.getNodeRelations().add(relationPackage);
                        }
                    });
                }
            });
            extraNodeOutputIdMap.putAll(mxNodeOutputIdMap);
            extraWorkflowOutputIdMap.putAll(mxWfOutputIdMap);
        }
        return result;
    }

    public static List<Workflow> getWorkflowList(CycleWorkflowBatchSpec cycleWorkflowBatchSpec) {
        return CycleWorkflowBatchSpec.getWorkflowList(cycleWorkflowBatchSpec, null, null);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(ElementKind type) {
        this.type = type;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setWorkflows(List<CycleWorkflowSingleSpec> workflows) {
        this.workflows = workflows;
    }

    public void setFlow(List<DependencyNodeSpec> flow) {
        this.flow = flow;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ElementKind getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<CycleWorkflowSingleSpec> getWorkflows() {
        return this.workflows;
    }

    public List<DependencyNodeSpec> getFlow() {
        return this.flow;
    }
}

