/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv3.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.dsv1.handle.AbstractDolphinv1Handler;
import com.aliyun.migration.workflow.migration.dsv3.handle.Dolphinv3FileHandler;
import com.aliyun.migration.workflow.migration.dsv3.handle.Dolphinv3OpenApiHandler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv3Reader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv3Reader.class);
    private AbstractDolphinv1Handler dolphinv1Handler;

    public List<WorkflowProject> getProjectList() {
        ArrayList res = new ArrayList();
        return this.dolphinv1Handler.getProjectList();
    }

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(scheduleDataSource);
        this.dolphinv1Handler = scheduleDataSource.getOperaterType() == Datasource.OperaterType.AUTO ? new Dolphinv3OpenApiHandler(scheduleDataSource, taskContext) : new Dolphinv3FileHandler(scheduleDataSource, taskContext);
        this.dolphinv1Handler.init();
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        return this.dolphinv1Handler.preCheck(scheduleDataSource);
    }

    public WorkflowProjectPackage read() throws Exception {
        WorkflowProjectPackage workflowProjectPackage = this.dolphinv1Handler.read();
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }
}

