/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv3.handle;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerPackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.service.DolphinSchedulerV3PackageLoader;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.dsv1.handle.Dolphinv1FileHandler;
import com.aliyun.migration.workflow.migration.dsv3.converter.Dolphinv32WorkflowConverter;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv3FileHandler
extends Dolphinv1FileHandler {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv3FileHandler.class);
    private Dolphinv32WorkflowConverter converter = new Dolphinv32WorkflowConverter();
    protected DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> dolphinSchedulerPackage;
    private Map<String, Map<String, String>> projectParam;

    public void init() {
        this.dolphinSchedulerPackage = this.load();
    }

    public Dolphinv3FileHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    protected DolphinSchedulerPackage load() {
        Map properties = this.scheduleDataSource.getProperties();
        String packagePath = properties.getOrDefault("source-file-path", "temp/dolphinv1/");
        File rootDir = new File(packagePath);
        try {
            File dataDir;
            Boolean isZip = false;
            if (rootDir.isFile()) {
                dataDir = ZipUtils.decompress((File)rootDir);
                isZip = true;
            } else {
                dataDir = rootDir;
            }
            log.info("load.file.success,dataDir:{}", (Object)dataDir.getAbsolutePath());
            DolphinSchedulerV3PackageLoader loader = new DolphinSchedulerV3PackageLoader(dataDir);
            loader.loadPackage();
            DolphinSchedulerPackage dolphinSchedulerPackage = loader.getDolphinSchedulerPackage();
            return dolphinSchedulerPackage;
        }
        catch (IOException e) {
            log.error("init.dolphin.export.error", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DOLPHIN_LOADER_FILE_FAILED);
        }
    }

    protected DolphinSchedulerPackageLoader getLoader(File unzippedDir) {
        return new DolphinSchedulerV3PackageLoader(unzippedDir);
    }

    public WorkflowProjectPackage read() {
        WorkflowProjectPackage projectPackage = this.converter.convert(this.dolphinSchedulerPackage);
        projectPackage.getWorkflowList().forEach(x -> {
            if (x.getCustomProperties() == null) {
                x.setCustomProperties(new HashMap());
            }
        });
        return projectPackage;
    }
}

