/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv3.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Flag;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.utils.SeatunnelUtils;
import com.aliyun.migration.workflow.migration.common.type.DolphinV3NodeType;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv32WorkflowConverter {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv32WorkflowConverter.class);

    public WorkflowProjectPackage convert(DolphinSchedulerPackage<Project, DagData, DataSource, ResourceComponent, UdfFunc> aPackage) {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        Object projectsObj = aPackage.getProjects().get(0);
        Project project = (Project)BwmJsonUtil.deepCopy(projectsObj, Project.class);
        workflowProjectPackage.setWorkflowProject(this.convertProject(Objects.requireNonNull(project)));
        List datasources = aPackage.getDatasources();
        List datasourceList = ((List)Optional.ofNullable(datasources).orElse(new ArrayList())).stream().map(this::convertDataSource).collect(Collectors.toList());
        workflowProjectPackage.setDatasources(datasourceList);
        List resources = aPackage.getResources();
        ArrayList resourceList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resources)) {
            resources.forEach(x -> this.convertResource((ResourceComponent)x, resourceList, ""));
            resourceList.forEach(x -> x.setPath(aPackage.getPackageRoot() + x.getPath()));
        }
        workflowProjectPackage.setFiles(resourceList);
        List functions = aPackage.getUdfFuncs();
        List functionList = functions.stream().map(this::convertUdfFunc).collect(Collectors.toList());
        workflowProjectPackage.setFunctions(functionList);
        ArrayList dags = new ArrayList();
        aPackage.getProcessDefinitions().values().forEach(dags::addAll);
        List workflowList = dags.stream().map(x -> {
            Workflow workflow = this.convertWorkflow((DagData)x);
            return workflow;
        }).collect(Collectors.toList());
        workflowProjectPackage.setWorkflowList(workflowList);
        this.completeNodeDatasourceInfo(workflowProjectPackage);
        return workflowProjectPackage;
    }

    private void completeNodeDatasourceInfo(WorkflowProjectPackage workflowProjectPackage) {
        List datasourceList = workflowProjectPackage.getDatasources();
        if (datasourceList == null || datasourceList.isEmpty()) {
            return;
        }
        if (workflowProjectPackage.getWorkflowList() != null && !workflowProjectPackage.getWorkflowList().isEmpty()) {
            workflowProjectPackage.getWorkflowList().forEach(wf -> {
                if (wf.getWorkflowNodes() != null && !wf.getWorkflowNodes().isEmpty()) {
                    wf.getWorkflowNodes().forEach(node -> {
                        block19: {
                            block20: {
                                JSONObject dataxJson;
                                block21: {
                                    if (!node.getNodeType().equals(DolphinV3NodeType.DATAX.name())) break block20;
                                    dataxJson = JSONObject.parseObject((String)node.getScript());
                                    if ((Integer)dataxJson.getObject("customConfig", Integer.class, new JSONReader.Feature[0]) != 0) break block21;
                                    String sourceDbType = "";
                                    String sourceDbName = "";
                                    String targetDbType = "";
                                    String targetDbName = "";
                                    for (WorkflowDatasource ds : datasourceList) {
                                        if (ds.getDatasourceId().equals(dataxJson.getLong("dataSource")) || ds.getDatasourceId().equals(dataxJson.getString("dataSource"))) {
                                            dataxJson.put((Object)"dataSourceInfo", (Object)JSONObject.from((Object)ds));
                                            sourceDbType = ds.getType();
                                            sourceDbName = ds.getName();
                                        }
                                        if (!ds.getDatasourceId().equals(dataxJson.getLong("dataTarget")) && !ds.getDatasourceId().equals(dataxJson.getString("dataTarget"))) continue;
                                        dataxJson.put((Object)"dataTargetInfo", (Object)JSONObject.from((Object)ds));
                                        targetDbType = ds.getType();
                                        targetDbName = ds.getName();
                                    }
                                    node.setScript(dataxJson.toJSONString(new JSONWriter.Feature[0]));
                                    if (StringUtils.isNotBlank((CharSequence)sourceDbType) || StringUtils.isNotBlank((CharSequence)targetDbType)) {
                                        node.setDbType(sourceDbType + "," + targetDbType);
                                    }
                                    if (!StringUtils.isNotBlank((CharSequence)sourceDbName) && !StringUtils.isNotBlank((CharSequence)targetDbName)) break block19;
                                    if (node.getCustomProperties() == null) {
                                        node.setCustomProperties(new HashMap());
                                    }
                                    node.getCustomProperties().put("datasource", sourceDbName + "," + targetDbName);
                                    break block19;
                                }
                                try {
                                    JSONObject dataxRealJson = JSONObject.parseObject((String)dataxJson.getString("json"));
                                    String sourceDbType = "";
                                    String targetDbType = "";
                                    if (dataxRealJson.containsKey("job") && dataxRealJson.getJSONObject("job").containsKey("content") && dataxRealJson.getJSONObject("job").getJSONArray("content").size() > 0) {
                                        if (dataxRealJson.getJSONObject("job").getJSONArray("content").getJSONObject(0).containsKey("reader")) {
                                            sourceDbType = dataxRealJson.getJSONObject("job").getJSONArray("content").getJSONObject(0).getJSONObject("reader").getString("name");
                                            String string = sourceDbType = sourceDbType.endsWith("reader") ? sourceDbType.substring(0, sourceDbType.length() - "reader".length()) : sourceDbType;
                                        }
                                        if (dataxRealJson.getJSONObject("job").getJSONArray("content").getJSONObject(0).containsKey("writer")) {
                                            targetDbType = dataxRealJson.getJSONObject("job").getJSONArray("content").getJSONObject(0).getJSONObject("writer").getString("name");
                                            String string = targetDbType = targetDbType.endsWith("writer") ? targetDbType.substring(0, targetDbType.length() - "writer".length()) : targetDbType;
                                        }
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)sourceDbType) || StringUtils.isNotBlank((CharSequence)targetDbType)) {
                                        node.setDbType(sourceDbType + "," + targetDbType);
                                    }
                                    break block19;
                                }
                                catch (Exception e) {
                                    log.error("illegal.datax.error", (Throwable)e);
                                }
                                break block19;
                            }
                            if (node.getNodeType().equals(DolphinV3NodeType.SEATUNNEL.name())) {
                                try {
                                    JSONObject jsonObject = SeatunnelUtils.getSeatunnelConfigJson((String)JSONObject.parseObject((String)node.getScript()).getString("rawScript"));
                                    String sourceDbType = "";
                                    String targetDbType = "";
                                    if (jsonObject.containsKey("source")) {
                                        sourceDbType = jsonObject.getJSONArray("source").getJSONObject(0).getString("plugin_name");
                                    }
                                    if (jsonObject.containsKey("sink")) {
                                        targetDbType = jsonObject.getJSONArray("sink").getJSONObject(0).getString("plugin_name");
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)sourceDbType) || StringUtils.isNotBlank((CharSequence)targetDbType)) {
                                        node.setDbType(sourceDbType + "," + targetDbType);
                                    }
                                }
                                catch (Exception e) {
                                    log.error("illegal.seatunnel.error", (Throwable)e);
                                }
                            } else if (node.getNodeType().equals(DolphinV3NodeType.SQL.name()) && node.getCustomProperties() != null && node.getCustomProperties().containsKey("SQL_PARAM")) {
                                JSONObject sqlJson = JSONObject.parseObject((String)((String)node.getCustomProperties().get("SQL_PARAM")));
                                String datasourceId = sqlJson.getString("datasource");
                                for (WorkflowDatasource ds : datasourceList) {
                                    if (!ds.getDatasourceId().equals(datasourceId)) continue;
                                    node.getCustomProperties().put("datasource", ds.getName());
                                    break;
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private WorkflowDatasource convertDataSource(DataSource datasource) {
        WorkflowDatasource resDatasource = new WorkflowDatasource();
        resDatasource.setDatasourceId(Integer.toString(datasource.getId()));
        resDatasource.setName(datasource.getName());
        if (datasource.getType() != null) {
            resDatasource.setType(datasource.getType().getDescp());
        }
        String connectionParams = datasource.getConnectionParams();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        try {
            Map map = (Map)GsonUtils.defaultGson.fromJson(connectionParams, type);
            resDatasource.setCustomProperties(map);
        }
        catch (Exception e) {
            log.error("map.convert.error", (Throwable)e);
        }
        return resDatasource;
    }

    private void convertResource(ResourceComponent resourceInfo, List<WorkflowFileResource> resourceList, String resourceRootPath) {
        String fullName;
        if (CollectionUtils.size((Object)resourceInfo.getChildren()) > 0) {
            resourceInfo.getChildren().forEach(x -> this.convertResource((ResourceComponent)x, resourceList, resourceRootPath));
            return;
        }
        if (resourceInfo.isDirctory() || resourceInfo.isDirectory()) {
            return;
        }
        String fileName = fullName = resourceInfo.getFileName();
        String filePreFolder = "";
        if (fullName.contains("/")) {
            fileName = fullName.substring(fullName.lastIndexOf("/") + 1);
            filePreFolder = fullName.substring(0, fullName.length() - fileName.length());
        }
        WorkflowFileResource workflowFileResource = new WorkflowFileResource();
        workflowFileResource.setFileId(Integer.toString(resourceInfo.getId()));
        workflowFileResource.setName(fileName);
        workflowFileResource.setFolder(filePreFolder);
        workflowFileResource.setPath(resourceRootPath + "/resource/" + fullName);
        workflowFileResource.setFileType(resourceInfo.getType());
        workflowFileResource.setDescription(resourceInfo.getDescription());
        resourceList.add(workflowFileResource);
    }

    public static String getSubstringAfterThirdSlash(String str) {
        int count = 0;
        int index = 0;
        while (count < 3 && index != -1) {
            if ((index = str.indexOf(47, index + 1)) == -1) continue;
            ++count;
        }
        if (count == 3 && index != -1) {
            return str.substring(index + 1);
        }
        return "";
    }

    private WorkflowFunctionResource convertUdfFunc(UdfFunc udfFunc) {
        WorkflowFunctionResource wr = new WorkflowFunctionResource();
        wr.setClassName(udfFunc.getClassName());
        wr.setName(udfFunc.getFuncName());
        wr.setArgumentsDescription(udfFunc.getArgTypes());
        wr.setType(udfFunc.getType().getDescp());
        wr.setFileResources(String.valueOf(udfFunc.getResourceId()));
        wr.setUsageExample(udfFunc.getDescription());
        wr.setFunctionId(String.valueOf(udfFunc.getId()));
        return wr;
    }

    private WorkflowProject convertProject(Project project) {
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(String.valueOf(project.getCode()));
        workflowProject.setName(project.getName());
        workflowProject.setDescription(project.getDescription());
        return workflowProject;
    }

    private Workflow convertWorkflow(DagData dolphinData) {
        Workflow workflow = new Workflow();
        workflow.setProjectName(dolphinData.getProcessDefinition().getProjectName());
        workflow.setWorkflowName(dolphinData.getProcessDefinition().getName());
        workflow.setDescription(dolphinData.getProcessDefinition().getDescription());
        workflow.setParamMap(BwmCommonUtil.convertObjMap((Map)dolphinData.getProcessDefinition().getGlobalParamMap()));
        workflow.setWorkflowId(String.valueOf(dolphinData.getProcessDefinition().getCode()));
        List workflowNodes = ((List)Optional.ofNullable(dolphinData.getTaskDefinitionList()).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(TaskDefinition::getCode, Collectors.reducing((x, y) -> y))).values().stream().filter(Optional::isPresent).map(x -> this.convertNode((TaskDefinition)x.get())).collect(Collectors.toList());
        workflow.setWorkflowNodes(workflowNodes);
        Map<String, WorkflowNode> nodeMap = workflowNodes.stream().collect(Collectors.toMap(WorkflowNode::getNodeId, x -> x));
        List processDefinitionConnects = dolphinData.getProcessTaskRelationList();
        List<RelationPackage> relationPackages = this.dealNodeRelation(processDefinitionConnects);
        workflow.setNodeRelations(relationPackages);
        ((List)Optional.ofNullable(processDefinitionConnects).orElse(new ArrayList())).forEach(x -> {
            if (x.getPreTaskCode() != 0L) {
                String endPointSourceId = String.valueOf(x.getPreTaskCode());
                String endPointTargetId = String.valueOf(x.getPostTaskCode());
                WorkflowNode sourceNode = (WorkflowNode)nodeMap.get(endPointSourceId);
                ArrayList<WorkflowNode> children = sourceNode.getChildren();
                if (CollectionUtils.isEmpty((Collection)children)) {
                    children = new ArrayList<WorkflowNode>();
                }
                WorkflowNode targetNode = (WorkflowNode)nodeMap.get(endPointTargetId);
                children.add(targetNode);
                sourceNode.setChildren(children);
            }
        });
        WorkflowTrigger workflowTrigger = this.convertTrigger(dolphinData.getSchedule());
        if (Objects.nonNull(workflowTrigger)) {
            workflow.setTriggers(Collections.singletonList(workflowTrigger));
        }
        return workflow;
    }

    private List<RelationPackage> dealNodeRelation(List<ProcessTaskRelation> processDefinitionConnects) {
        return ((List)Optional.ofNullable(processDefinitionConnects).orElse(new ArrayList())).stream().map(x -> {
            if (x.getPreTaskCode() != 0L) {
                String endPointSourceId = String.valueOf(x.getPreTaskCode());
                String endPointTargetId = String.valueOf(x.getPostTaskCode());
                return RelationPackage.builder().from(endPointSourceId).to(endPointTargetId).reType(RelationPackage.ReType.NODE).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private WorkflowTrigger convertTrigger(Schedule schedule) {
        WorkflowTrigger workflowTrigger = new WorkflowTrigger();
        if (Objects.isNull(schedule)) {
            log.info("no schedule");
            return null;
        }
        String scheduleCrontab = schedule.getCrontab();
        Date scheduleEndTime = schedule.getEndTime();
        Date scheduleStartTime = schedule.getStartTime();
        if (Objects.nonNull(scheduleEndTime)) {
            workflowTrigger.setEndTime(BwmCommonUtil.dateToLocalDateTime((Date)scheduleEndTime));
        }
        if (Objects.nonNull(scheduleStartTime)) {
            workflowTrigger.setStartTime(BwmCommonUtil.dateToLocalDateTime((Date)scheduleStartTime));
        }
        workflowTrigger.setCron(scheduleCrontab);
        workflowTrigger.setProjectName(schedule.getProjectName());
        return workflowTrigger;
    }

    private WorkflowNode convertNode(TaskDefinition taskNode) {
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setNodeId(String.valueOf(taskNode.getCode()));
        workflowNode.setNodeName(taskNode.getName());
        workflowNode.setNodeType(taskNode.getTaskType());
        workflowNode.setOwner(String.valueOf(taskNode.getUserId()));
        if (taskNode.getTaskPriority() != null) {
            workflowNode.setPriority(Integer.valueOf(taskNode.getTaskPriority().getCode()));
        }
        workflowNode.setDescription(taskNode.getDescription());
        workflowNode.setScript(taskNode.getTaskParams());
        if (taskNode.getFlag().equals((Object)Flag.NO)) {
            workflowNode.setState(WorkflowNode.Recurrence.SKIP);
        } else {
            workflowNode.setState(WorkflowNode.Recurrence.NORMAL);
        }
        if (workflowNode.getNodeType().equalsIgnoreCase("sql")) {
            this.extractSql(workflowNode);
        } else if (workflowNode.getNodeType().equalsIgnoreCase("shell")) {
            this.extractBash(workflowNode);
        } else {
            workflowNode.setParamMap(BwmCommonUtil.convertObjMap((Map)taskNode.getTaskParamMap()));
        }
        return workflowNode;
    }

    private void extractSql(WorkflowNode workflowNode) {
        try {
            JSONArray postStatements;
            String sql;
            if (!workflowNode.getNodeType().equalsIgnoreCase("sql")) {
                return;
            }
            String param = workflowNode.getScript();
            if (Objects.isNull(workflowNode.getCustomProperties())) {
                workflowNode.setCustomProperties(new HashMap());
            }
            workflowNode.getCustomProperties().put("SQL_PARAM", param);
            JSONObject jsonObject = JSON.parseObject((String)param);
            String dbType = jsonObject.getString("type");
            workflowNode.setDbType(dbType);
            ArrayList<String> sqls = new ArrayList<String>();
            JSONArray preStatements = jsonObject.getJSONArray("preStatements");
            if (!CollectionUtils.isEmpty((Collection)preStatements)) {
                for (int i = 0; i < preStatements.size(); ++i) {
                    String preSql = preStatements.getString(i);
                    sqls.add(preSql);
                }
            }
            if (!StringUtils.isBlank((CharSequence)(sql = jsonObject.getString("sql")))) {
                sqls.add(sql);
            }
            if (!CollectionUtils.isEmpty((Collection)(postStatements = jsonObject.getJSONArray("postStatements")))) {
                for (int i = 0; i < postStatements.size(); ++i) {
                    String postSql = postStatements.getString(i);
                    sqls.add(postSql);
                }
            }
            String sqlRes = StringUtils.join(sqls, (String)"\n");
            workflowNode.setScript(sqlRes);
        }
        catch (Exception e) {
            log.error("extract sql error ", (Throwable)e);
        }
    }

    private void extractBash(WorkflowNode workflowNode) {
        if (!workflowNode.getNodeType().equalsIgnoreCase("shell")) {
            return;
        }
        String param = workflowNode.getScript();
        if (param == null || param.length() == 0) {
            return;
        }
        if (Objects.isNull(workflowNode.getParamMap())) {
            workflowNode.setParamMap(new HashMap());
        }
        if (Objects.isNull(workflowNode.getFiles())) {
            workflowNode.setFiles(new ArrayList());
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)param);
            ((JSONArray)jsonObject.get("localParams")).forEach(x -> workflowNode.getParamMap().put(((JSONObject)x).getString("prop"), ((JSONObject)x).getString("value")));
            ((JSONArray)jsonObject.get("resourceList")).forEach(x -> {
                WorkflowFileResource resource = new WorkflowFileResource();
                resource.setName(((JSONObject)x).getString("resourceName"));
                workflowNode.getFiles().add(resource);
            });
            workflowNode.setScript(jsonObject.getString("rawScript"));
            workflowNode.setScriptPath(".sh");
        }
        catch (Exception e) {
            log.error("extract bash param error", (Throwable)e);
        }
    }
}

