package com.aliyun.mapper;


import com.aliyun.entity.Test;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface TestMapper {
    /**
     * select by id
     * @param id id
     * @return Test
     */
    @Select("SELECT * FROM `default`.`test` WHERE id = #{id} LIMIT 1")
    Test selectById(Long id) throws Exception;

    /**
     * count table
     * @return Test
     */
    @Select("SELECT count() as cnt FROM `default`.`test`")
    Long count() throws Exception;


    /**
     * batch insert by mybatis' FOREACH <br/>
     * Note: It is NOT SUGGESTED to use FOREACH to insert large number(>100) of records.
     *       Internally, it still generates the same single insert statement with
     *       many placeholders as the JDBC code above. MyBatis has an ability to
     *       cache PreparedStatement, but this statement cannot be cached because
     *       it contains FOREACH element and the statement varies depending on the
     *       parameters. As a result, MyBatis has to 1) evaluate the foreach part
     *       and 2) parse the statement string to build parameter mapping on every
     *       execution of this statement. And these steps are relatively costly
     *       process when the statement string is big and contains many placeholders.
     * @param tests tests
     */
    @Insert("<script>" +
            "INSERT INTO `default`.`test` (id, name) VALUES " +
            "<foreach item='test' collection='tests' separator=','>" +
            "(#{test.id},#{test.name})" +
            "</foreach>" +
            "</script>")
    void insertTests(@Param("tests") List<Test> tests) throws Exception;
}
