//
//  ViewController.m
//  FaceDetectDemo
//
//  Created by richard on 14/10/2017.
//  Copyright © 2017 com.alipay.faceDetect. All rights reserved.
//

#import "ViewController.h"
#import <AssetsLibrary/AssetsLibrary.h>
#import <CommonCrypto/CommonDigest.h>
#import "RSA.h"
#import "DemoSinglePickerView.h"
#import <ZolozFaceAuthFacade/ZolozFaceAuthFacade.h>

#define kBounce_size [UIScreen mainScreen].bounds.size

#define kSeverURL @"http://faceverify.cloud.alipay.com/v1/realface/app"

@interface ViewController ()< UINavigationControllerDelegate,UIImagePickerControllerDelegate,UIDocumentInteractionControllerDelegate>

@property(nonatomic, strong) NSData * imageContentData;
@property(nonatomic, strong) UITextField *nameTF;
@property(nonatomic, strong) UITextField *IDTF;
@property(nonatomic, strong) UITextField *experienceTF;
@property(nonatomic, strong) UITextField *certifyIdTF;
@property(nonatomic, strong) UIButton *beginVerifyBtn;
@property(nonatomic, strong) UIButton *resultBtn;
@property (nonatomic, copy) NSString  *certifyId;
@property(nonatomic, strong) UIButton *blinkBtn;
@property(nonatomic, strong) UIButton *multiactionBtn;
@property(nonatomic, strong) UIButton *photinusBtn;
/// 远近活体
@property(nonatomic, strong) UIButton *nearFarBtn;
@property(nonatomic, assign) BOOL isExperience;
@property(nonatomic, strong) UILabel *experienceLabel;
@property(nonatomic, strong) UILabel *certifyIdLabel;
@property(nonatomic, strong) UILabel *typeLabel;
@property(nonatomic, strong) UILabel *nameLabel;
@property(nonatomic, strong) UILabel *IDLabel;
@property(nonatomic, strong) UIButton *zimID_copyBtn;


@end

@implementation ViewController

//不支持动态切换横竖屏。
- (BOOL)shouldAutorotate{
    return NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self initUI];
    self.isExperience = YES;
    //SDK初始化，这个函数应该尽可能早调用。
    [ZolozFaceAuthFacade init];
    
    
}

- (void)initUI {
    UILabel *initLabelDesc = [[UILabel alloc] initWithFrame:CGRectMake(20, 60, 100, 30)];
    initLabelDesc.text = @"实人认证";
    initLabelDesc.textColor = [UIColor blueColor];
//    [self.view addSubview:initLabelDesc];

    UIButton *getCertifyIDBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    [getCertifyIDBtn setFrame:CGRectMake(kBounce_size.width-20-110, CGRectGetMinY(initLabelDesc.frame), 110, 30)];
    [getCertifyIDBtn addTarget:self action:@selector(getCertifyID) forControlEvents:UIControlEventTouchUpInside];
    getCertifyIDBtn.titleLabel.font = [UIFont systemFontOfSize:18];
    [getCertifyIDBtn setTitle:@"获取certifyId" forState:UIControlStateNormal];
//    [self.view addSubview:getCertifyIDBtn];
    
    UIView *seperateView = [[UIView alloc] initWithFrame:CGRectMake(20, initLabelDesc.frame.size.height + initLabelDesc.frame.origin.y, self.view.frame.size.width - 40, 1)];
    seperateView.backgroundColor = [UIColor blueColor];
//    [self.view addSubview:seperateView];
    
    UIButton * packageButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [packageButton setFrame:CGRectMake(15, CGRectGetMaxY(seperateView.frame) + 20, 200, 30)];
    [packageButton setTitle:@"体验" forState:UIControlStateNormal];
    [packageButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    UIImage *image = [UIImage imageNamed:@"push"];
    packageButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [packageButton setImage:image forState:UIControlStateNormal];
    packageButton.imageView.contentMode = UIViewContentModeScaleAspectFit;
    [packageButton setTitleEdgeInsets:UIEdgeInsetsMake(0, -image.size.width, 0, image.size.width)];
    [packageButton setImageEdgeInsets:UIEdgeInsetsMake(0, packageButton.titleLabel.bounds.size.width, 0, -packageButton.titleLabel.bounds.size.width)];
    [packageButton addTarget:self action:@selector(packageContentChange:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:packageButton];

    // 体验码
    UILabel *experienceLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, CGRectGetMaxY(packageButton.frame) + 20, 70, 30)];
    experienceLabel.text = @"体验码";
    experienceLabel.textColor = UIColor.grayColor;
    experienceLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:experienceLabel];
    self.experienceLabel = experienceLabel;
    self.experienceTF.frame = CGRectMake(CGRectGetMaxX(experienceLabel.frame)+15, CGRectGetMinY(experienceLabel.frame), kBounce_size.width-115, 30);
    
    // certifyId
    UILabel *certifyIdLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, CGRectGetMaxY(packageButton.frame) + 20, 70, 30)];
    certifyIdLabel.text = @"CertifyId";
    certifyIdLabel.textColor = UIColor.grayColor;
    certifyIdLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:certifyIdLabel];
    self.certifyIdLabel = certifyIdLabel;
    self.certifyIdLabel.hidden = YES;
    self.certifyIdTF.frame = CGRectMake(CGRectGetMaxX(experienceLabel.frame)+15, CGRectGetMinY(experienceLabel.frame), kBounce_size.width-115, 30);
    self.certifyIdTF.hidden = YES;
    self.certifyIdTF.text = @"8d349af5224814bb8adad9cfd97e855ad";
    
    // 活体方式
    UILabel *typeLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, CGRectGetMaxY(experienceLabel.frame) + 20, 70, 30)];
    typeLabel.text = @"活体方式";
    typeLabel.textColor = UIColor.grayColor;
    typeLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:typeLabel];
    self.typeLabel = typeLabel;
    
    
    // 活体方式
    self.blinkBtn= [[UIButton alloc] initWithFrame:CGRectMake(CGRectGetMaxX(typeLabel.frame) +15 , CGRectGetMaxY(experienceLabel.frame) + 20, (kBounce_size.width-200)/2, 30)];
    [self.blinkBtn setTitle:@"眨眼" forState:UIControlStateNormal];
    [self.blinkBtn setImage:[UIImage imageNamed:@"unchecked.png"] forState:UIControlStateNormal];
    [self.blinkBtn setImage:[UIImage imageNamed:@"checked.png"] forState:UIControlStateSelected];
    [self.blinkBtn setTitleColor:UIColor.grayColor forState:UIControlStateNormal];
    self.blinkBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    self.blinkBtn.contentEdgeInsets = UIEdgeInsetsMake(0,10, 0, 0);
    [self.view addSubview:self.blinkBtn];
    self.blinkBtn.tag = 1001;
    self.blinkBtn.selected = YES;
    [self.blinkBtn addTarget:self action:@selector(typeSwitch:) forControlEvents:UIControlEventTouchUpInside];

    
    // 活体方式
    self.multiactionBtn= [[UIButton alloc] initWithFrame:CGRectMake(CGRectGetMaxX(typeLabel.frame) +15 , CGRectGetMaxY(self.blinkBtn.frame) + 20, (kBounce_size.width-114)/2, 30)];
    [self.multiactionBtn setTitle:@"眨眼+多动作" forState:UIControlStateNormal];
    [self.multiactionBtn setImage:[UIImage imageNamed:@"unchecked.png"] forState:UIControlStateNormal];
    [self.multiactionBtn setImage:[UIImage imageNamed:@"checked.png"] forState:UIControlStateSelected];
    [self.multiactionBtn setTitleColor:UIColor.grayColor forState:UIControlStateNormal];
    self.multiactionBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    self.multiactionBtn.contentEdgeInsets = UIEdgeInsetsMake(0,10, 0, 0);
    [self.view addSubview:self.multiactionBtn];
    self.multiactionBtn.tag = 1002;
    [self.multiactionBtn addTarget:self action:@selector(typeSwitch:) forControlEvents:UIControlEventTouchUpInside];

    // 活体方式
    self.photinusBtn= [[UIButton alloc] initWithFrame:CGRectMake(CGRectGetMaxX(typeLabel.frame) +15 , CGRectGetMaxY(self.multiactionBtn.frame) + 20, (kBounce_size.width-114)/2, 30)];
    [self.photinusBtn setTitle:@"炫彩+眨眼" forState:UIControlStateNormal];
    [self.photinusBtn setImage:[UIImage imageNamed:@"unchecked.png"] forState:UIControlStateNormal];
    [self.photinusBtn setImage:[UIImage imageNamed:@"checked.png"] forState:UIControlStateSelected];
    [self.photinusBtn setTitleColor:UIColor.grayColor forState:UIControlStateNormal];
    self.photinusBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    self.photinusBtn.contentEdgeInsets = UIEdgeInsetsMake(0,10, 0, 0);
    [self.view addSubview:self.photinusBtn];
    self.photinusBtn.tag = 1003;
    [self.photinusBtn addTarget:self action:@selector(typeSwitch:) forControlEvents:UIControlEventTouchUpInside];
    
    self.nearFarBtn = [[UIButton alloc] initWithFrame:CGRectMake(CGRectGetMaxX(typeLabel.frame) +15 , CGRectGetMaxY(self.photinusBtn.frame) + 20, (kBounce_size.width-114)/2, 30)];
    [self.nearFarBtn setTitle:@"远近活体" forState:UIControlStateNormal];
    [self.nearFarBtn setImage:[UIImage imageNamed:@"unchecked.png"] forState:UIControlStateNormal];
    [self.nearFarBtn setImage:[UIImage imageNamed:@"checked.png"] forState:UIControlStateSelected];
    [self.nearFarBtn setTitleColor:UIColor.grayColor forState:UIControlStateNormal];
    self.nearFarBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    self.nearFarBtn.contentEdgeInsets = UIEdgeInsetsMake(0,10, 0, 0);
    [self.view addSubview:self.nearFarBtn];
    self.nearFarBtn.tag = 1004;
    [self.nearFarBtn addTarget:self action:@selector(typeSwitch:) forControlEvents:UIControlEventTouchUpInside];




    // 姓名
    UILabel *nameLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, CGRectGetMaxY(self.nearFarBtn.frame) + 20, 70, 30)];
    nameLabel.text = @"姓名";
    nameLabel.textColor = UIColor.grayColor;
    nameLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:nameLabel];
    self.nameLabel = nameLabel;
    self.nameTF.frame = CGRectMake(CGRectGetMaxX(nameLabel.frame)+15, CGRectGetMinY(nameLabel.frame), kBounce_size.width-115, 30);
    
    // 身份证
    UILabel *IDLabel = [[UILabel alloc] initWithFrame:CGRectMake(15, CGRectGetMaxY(nameLabel.frame) + 20, 70, 30)];
    IDLabel.text = @"身份证号";
    IDLabel.textAlignment = NSTextAlignmentCenter;
    IDLabel.textColor = UIColor.grayColor;
    [self.view addSubview:IDLabel];
    self.IDLabel = IDLabel;
    self.IDTF.frame = CGRectMake(CGRectGetMaxX(IDLabel.frame)+15, CGRectGetMinY(IDLabel.frame), kBounce_size.width-115, 30);
    [self.view addSubview:self.beginVerifyBtn];
    [self.view addSubview:self.resultBtn];

    // 复制certifyID
    UIButton *zimID_copyBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    [zimID_copyBtn setFrame:CGRectMake(16+32+(self.view.frame.size.width-64)/2, CGRectGetMaxY(self.IDTF.frame) + 30, (self.view.frame.size.width-64)/2, 40)];
    [zimID_copyBtn setTitle:@"复制CERTIFYID" forState:UIControlStateNormal];
    zimID_copyBtn.titleLabel.font = [UIFont systemFontOfSize:18];
    [zimID_copyBtn setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    [zimID_copyBtn setBackgroundColor:UIColor.whiteColor];
    [zimID_copyBtn.layer setMasksToBounds:YES];
    [zimID_copyBtn.layer setCornerRadius:10.0];
    [zimID_copyBtn.layer setBorderWidth:1.0];
    zimID_copyBtn.layer.borderColor = UIColor.grayColor.CGColor;
    [zimID_copyBtn addTarget:self action:@selector(copyZimIDClick) forControlEvents:UIControlEventTouchUpInside];
    self.zimID_copyBtn = zimID_copyBtn;
    self.zimID_copyBtn.hidden = YES;
    [self.view addSubview:zimID_copyBtn];
}
#pragma mark - 获取certifyID

- (void)getCertifyID {
    // todo增加炫彩button hidden
    if (self.isExperience){
        NSString *alertStr = [self judgeExperienceCode];
        if (alertStr){
            [self alertInfomation:alertStr];
            return;
        }
        alertStr = [self judgeName];
        if (alertStr){
            [self alertInfomation:alertStr];
            return;
        }
        alertStr = [self judgeIDNumber];
        if (alertStr){
            [self alertInfomation:alertStr];
            return;
        }
        //公钥
        NSString *publicKey = @"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApCMA3HuXpuNLdBgOYPqcCHx0rPggUNE/F/9FgQ/EaNvk26la+m+lgLLLaRRNdmQxdn3dg+9vvahfXr/lxDfZJ9VDv2mK/Rnnua1/o75vGF6+MD/lBc02+uqD07N9EiQlNREQb3Q/5d7Kc7H+eJUix7AU9YAol9SrOU6m6lI32GVnVdqrY7x9WQt02OgFag0jgzNexTdx1TM35kNa8ZiohlpSgvoKgmeKmHgwWKRsMpZ+/RbAWQZLkofoX4P7kqdGxNZtGWVHEcjphJqfx6q7CyFG2qTiGqFhAYu34CEIXWxQy5trUIiSMEBucGyPw+r8DSvoPT0tJ8tWthW1Oc23SQIDAQAB";
        NSMutableDictionary *dictParam = [NSMutableDictionary dictionaryWithCapacity:4];
        [dictParam setValue: [RSA encryptString:self.nameTF.text publicKey:publicKey] forKey:@"certName"];
        [dictParam setValue:[RSA encryptString:self.IDTF.text publicKey:publicKey] forKey:@"certNo"];
        [dictParam setValue:self.experienceTF.text forKey:@"caseCode"];
        if (self.blinkBtn.selected){
            [dictParam setValue:@"LIVENESS" forKey:@"interactionMode"];
        }else if (self.multiactionBtn.selected){
            [dictParam setValue:@"MULTI_ACTION" forKey:@"interactionMode"];
        } else if (self.photinusBtn.selected){
            [dictParam setValue:@"PHOTINUS_LIVENESS" forKey:@"interactionMode"];
        }
        else{
            [dictParam setValue:@"MOVE_ACTION" forKey:@"interactionMode"];
        }
        //添加metainfo数据。
        NSDictionary *dicMetaInfo = [ZolozFaceAuthFacade getMetaInfo];
        [dictParam setValue:dicMetaInfo forKey:@"metaInfo"];
        
        [self sendPostRequestWithURL:[NSURL URLWithString:kSeverURL] parStr:[self dictionaryToJson:dictParam]];

    }else{
        NSString *alertStr = [self judgeCertifyID];
        if (alertStr){
            [self alertInfomation:alertStr];
        }
        [self submitInfoForAliTech];
    }
}

- (void)sendPostRequestWithURL:(NSURL *)URL parStr:(NSString *)parStr {
    self.view.userInteractionEnabled = NO;
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:URL cachePolicy:0 timeoutInterval:15];
    request.HTTPMethod = @"post";
    [request setValue:@"application/json;charset=utf-8" forHTTPHeaderField:@"Content-Type"];
    NSData *data = [parStr dataUsingEncoding:NSUTF8StringEncoding];
    [request setHTTPBody: data];
    
    __weak ViewController *weakSelf = self;
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (!weakSelf) {
                return;
            }
            if (error) {
                [self alertInfomation:@"获取失败"];
                self.view.userInteractionEnabled = YES;
            } else {
                NSHTTPURLResponse *res = (NSHTTPURLResponse *)response;
                if (res.statusCode == 200 || res.statusCode == 304) {
                    NSError *err;
                    id json = [NSJSONSerialization JSONObjectWithData:data options:0 error:&err];
                    if ([json isKindOfClass:[NSDictionary class]]) {
                        if (![[json objectForKey:@"success"] boolValue]) {
                            [self alertInfomation:[json objectForKey:@"errorMessage"]];
                        } else {
                            self.certifyId = [[json objectForKey:@"data"] objectForKey:@"certifyId"];
//                            [self alertInfomation:@"获取成功" withMsg:self.certifyId];
                            [self submitInfoForAliTech];

                        }
                        self.view.userInteractionEnabled = YES;
                    }
                } else {
                    [self alertInfomation:@"获取失败"];
                    self.view.userInteractionEnabled = YES;
                }
            }
        });
    }];
    [dataTask resume];
}

- (void)sendGetRequestWithURL:(NSURL *)URL parStr:(NSString *)certifyId {
    self.view.userInteractionEnabled = NO;
    NSString *urlStr = [NSString stringWithFormat:@"%@?certifyId=%@",URL,certifyId];
    NSURL *url = [NSURL URLWithString:urlStr];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    __weak ViewController *weakSelf = self;
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (!weakSelf) {
                return;
            }
            if (error) {
                [self alertInfomation:@"查询失败"];
                self.view.userInteractionEnabled = YES;
            } else {
                NSHTTPURLResponse *res = (NSHTTPURLResponse *)response;
                if (res.statusCode == 200 || res.statusCode == 304) {
                    NSError *err;
                    id json = [NSJSONSerialization JSONObjectWithData:data options:0 error:&err];
                    if ([json isKindOfClass:[NSDictionary class]]) {
                        NSData *jsonData = [NSJSONSerialization dataWithJSONObject:json options:NSJSONWritingPrettyPrinted error:nil];
                        NSString * str = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
                        [self alertInfomation:@"查询成功" withMsg:str];
//
//                        if (![[json objectForKey:@"success"] boolValue]) {
//                            [self alertInfomation:[json objectForKey:@"errorMessage"]];
//                        } else {
//                        }
                        self.view.userInteractionEnabled = YES;
                    }
                } else {
                    [self alertInfomation:@"获取失败"];
                    self.view.userInteractionEnabled = YES;
                }
            }
        });
    }];
    [dataTask resume];
}

#pragma mark - 提交认证请求

- (void)submitInfoForAliTech {
    self.certifyId = @"ae9df006eb658cbec27842fe8684d4d8d";
    //要获取到certifyId后，才可以调用这个函数
    if ([self.certifyId length]<1) {
        [self alertInfomation:@"还未获取到certifyId"];
        return;
    }
    NSLog(@"certifyId ------>> %@",self.certifyId);
    [self.beginVerifyBtn setUserInteractionEnabled:NO];
    
    __weak ViewController*weakSelf = self;
    NSMutableDictionary  *extParams = [NSMutableDictionary new];
    [extParams setValue:self forKey:@"currentCtr"];
    [ZolozFaceAuthFacade verifyWith:self.certifyId extParams:extParams onCompletion:^(ZIMResponse *response) {
            dispatch_async(dispatch_get_main_queue(), ^{
            self.imageContentData = response.imageContent;
               NSString *title = @"刷脸成功";
               switch (response.code) {
                   case 1000:
                       break;
                   case 1003:
                       title = @"用户退出";
                       break;
                   case 2002:
                       title = @"网络错误";
                       break;
                   case 2006:
                       title = @"刷脸失败2006";
                       break;
                    case 2003:
                       title = @"设备时间不准确";
                       break;
                   default:
                       break;
            }
            [weakSelf alertInfomation:title withMsg:response.retMessageSub];
            [self.beginVerifyBtn setUserInteractionEnabled:YES];
        });
    }];
}

#pragma mark - 判断体验码、姓名、身份证号
- (NSString *)judgeExperienceCode {
    if (self.experienceTF.text.length > 32) {
        return @"体验码长度超出32位，请检查后重试!";
    }
    // '体验码'正则表达式筛选
    NSString *IsNumAndEnChPattern = @"^[A-Za-z0-9]+$";
    NSPredicate *IsNumAndEnChPredicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@",IsNumAndEnChPattern];
    if(![IsNumAndEnChPredicate evaluateWithObject:self.experienceTF.text]) {
        return @"体验码格式不正确，请检查后重试!";
    }
    return nil;
}

- (NSString *)judgeCertifyID{
    if (self.certifyIdTF.text.length > 0) {
        self.certifyId = self.certifyIdTF.text;
        return nil;
    }else{
        return @"请输入CertifId";
    }

}

- (NSString *)judgeName {
    // '真实姓名'正则表达式筛选
    NSString *realNamePattern = @"^[\u4e00-\u9fa5]{0,}";
    NSPredicate *realNamePredicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@",realNamePattern];
    if(![realNamePredicate evaluateWithObject:self.nameTF.text] || !self.nameTF.text.length) {
        return @"姓名格式不正确，请检查后重试!";
    }
    return nil;
}

- (NSString *)judgeIDNumber {
    // '身份证号'正则表达式筛选限制字数18位, 支持0-9的所有数字 最后以为可以是x或者X 大小写都支持
    NSString *identificationNumberPattern =@"\\d{17}[[0-9],0-9xX]";
    NSPredicate *identificationNumberPredicate = [NSPredicate predicateWithFormat:@"SELF MATCHES %@",identificationNumberPattern];
    if(![identificationNumberPredicate evaluateWithObject:self.IDTF.text]) {
        return @"身份证格式不正确，请检查后重试!";
    }
    return nil;
}

#pragma mark - 查询结果

- (void)queryResults {
    [self sendGetRequestWithURL:[NSURL URLWithString:kSeverURL] parStr:self.certifyId];
}


#pragma mark - 复制certifyID

- (void)copyZimIDClick {
    [UIPasteboard generalPasteboard].string = self.certifyId;
}

#pragma mark - 辅助方法

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

- (NSDictionary *)dictionaryWithJsonString:(NSString *)jsonString {
    if (jsonString == nil) {
        return nil;
    }
    NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding];
    NSError *err;
    NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:jsonData
                                                        options:NSJSONReadingMutableContainers
                                                          error:&err];
    if(err) {
        NSLog(@"json解析失败：%@",err);
        return nil;
    }
    return dic;
}

 - (NSDictionary *)dictionaryWithJsonData:(NSData *)jsonData {
     if (jsonData == nil) {
         return nil;
     }
     //NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding];
     NSError *err;
     NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:jsonData
                                                         options:NSJSONReadingMutableContainers
                                                           error:&err];
     if(err) {
         NSLog(@"json解析失败：%@",err);
         return nil;
     }
     return dic;
 }

- (NSString*)dictionaryToJson:(NSDictionary *)dic
{
    NSError *parseError = nil;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dic options:NSJSONWritingPrettyPrinted error:&parseError];
    return [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
}

-(void)alertInfomation:(NSString*)title{
    [self alertInfomation:@"" withMsg:title];
}

-(void)alertInfomation:(NSString*)title withMsg:(NSString*)msg{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title message:msg preferredStyle:UIAlertControllerStyleAlert];
    [alertController addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
    }]];
    [self presentViewController:alertController animated:YES completion:nil];
}

#pragma mark - lazy

- (UITextField *)experienceTF {
    if (!_experienceTF) {
        _experienceTF = [[UITextField alloc] init];
        _experienceTF.attributedPlaceholder = [[NSMutableAttributedString alloc] initWithString:@"请输入体验码" attributes:@{NSForegroundColorAttributeName :[UIColor grayColor]}];
        _experienceTF.textColor = UIColor.blackColor;
        [self.view addSubview:_experienceTF];
    }
    return _experienceTF;
}
- (UITextField *)certifyIdTF {
    if (!_certifyIdTF) {
        _certifyIdTF = [[UITextField alloc] init];
        _certifyIdTF.attributedPlaceholder = [[NSMutableAttributedString alloc] initWithString:@"请输入CertifyId" attributes:@{NSForegroundColorAttributeName :[UIColor grayColor]}];
        _certifyIdTF.textColor = UIColor.blackColor;
        [self.view addSubview:_certifyIdTF];
    }
    return _certifyIdTF;
}

- (UITextField *)nameTF {
    if (!_nameTF) {
        _nameTF = [[UITextField alloc] init];
        _nameTF.attributedPlaceholder = [[NSMutableAttributedString alloc] initWithString:@"请输入姓名" attributes:@{NSForegroundColorAttributeName :[UIColor grayColor]}];
        _nameTF.textColor = UIColor.blackColor;
        [self.view addSubview:_nameTF];
    }
    return _nameTF;
}

- (UITextField *)IDTF {
    if (!_IDTF) {
        _IDTF = [[UITextField alloc] init];
        _IDTF.attributedPlaceholder = [[NSMutableAttributedString alloc] initWithString:@"请输入身份证号码" attributes:@{NSForegroundColorAttributeName :[UIColor grayColor]}];
        _IDTF.textColor = UIColor.blackColor;
        [self.view addSubview:_IDTF];
    }
    return _IDTF;
}

- (UIButton *)beginVerifyBtn {
    if (!_beginVerifyBtn) {
        _beginVerifyBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_beginVerifyBtn setFrame:CGRectMake(16, CGRectGetMaxY(self.IDTF.frame) + 30, (self.view.frame.size.width-64)/2, 40)];
        [_beginVerifyBtn setTitle:@"开始认证" forState:UIControlStateNormal];
        _beginVerifyBtn.titleLabel.font = [UIFont systemFontOfSize:18];
        [_beginVerifyBtn setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
        [_beginVerifyBtn setBackgroundColor:UIColor.whiteColor];
        [_beginVerifyBtn.layer setMasksToBounds:YES];
        [_beginVerifyBtn.layer setCornerRadius:10.0];
        [_beginVerifyBtn.layer setBorderWidth:1.0];
        _beginVerifyBtn.layer.borderColor = UIColor.grayColor.CGColor;
        //主要代码在submitInfoForAliTech里面。
        [_beginVerifyBtn addTarget:self action:@selector(getCertifyID) forControlEvents:UIControlEventTouchUpInside];
    }
    return _beginVerifyBtn;
}
- (UIButton *)resultBtn {
    if (!_resultBtn) {
        _resultBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_resultBtn setFrame:CGRectMake(16+32+(self.view.frame.size.width-64)/2, CGRectGetMaxY(self.IDTF.frame) + 30, (self.view.frame.size.width-64)/2, 40)];
        [_resultBtn setTitle:@"查询结果" forState:UIControlStateNormal];
        _resultBtn.titleLabel.font = [UIFont systemFontOfSize:18];
        [_resultBtn setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
        [_resultBtn setBackgroundColor:UIColor.whiteColor];
        [_resultBtn.layer setMasksToBounds:YES];
        [_resultBtn.layer setCornerRadius:10.0];
        [_resultBtn.layer setBorderWidth:1.0];
        _resultBtn.layer.borderColor = UIColor.grayColor.CGColor;
        //主要代码在submitInfoForAliTech里面。
        [_resultBtn addTarget:self action:@selector(queryResults) forControlEvents:UIControlEventTouchUpInside];
    }
    return _resultBtn;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)typeSwitch:(UIButton *)btn{
    if (btn.tag == 1001){
        self.blinkBtn.selected = YES;
        self.multiactionBtn.selected = NO;
        self.photinusBtn.selected = NO;
        self.nearFarBtn.selected= NO;
    }else if (btn.tag == 1002){
        self.blinkBtn.selected = NO;
        self.multiactionBtn.selected = YES;
        self.photinusBtn.selected = NO;
        self.nearFarBtn.selected= NO;
    }else if(btn.tag == 1003 ){
        self.blinkBtn.selected = NO;
        self.multiactionBtn.selected = NO;
        self.photinusBtn.selected = YES;
        self.nearFarBtn.selected= NO;
    } else if (btn.tag == 1004) {
        self.blinkBtn.selected = NO;
        self.multiactionBtn.selected = NO;
        self.photinusBtn.selected = NO;
        self.nearFarBtn.selected= YES;
    }
}

-(void)packageContentChange:(UIButton *)btn {
    NSArray *array =@[@"体验",@"联调"];
    __weak ViewController*weakSelf = self;
    [DemoSinglePickerView showWithDataArray:array block:^(NSString *str, NSInteger index) {
        if ([btn isKindOfClass:[UIButton class]]) {
            [btn setTitle:str forState:UIControlStateNormal];
            switch (index) {
                case 0:
                    self.isExperience = YES;
                    break;
                case 1:
                    self.isExperience = NO;
                    break;
                default:
                    break;
            }
            [weakSelf chageTarget:index];
        }
    }];
}
-(void)chageTarget:(NSInteger)index{
    if (index == 0){
        self.zimID_copyBtn.hidden = YES;
        self.certifyIdLabel.hidden = YES;
        self.certifyIdTF.hidden = YES;
        self.experienceLabel.hidden = NO;
        self.experienceTF.hidden = NO;
        self.typeLabel.hidden = NO;
        self.blinkBtn.hidden = NO;
        self.multiactionBtn.hidden = NO;
        self.nameLabel.hidden = NO;
        self.nameTF.hidden = NO;
        self.IDLabel.hidden = NO;
        self.IDTF.hidden = NO;
        self.resultBtn.hidden = NO;
        self.beginVerifyBtn.hidden = NO;
        self.photinusBtn.hidden = NO;
        self.nearFarBtn.hidden = NO;
    }else{
        self.zimID_copyBtn.hidden = NO;
        self.certifyIdLabel.hidden = NO;
        self.certifyIdTF.hidden = NO;
        self.experienceLabel.hidden = YES;
        self.experienceTF.hidden = YES;
        self.typeLabel.hidden = YES;
        self.blinkBtn.hidden = YES;
        self.multiactionBtn.hidden = YES;
        self.nameLabel.hidden = YES;
        self.nameTF.hidden = YES;
        self.IDLabel.hidden = YES;
        self.IDTF.hidden = YES;
        self.photinusBtn.hidden = YES;
        self.nearFarBtn.hidden = YES;

        self.resultBtn.hidden = YES;
        self.beginVerifyBtn.hidden = NO;
    }
    
}


@end


