/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BinaryClassificationMetricsExample$ {
    public static final BinaryClassificationMetricsExample$ MODULE$;

    static {
        new BinaryClassificationMetricsExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("BinaryClassificationMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_binary_classification_data.txt");
        RDD[] rDDArray = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        Option option = Array$.MODULE$.unapplySeq((Object)rDDArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            RDD training = (RDD)((SeqLike)option.get()).apply(0);
            RDD test = (RDD)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)training, (Object)test);
            RDD training2 = (RDD)tuple22._1();
            RDD test2 = (RDD)tuple22._2();
            training2.cache();
            LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(2).run(training2);
            model.clearThreshold();
            RDD predictionAndLabels = test2.map((Function1)new Serializable(model){
                public static final long serialVersionUID = 0L;
                private final LogisticRegressionModel model$1;

                public final Tuple2<Object, Object> apply(LabeledPoint x0$1) {
                    LabeledPoint labeledPoint = x0$1;
                    if (labeledPoint != null) {
                        double label = labeledPoint.label();
                        Vector features = labeledPoint.features();
                        double prediction = this.model$1.predict(features);
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(prediction, label);
                        return sp2;
                    }
                    throw new MatchError((Object)labeledPoint);
                }
                {
                    this.model$1 = model$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels);
            RDD precision = metrics.precisionByThreshold();
            precision.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        double t = tuple2._1$mcD$sp();
                        double p = tuple2._2$mcD$sp();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", Precision: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)p)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            RDD recall = metrics.recallByThreshold();
            recall.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        double t = tuple2._1$mcD$sp();
                        double r = tuple2._2$mcD$sp();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", Recall: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)r)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            RDD PRC = metrics.pr();
            RDD f1Score = metrics.fMeasureByThreshold();
            f1Score.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, Object> x0$4) {
                    Tuple2<Object, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        double t = tuple2._1$mcD$sp();
                        double f = tuple2._2$mcD$sp();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", F-score: ", ", Beta = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)f)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            double beta = 0.5;
            RDD fScore = metrics.fMeasureByThreshold(beta);
            f1Score.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, Object> x0$5) {
                    Tuple2<Object, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        double t = tuple2._1$mcD$sp();
                        double f = tuple2._2$mcD$sp();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", F-score: ", ", Beta = 0.5"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)f)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            double auPRC = metrics.areaUnderPR();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Area under precision-recall curve = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)auPRC)})));
            RDD thresholds = precision.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$2) {
                    return x$2._1$mcD$sp();
                }
            }, ClassTag$.MODULE$.Double());
            RDD roc = metrics.roc();
            double auROC = metrics.areaUnderROC();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Area under ROC = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)auROC)})));
            sc.stop();
            return;
        }
        throw new MatchError((Object)rDDArray);
    }

    private BinaryClassificationMetricsExample$() {
        MODULE$ = this;
    }
}

