# 语音交互SDK说明

## 名词说明
P2T(Push To Talk): 按下按键开始说话，放开按键接收交互结果并播放。   
T2T(Tap To Talk): 轻点按钮，开始说话，停止说话后接收交互结果并播放。  
Duplex: 全双工模式，可语音打断，也支持TapToTalk。  
KWS_Duplex: 带唤醒功能的全双工模式，可语音打断，也支持TapToTalk。
  
## APP_CODE
02A: 通义千问（AEC+VAD） -> VoiceChat, 含VAD、AEC, 不含KWS, 可选RTC、WS  
02B: 星尘(AEC) -> 默认带RTC不带WS的VoiceChat，含内部AEC, 不含VAD、KWS, 可选RTC、WS, 星尘带RTC  
02C: 纯云端 -> 默认带RTC不带WS的VoiceChat，不含内部AEC、VAD、KWS, 可选RTC、WS  
02D: 含VAD -> 默认带RTC的VoiceChat，不含内部AEC，内部VAD, 可选RTC、WS  
02E: 完整本地功能 -> 含VAD、AEC、KWS, 可选RTC、WS  

## FUN_CODE
|FUN_CODE|        /            |          /             |                 |    内部模块     |                |          /          |         链路模式 |         /            |                     |  云端协议   |            |      /     |
|:------:|:-------------------:|:----------------------:|:---------------:|:--------------:|:--------------:|:-------------------:|:---------------:|:--------------------:|:------------------:|:----------:|:----------:|:----------:|
|        |23-20bit:<br>reserved|19bit:<br>内部Beamforming|18bit:<br>内部VAD|17bit:<br>内部AEC|16bit:<br>内部KWS|14-15bit:<br>reserved|13bit:<br>支持RTC|12bit:<br>支持Websocket|3-11bit:<br>reserved|2bit:<br>百炼|1bit:<br>NLS|0bit:<br>通义|
| 073007 |                     |                        | &#10003;        | &#10003;       | &#10003;       |                     | &#10003;        | &#10003;             |                    | &#10003;   | &#10003;   | &#10003;    |
| 063007 |                     |                        | &#10003;        | &#10003;       |                    |                     | &#10003;        | &#10003;             |                    | &#10003;   | &#10003;   | &#10003;    |
| 003007 |                     |                        |                 |                |                    |                     | &#10003;        | &#10003;             |                    | &#10003;   | &#10003;   | &#10003;    |
| 003004 |                     |                        |                 |                |                    |                     | &#10003;        | &#10003;             |                    | &#10003;   |            |             |

## 生成物说明: 
V1.3.4-02E-20250706_Linux/  
│── bin        Linux下可执行程序  
│── demo       bin下可执行程序的源码, 用户编译需要另外加入其他三方库如json  
│── include    SDK接口需要的头文件  
│── lib  
│   └── libconversation.so    SDK成果物动态库  
│── demo  
│   └── convBaiLianApiDemo    BaiLian协议的SDK API代码测试程序  
│── resources       SDK运行需要的资源文件, 根据业务场景选择  
│── README.md       说明文件
└── release.note    版本迭代说明

测试程序运行: 
> DEMO示例:  
> ./convBaiLianApiDemo --url wss://dashscope.aliyuncs.com/api-ws/v1/inference --app_id mm_XXXXXX --workspace_id llm-XXXXXX --workspace resources_aec_vad_android/ --file asr_example.wav --mode duplex --debug_path ./tmp --audio_format opus --apikey XXXXXXXX  

## 三方库说明
1. OpenSSL 1.1.1d
2. ogg-1.3.2  
3. opus-1.2.1  


## TLS相关
### OpenSSL支持加密套件：
> Supported cipher suites:  
1 : TLS_AES_256_GCM_SHA384 - TLSv1.3  
2 : TLS_AES_128_GCM_SHA256 - TLSv1.3  
3 : RSA-PSK-AES256-GCM-SHA384 - TLSv1.2  
4 : AES256-GCM-SHA384 - TLSv1.2  
5 : AES256-CCM8 - TLSv1.2  
6 : AES256-CCM - TLSv1.2  
7 : PSK-AES256-GCM-SHA384 - TLSv1.2  
8 : PSK-AES256-CCM8 - TLSv1.2  
9 : PSK-AES256-CCM - TLSv1.2  
10 : RSA-PSK-AES128-GCM-SHA256 - TLSv1.2  
11 : AES128-GCM-SHA256 - TLSv1.2  
12 : AES128-CCM8 - TLSv1.2  
13 : AES128-CCM - TLSv1.2  
14 : PSK-AES128-GCM-SHA256 - TLSv1.2  
15 : PSK-AES128-CCM8 - TLSv1.2  
16 : PSK-AES128-CCM - TLSv1.2  
17 : AES256-SHA256 - TLSv1.2  
18 : AES128-SHA256 - TLSv1.2  
19 : RSA-PSK-AES256-CBC-SHA384 - TLSv1.0  
20 : RSA-PSK-AES256-CBC-SHA - SSLv3  
21 : AES256-SHA - SSLv3  
22 : PSK-AES256-CBC-SHA384 - TLSv1.0  
23 : PSK-AES256-CBC-SHA - SSLv3  
24 : RSA-PSK-AES128-CBC-SHA256 - TLSv1.0  
25 : RSA-PSK-AES128-CBC-SHA - SSLv3  
26 : AES128-SHA - SSLv3  
27 : PSK-AES128-CBC-SHA256 - TLSv1.0  
28 : PSK-AES128-CBC-SHA - SSLv3  

dashscope.aliyuncs.com 建连时使用的是 AES128-GCM-SHA256  

### Mbedtls支持加密套件：
> Supported cipher suites:  
1 : TLS1-3-AES-128-GCM-SHA256
2 : TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256
3 : TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256
4 : TLS-RSA-WITH-AES-128-GCM-SHA256
5 : TLS-ECDH-RSA-WITH-AES-128-GCM-SHA256
6 : TLS-ECDH-ECDSA-WITH-AES-128-GCM-SHA256
7 : TLS-RSA-PSK-WITH-AES-128-GCM-SHA256
8 : TLS-PSK-WITH-AES-128-GCM-SHA256

dashscope.aliyuncs.com 建连时使用的是 TLS1-3-AES-128-GCM-SHA256 TLSv1.3 
