/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jindo;

import com.aliyun.jindodata.common.JindoHadoopSystem;
import com.aliyun.jindodata.dls.JindoDlsFileSystem;
import com.aliyun.jindodata.oss.JindoOssFileSystem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.jindo.HadoopCompliantFileIO;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoFileIO
extends HadoopCompliantFileIO {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(JindoFileIO.class);
    private static final String[] CONFIG_PREFIXES = new String[]{"fs."};
    private static final String OSS_ACCESS_KEY_ID = "fs.oss.accessKeyId";
    private static final String OSS_ACCESS_KEY_SECRET = "fs.oss.accessKeySecret";
    private static final String OSS_SECURITY_TOKEN = "fs.oss.securityToken";
    private static final Map<String, String> CASE_SENSITIVE_KEYS = new HashMap<String, String>(){
        {
            this.put(JindoFileIO.OSS_ACCESS_KEY_ID.toLowerCase(), JindoFileIO.OSS_ACCESS_KEY_ID);
            this.put(JindoFileIO.OSS_ACCESS_KEY_SECRET.toLowerCase(), JindoFileIO.OSS_ACCESS_KEY_SECRET);
            this.put(JindoFileIO.OSS_SECURITY_TOKEN.toLowerCase(), JindoFileIO.OSS_SECURITY_TOKEN);
        }
    };
    private static final Map<CacheKey, Pair<JindoHadoopSystem, String>> CACHE = new ConcurrentHashMap<CacheKey, Pair<JindoHadoopSystem, String>>();
    private Options hadoopOptions;
    private boolean allowCache = true;

    public boolean isObjectStore() {
        return true;
    }

    public void configure(CatalogContext context) {
        this.allowCache = (Boolean)context.options().get(CatalogOptions.FILE_IO_ALLOW_CACHE);
        this.hadoopOptions = new Options();
        this.hadoopOptions.set("fs.oss.impl", "com.aliyun.jindodata.oss.JindoOssFileSystem");
        this.hadoopOptions.set("fs.AbstractFileSystem.oss.impl", "com.aliyun.jindodata.oss.OSS");
        this.hadoopOptions.set("fs.oss.read.position.buffer.size", "8388608");
        this.hadoopOptions.set("fs.oss.credentials.provider", "com.aliyun.jindodata.oss.auth.SimpleCredentialsProvider");
        for (String key : context.options().keySet()) {
            for (String prefix : CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String value = context.options().get(key);
                if (CASE_SENSITIVE_KEYS.containsKey(key.toLowerCase())) {
                    key = CASE_SENSITIVE_KEYS.get(key.toLowerCase());
                }
                this.hadoopOptions.set(key, value);
                LOG.debug("Adding config entry for {} as {} to Hadoop config", (Object)key, (Object)this.hadoopOptions.get(key));
            }
        }
    }

    public Options hadoopOptions() {
        return this.hadoopOptions;
    }

    @Override
    protected Pair<JindoHadoopSystem, String> createFileSystem(Path path) {
        String scheme = path.toUri().getScheme();
        String authority = path.toUri().getAuthority();
        Supplier<Pair> supplier = () -> {
            JindoOssFileSystem fs;
            URI defaultUri;
            Configuration hadoopConf = new Configuration(false);
            this.hadoopOptions.toMap().forEach((arg_0, arg_1) -> ((Configuration)hadoopConf).set(arg_0, arg_1));
            URI fsUri = path.toUri();
            if (scheme == null && authority == null) {
                fsUri = FileSystem.getDefaultUri((Configuration)hadoopConf);
            } else if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri((Configuration)hadoopConf)).getScheme()) && defaultUri.getAuthority() != null) {
                fsUri = defaultUri;
            }
            if ("oss".equals(scheme)) {
                fs = new JindoOssFileSystem();
            } else if ("dls".equals(scheme)) {
                fs = new JindoDlsFileSystem();
            } else {
                throw new RuntimeException("Unsupported scheme for Jindo FileSystem: " + scheme);
            }
            try {
                fs.initialize(fsUri, hadoopConf);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return Pair.of((Object)fs, (Object)fs.getSysType(path).getSysType());
        };
        if (this.allowCache) {
            return CACHE.computeIfAbsent(new CacheKey(this.hadoopOptions, scheme, authority), key -> (Pair)supplier.get());
        }
        return supplier.get();
    }

    public void close() {
        if (!this.allowCache) {
            this.fsMap.values().stream().map(Pair::getKey).forEach(IOUtils::closeQuietly);
            this.fsMap.clear();
        }
    }

    private static class CacheKey {
        private final Options options;
        private final String scheme;
        private final String authority;

        private CacheKey(Options options, String scheme, String authority) {
            this.options = options;
            this.scheme = scheme;
            this.authority = authority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.options, cacheKey.options) && Objects.equals(this.scheme, cacheKey.scheme) && Objects.equals(this.authority, cacheKey.authority);
        }

        public int hashCode() {
            return Objects.hash(this.options, this.scheme, this.authority);
        }
    }
}

