/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jindo;

import com.aliyun.jindodata.common.JindoHadoopSystem;
import com.aliyun.jindodata.types.JindoHadoopFileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.fs.VectoredReadable;
import org.apache.paimon.utils.Pair;

public abstract class HadoopCompliantFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    protected volatile transient Map<String, Pair<JindoHadoopSystem, String>> fsMap;

    public SeekableInputStream newInputStream(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        Pair<JindoHadoopSystem, String> pair = this.getFileSystemPair(hadoopPath);
        JindoHadoopSystem fs = (JindoHadoopSystem)pair.getKey();
        String sysType = (String)pair.getValue();
        FSDataInputStream fsInput = fs.open(hadoopPath);
        return "jobj".equalsIgnoreCase(sysType) ? new VectoredReadableInputStream(fsInput) : new HadoopSeekableInputStream(fsInput);
    }

    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return new HadoopPositionOutputStream(this.getFileSystem(hadoopPath).create(hadoopPath, overwrite));
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return new HadoopFileStatus(this.getFileSystem(hadoopPath).getFileStatus(hadoopPath));
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        FileStatus[] statuses = new FileStatus[]{};
        JindoHadoopFileStatus[] hadoopStatuses = this.getFileSystem(hadoopPath).listStatus(hadoopPath);
        if (hadoopStatuses != null) {
            statuses = new FileStatus[hadoopStatuses.length];
            for (int i = 0; i < hadoopStatuses.length; ++i) {
                statuses[i] = new HadoopFileStatus((org.apache.hadoop.fs.FileStatus)hadoopStatuses[i]);
            }
        }
        return statuses;
    }

    public boolean exists(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return this.getFileSystem(hadoopPath).exists(hadoopPath);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return this.getFileSystem(hadoopPath).delete(hadoopPath, recursive);
    }

    public boolean mkdirs(Path path) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = this.path(path);
        return this.getFileSystem(hadoopPath).mkdirs(hadoopPath);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        org.apache.hadoop.fs.Path hadoopSrc = this.path(src);
        org.apache.hadoop.fs.Path hadoopDst = this.path(dst);
        return this.getFileSystem(hadoopSrc).rename(hadoopSrc, hadoopDst);
    }

    protected org.apache.hadoop.fs.Path path(Path path) {
        URI uri = path.toUri();
        if (uri.getScheme().equals("oss") && uri.getUserInfo() != null) {
            path = new Path("oss:/" + uri.getPath());
        }
        return new org.apache.hadoop.fs.Path(path.toUri());
    }

    protected JindoHadoopSystem getFileSystem(org.apache.hadoop.fs.Path path) throws IOException {
        return (JindoHadoopSystem)this.getFileSystemPair(path).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<JindoHadoopSystem, String> getFileSystemPair(org.apache.hadoop.fs.Path path) throws IOException {
        if (this.fsMap == null) {
            HadoopCompliantFileIO hadoopCompliantFileIO = this;
            synchronized (hadoopCompliantFileIO) {
                if (this.fsMap == null) {
                    this.fsMap = new ConcurrentHashMap<String, Pair<JindoHadoopSystem, String>>();
                }
            }
        }
        Map<String, Pair<JindoHadoopSystem, String>> map = this.fsMap;
        String authority = path.toUri().getAuthority();
        if (authority == null) {
            authority = "DEFAULT";
        }
        try {
            return map.computeIfAbsent(authority, k -> {
                try {
                    return this.createFileSystem(path);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    protected abstract Pair<JindoHadoopSystem, String> createFileSystem(org.apache.hadoop.fs.Path var1) throws IOException;

    private static class HadoopFileStatus
    implements FileStatus {
        private final org.apache.hadoop.fs.FileStatus status;

        private HadoopFileStatus(org.apache.hadoop.fs.FileStatus status) {
            this.status = status;
        }

        public long getLen() {
            return this.status.getLen();
        }

        public boolean isDir() {
            return this.status.isDirectory();
        }

        public Path getPath() {
            return new Path(this.status.getPath().toUri());
        }

        public long getModificationTime() {
            return this.status.getModificationTime();
        }
    }

    private static class HadoopPositionOutputStream
    extends PositionOutputStream {
        private final FSDataOutputStream out;

        private HadoopPositionOutputStream(FSDataOutputStream out) {
            this.out = out;
        }

        public long getPos() throws IOException {
            return this.out.getPos();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.out.hflush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class VectoredReadableInputStream
    extends HadoopSeekableInputStream
    implements VectoredReadable {
        private VectoredReadableInputStream(FSDataInputStream in) {
            super(in);
        }

        public int pread(long position, byte[] bytes, int off, int len) throws IOException {
            return this.in.read(position, bytes, off, len);
        }
    }

    private static class HadoopSeekableInputStream
    extends SeekableInputStream {
        private static final int MIN_SKIP_BYTES = 0x100000;
        protected final FSDataInputStream in;

        private HadoopSeekableInputStream(FSDataInputStream in) {
            this.in = in;
        }

        public void seek(long seekPos) throws IOException {
            long delta = seekPos - this.getPos();
            if (delta > 0L && delta <= 0x100000L) {
                this.skipFully(delta);
            } else if (delta != 0L) {
                this.forceSeek(seekPos);
            }
        }

        public long getPos() throws IOException {
            return this.in.getPos();
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void forceSeek(long seekPos) throws IOException {
            this.in.seek(seekPos);
        }

        public void skipFully(long bytes) throws IOException {
            while (bytes > 0L) {
                bytes -= this.in.skip(bytes);
            }
        }
    }
}

