/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.types.RowKind;

public class RowKindFilter {
    private final boolean ignoreAllRetracts;
    private final boolean ignoreUpdateBefore;

    public RowKindFilter(boolean ignoreAllRetracts, boolean ignoreUpdateBefore) {
        this.ignoreAllRetracts = ignoreAllRetracts;
        this.ignoreUpdateBefore = ignoreUpdateBefore;
    }

    @Nullable
    public static RowKindFilter of(CoreOptions options) {
        boolean ignoreAllRetracts = options.ignoreDelete();
        boolean ignoreUpdateBefore = options.ignoreUpdateBefore();
        if (!ignoreAllRetracts && !ignoreUpdateBefore) {
            return null;
        }
        return new RowKindFilter(ignoreAllRetracts, ignoreUpdateBefore);
    }

    public boolean test(RowKind rowKind) {
        switch (rowKind) {
            case DELETE: {
                if (!this.ignoreAllRetracts) break;
                return false;
            }
            case UPDATE_BEFORE: {
                if (!this.ignoreUpdateBefore && !this.ignoreAllRetracts) break;
                return false;
            }
        }
        return true;
    }
}

