/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.aggregate;

import java.io.Serializable;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.spark.aggregate.LocalAggregator;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.PushDownUtils;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.execution.datasources.v2.V2ColumnUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class AggregatePushDownUtils$ {
    public static AggregatePushDownUtils$ MODULE$;

    static {
        new AggregatePushDownUtils$();
    }

    public Option<LocalAggregator> tryPushdownAggregation(FileStoreTable table, Aggregation aggregation, ReadBuilder readBuilder) {
        Option option;
        Object object = new Object();
        try {
            Seq<DataSplit> seq;
            CoreOptions options = table.coreOptions();
            RowType rowType = table.rowType();
            List<String> partitionKeys = table.partitionKeys();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions())).map((Function1 & Serializable & scala.Serializable)expr -> V2ColumnUtils$.MODULE$.extractV2Column(expr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class))))).foreach((Function1 & Serializable & scala.Serializable)colName -> {
                AggregatePushDownUtils$.$anonfun$tryPushdownAggregation$2(partitionKeys, object, colName);
                return BoxedUnit.UNIT;
            });
            Option<scala.collection.immutable.Set<String>> option2 = this.extractMinMaxColumns(rowType, aggregation);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                scala.collection.immutable.Set columns = (scala.collection.immutable.Set)some.value();
                if (columns.isEmpty()) {
                    seq = this.generateSplits(readBuilder.dropStats());
                } else {
                    if (options.deletionVectorsEnabled() || !table.primaryKeys().isEmpty()) {
                        return None$.MODULE$;
                    }
                    Seq<DataSplit> splits = this.generateSplits(readBuilder);
                    if (!splits.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AggregatePushDownUtils$.$anonfun$tryPushdownAggregation$3(columns, x$1)))) {
                        return None$.MODULE$;
                    }
                    seq = splits;
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    return None$.MODULE$;
                }
                throw new MatchError(option2);
            }
            Seq<DataSplit> splits = seq;
            if (!splits.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.mergedRowCountAvailable()))) {
                return None$.MODULE$;
            }
            LocalAggregator aggregator = new LocalAggregator(table);
            aggregator.initialize(aggregation);
            splits.foreach((Function1 & Serializable & scala.Serializable)dataSplit -> {
                aggregator.update(dataSplit);
                return BoxedUnit.UNIT;
            });
            option = Option$.MODULE$.apply((Object)aggregator);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Seq<DataSplit> generateSplits(ReadBuilder readBuilder) {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(readBuilder.newScan().plan().splits()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (DataSplit)x$3, Buffer$.MODULE$.canBuildFrom());
    }

    private Option<scala.collection.immutable.Set<String>> extractMinMaxColumns(RowType rowType, Aggregation aggregation) {
        Option option;
        Object object = new Object();
        try {
            HashSet columns = HashSet$.MODULE$.empty();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AggregateFunc aggregateFunc = x0$1;
                if (aggregateFunc instanceof Min || aggregateFunc instanceof Max) {
                    Option<String> option = MODULE$.extractMinMaxColumn(rowType, (Expression)aggregateFunc);
                    if (!(option instanceof Some)) {
                        if (None$.MODULE$.equals(option)) {
                            throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                        }
                        throw new MatchError(option);
                    }
                    Some some = (Some)option;
                    String colName = (String)some.value();
                    return BoxesRunTime.boxToBoolean((boolean)columns.add((Object)colName));
                }
                if (aggregateFunc instanceof CountStar) {
                    return BoxedUnit.UNIT;
                }
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            option = Option$.MODULE$.apply((Object)columns.toSet());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<String> extractMinMaxColumn(RowType rowType, Expression minOrMax) {
        Expression expression;
        Expression expression2 = minOrMax;
        if (expression2 instanceof Min) {
            Min min = (Min)expression2;
            expression = min.column();
        } else if (expression2 instanceof Max) {
            Max max = (Max)expression2;
            expression = max.column();
        } else {
            throw new MatchError((Object)expression2);
        }
        Expression column = expression;
        Option extractColumn = V2ColumnUtils$.MODULE$.extractV2Column(column);
        if (extractColumn.isEmpty()) {
            return None$.MODULE$;
        }
        String columnName = (String)extractColumn.get();
        DataType dataType = rowType.getField(columnName).type();
        if (PushDownUtils.minmaxAvailable(dataType)) {
            return Option$.MODULE$.apply((Object)columnName);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$tryPushdownAggregation$2(List partitionKeys$1, Object nonLocalReturnKey1$1, Option colName) {
        if (colName.isEmpty() || !partitionKeys$1.contains(colName.get())) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)None$.MODULE$);
        }
    }

    public static final /* synthetic */ boolean $anonfun$tryPushdownAggregation$3(scala.collection.immutable.Set columns$1, DataSplit x$1) {
        return PushDownUtils.minmaxAvailable(x$1, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)columns$1).asJava());
    }

    private AggregatePushDownUtils$() {
        MODULE$ = this;
    }
}

