/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.paimon.shade.org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MapNonNativeWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MapWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MapWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Util;

final class MapNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private static final int id = 48;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final byte typeId;

    MapNonNativeWritableMemoryImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.typeId = (byte)(0x30 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = MapNonNativeWritableMemoryImpl.setReadOnlyType(this.typeId, readOnly) | 2;
        return Util.isNativeByteOrder(byteOrder) ? new MapWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid) : new MapNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        byte type = MapNonNativeWritableMemoryImpl.setReadOnlyType(this.typeId, readOnly);
        return Util.isNativeByteOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        return null;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

