/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.ApplyDeletionVectorReader;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.bitmap.ApplyBitmapIndexRecordReader;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.DataFileRecordReader;
import org.apache.paimon.io.FileIndexEvaluator;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.reader.EmptyFileRecordReader;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.reader.ReaderSupplier;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.FormatReaderMapping;
import org.apache.paimon.utils.IOExceptionSupplier;
import org.apache.paimon.utils.RoaringBitmap32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileSplitRead
implements SplitRead<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(RawFileSplitRead.class);
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    private final FileFormatDiscover formatDiscover;
    private final FileStorePathFactory pathFactory;
    private final Map<FormatKey, FormatReaderMapping> formatReaderMappings;
    private final boolean fileIndexReadEnabled;
    private final boolean rowTrackingEnabled;
    private RowType readRowType;
    @Nullable
    private List<Predicate> filters;
    @Nullable
    private TopN topN;
    @Nullable
    private Integer limit;

    public RawFileSplitRead(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType rowType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, boolean fileIndexReadEnabled, boolean rowTrackingEnabled) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.formatDiscover = formatDiscover;
        this.pathFactory = pathFactory;
        this.formatReaderMappings = new HashMap<FormatKey, FormatReaderMapping>();
        this.fileIndexReadEnabled = fileIndexReadEnabled;
        this.rowTrackingEnabled = rowTrackingEnabled;
        this.readRowType = rowType;
    }

    @Override
    public SplitRead<InternalRow> forceKeepDelete() {
        return this;
    }

    @Override
    public SplitRead<InternalRow> withIOManager(@Nullable IOManager ioManager) {
        return this;
    }

    @Override
    public SplitRead<InternalRow> withReadType(RowType readRowType) {
        this.readRowType = readRowType;
        return this;
    }

    public RawFileSplitRead withFilter(Predicate predicate) {
        if (predicate != null) {
            this.filters = PredicateBuilder.splitAnd(predicate);
        }
        return this;
    }

    @Override
    public SplitRead<InternalRow> withTopN(@Nullable TopN topN) {
        this.topN = topN;
        return this;
    }

    @Override
    public SplitRead<InternalRow> withLimit(@Nullable Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        if (!split.beforeFiles().isEmpty()) {
            LOG.info("Ignore split before files: {}", split.beforeFiles());
        }
        List<DataFileMeta> files = split.dataFiles();
        DeletionVector.Factory dvFactory = DeletionVector.factory(this.fileIO, files, split.deletionFiles().orElse(null));
        HashMap<String, IOExceptionSupplier<DeletionVector>> dvFactories = new HashMap<String, IOExceptionSupplier<DeletionVector>>();
        for (DataFileMeta file : files) {
            dvFactories.put(file.fileName(), () -> dvFactory.create(file.fileName()).orElse(null));
        }
        return this.createReader(split.partition(), split.bucket(), split.dataFiles(), dvFactories);
    }

    public RecordReader<InternalRow> createReader(BinaryRow partition, int bucket, List<DataFileMeta> files, @Nullable Map<String, IOExceptionSupplier<DeletionVector>> dvFactories) throws IOException {
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(partition, bucket);
        ArrayList<ReaderSupplier<InternalRow>> suppliers = new ArrayList<ReaderSupplier<InternalRow>>();
        FormatReaderMapping.Builder formatReaderMappingBuilder = new FormatReaderMapping.Builder(this.formatDiscover, this.readRowType.getFields(), schema -> {
            if (this.rowTrackingEnabled) {
                return SpecialFields.rowTypeWithRowTracking(schema.logicalRowType(), true).getFields();
            }
            return schema.fields();
        }, this.filters, this.topN, this.limit);
        for (DataFileMeta file : files) {
            suppliers.add(this.createFileReader(partition, dataFilePathFactory, file, formatReaderMappingBuilder, dvFactories));
        }
        return ConcatRecordReader.create(suppliers);
    }

    private ReaderSupplier<InternalRow> createFileReader(BinaryRow partition, DataFilePathFactory dataFilePathFactory, DataFileMeta file, FormatReaderMapping.Builder formatBuilder, @Nullable Map<String, IOExceptionSupplier<DeletionVector>> dvFactories) {
        String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
        long schemaId = file.schemaId();
        FormatReaderMapping formatReaderMapping = this.formatReaderMappings.computeIfAbsent(new FormatKey(file.schemaId(), formatIdentifier), key -> formatBuilder.build(formatIdentifier, this.schema, schemaId == this.schema.id() ? this.schema : this.schemaManager.schema(schemaId)));
        IOExceptionSupplier<DeletionVector> dvFactory = dvFactories == null ? null : dvFactories.get(file.fileName());
        return () -> this.createFileReader(partition, file, dataFilePathFactory, formatReaderMapping, dvFactory);
    }

    private FileRecordReader<InternalRow> createFileReader(BinaryRow partition, DataFileMeta file, DataFilePathFactory dataFilePathFactory, FormatReaderMapping formatReaderMapping, IOExceptionSupplier<DeletionVector> dvFactory) throws IOException {
        DeletionVector deletionVector;
        FileIndexResult fileIndexResult = null;
        DeletionVector deletionVector2 = deletionVector = dvFactory == null ? null : dvFactory.get();
        if (this.fileIndexReadEnabled && !(fileIndexResult = FileIndexEvaluator.evaluate(this.fileIO, formatReaderMapping.getDataSchema(), formatReaderMapping.getDataFilters(), formatReaderMapping.getTopN(), formatReaderMapping.getLimit(), dataFilePathFactory, file, deletionVector)).remain()) {
            return new EmptyFileRecordReader<InternalRow>();
        }
        RoaringBitmap32 selection = null;
        if (fileIndexResult instanceof BitmapIndexResult) {
            selection = (RoaringBitmap32)((BitmapIndexResult)fileIndexResult).get();
        }
        FormatReaderContext formatReaderContext = new FormatReaderContext(this.fileIO, dataFilePathFactory.toPath(file), file.fileSize(), selection);
        FileRecordReader<InternalRow> fileRecordReader = new DataFileRecordReader(this.schema.logicalRowType(), formatReaderMapping.getReaderFactory(), formatReaderContext, formatReaderMapping.getIndexMapping(), formatReaderMapping.getCastMapping(), PartitionUtils.create(formatReaderMapping.getPartitionPair(), partition), this.rowTrackingEnabled, file.firstRowId(), file.maxSequenceNumber(), formatReaderMapping.getSystemFields());
        if (fileIndexResult instanceof BitmapIndexResult) {
            fileRecordReader = new ApplyBitmapIndexRecordReader(fileRecordReader, (BitmapIndexResult)fileIndexResult);
        }
        if (deletionVector != null && !deletionVector.isEmpty()) {
            return new ApplyDeletionVectorReader(fileRecordReader, deletionVector);
        }
        return fileRecordReader;
    }
}

