/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;

public class SimpleFileEntry
implements FileEntry {
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final int totalBuckets;
    private final int level;
    private final String fileName;
    private final List<String> extraFiles;
    @Nullable
    private final byte[] embeddedIndex;
    private final BinaryRow minKey;
    private final BinaryRow maxKey;
    @Nullable
    private final String externalPath;

    public SimpleFileEntry(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, int level, String fileName, List<String> extraFiles, @Nullable byte[] embeddedIndex, BinaryRow minKey, BinaryRow maxKey, @Nullable String externalPath) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.totalBuckets = totalBuckets;
        this.level = level;
        this.fileName = fileName;
        this.extraFiles = extraFiles;
        this.embeddedIndex = embeddedIndex;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.externalPath = externalPath;
    }

    public static SimpleFileEntry from(ManifestEntry entry) {
        return new SimpleFileEntry(entry.kind(), entry.partition(), entry.bucket(), entry.totalBuckets(), entry.level(), entry.fileName(), entry.file().extraFiles(), entry.file().embeddedIndex(), entry.minKey(), entry.maxKey(), entry.externalPath());
    }

    public SimpleFileEntry toDelete() {
        return new SimpleFileEntry(FileKind.DELETE, this.partition, this.bucket, this.totalBuckets, this.level, this.fileName, this.extraFiles, this.embeddedIndex, this.minKey, this.maxKey, this.externalPath);
    }

    public static List<SimpleFileEntry> from(List<ManifestEntry> entries) {
        return entries.stream().map(SimpleFileEntry::from).collect(Collectors.toList());
    }

    @Override
    public FileKind kind() {
        return this.kind;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    @Override
    public int totalBuckets() {
        return this.totalBuckets;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Nullable
    public byte[] embeddedIndex() {
        return this.embeddedIndex;
    }

    @Override
    @Nullable
    public String externalPath() {
        return this.externalPath;
    }

    @Override
    public FileEntry.Identifier identifier() {
        return new FileEntry.Identifier(this.partition, this.bucket, this.level, this.fileName, this.extraFiles, this.embeddedIndex, this.externalPath);
    }

    @Override
    public BinaryRow minKey() {
        return this.minKey;
    }

    @Override
    public BinaryRow maxKey() {
        return this.maxKey;
    }

    @Override
    public List<String> extraFiles() {
        return this.extraFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFileEntry that = (SimpleFileEntry)o;
        return this.bucket == that.bucket && this.totalBuckets == that.totalBuckets && this.level == that.level && this.kind == that.kind && Objects.equals(this.partition, that.partition) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.extraFiles, that.extraFiles) && Objects.equals(this.minKey, that.minKey) && Objects.equals(this.maxKey, that.maxKey) && Objects.equals(this.externalPath, that.externalPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.level, this.fileName, this.extraFiles, this.minKey, this.maxKey, this.externalPath});
    }

    public String toString() {
        return "{kind=" + (Object)((Object)this.kind) + ", partition=" + this.partition + ", bucket=" + this.bucket + ", totalBuckets=" + this.totalBuckets + ", level=" + this.level + ", fileName=" + this.fileName + ", extraFiles=" + this.extraFiles + ", minKey=" + this.minKey + ", maxKey=" + this.maxKey + ", externalPath=" + this.externalPath + '}';
    }
}

