/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.csv;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.csv.CsvFileReader;
import org.apache.paimon.format.csv.CsvFormatWriter;
import org.apache.paimon.format.csv.CsvOptions;
import org.apache.paimon.fs.CloseShieldOutputStream;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.RowType;

public class CsvFileFormat
extends FileFormat {
    public static final String CSV_IDENTIFIER = "csv";
    private final CsvOptions options;

    public CsvFileFormat(FileFormatFactory.FormatContext context) {
        super(CSV_IDENTIFIER);
        this.options = new CsvOptions(context.options());
    }

    @Override
    public FormatReaderFactory createReaderFactory(RowType dataSchemaRowType, RowType projectedRowType, @Nullable List<Predicate> filters) {
        return new CsvReaderFactory(dataSchemaRowType, projectedRowType, this.options);
    }

    @Override
    public FormatWriterFactory createWriterFactory(RowType type) {
        return new CsvWriterFactory(type, this.options);
    }

    @Override
    public void validateDataFields(RowType rowType) {
        List<DataType> fieldTypes = rowType.getFieldTypes();
        for (DataType dataType : fieldTypes) {
            this.validateDataType(dataType);
        }
    }

    private void validateDataType(DataType dataType) {
        DataTypeRoot typeRoot = dataType.getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case BINARY: 
            case VARBINARY: 
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type for CSV format: " + dataType);
            }
        }
    }

    private static class CsvWriterFactory
    implements FormatWriterFactory {
        private final RowType rowType;
        private final CsvOptions options;

        public CsvWriterFactory(RowType rowType, CsvOptions options) {
            this.rowType = rowType;
            this.options = options;
        }

        @Override
        public FormatWriter create(PositionOutputStream out, String compression) throws IOException {
            return new CsvFormatWriter(new CloseShieldOutputStream(out), this.rowType, this.options, compression);
        }
    }

    private static class CsvReaderFactory
    implements FormatReaderFactory {
        private final RowType dataSchemaRowType;
        private final RowType projectedRowType;
        private final CsvOptions options;

        public CsvReaderFactory(RowType dataSchemaRowType, RowType projectedRowType, CsvOptions options) {
            this.dataSchemaRowType = dataSchemaRowType;
            this.projectedRowType = projectedRowType;
            this.options = options;
        }

        @Override
        public FileRecordReader<InternalRow> createReader(FormatReaderFactory.Context context) throws IOException {
            return new CsvFileReader(context.fileIO(), context.filePath(), this.dataSchemaRowType, this.projectedRowType, this.options);
        }
    }
}

