/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public class PartitionInfo {
    private final int[] map;
    private final RowType partitionType;
    private final BinaryRow partition;

    public PartitionInfo(int[] map, RowType partitionType, BinaryRow partition) {
        this.map = map;
        this.partitionType = partitionType;
        this.partition = partition;
    }

    public int[] getMap() {
        return this.map;
    }

    public BinaryRow getPartitionRow() {
        return this.partition;
    }

    public boolean inPartitionRow(int i) {
        return this.map[i] < 0;
    }

    public int getRealIndex(int i) {
        return Math.abs(this.map[i]) - 1;
    }

    public DataType getType(int i) {
        return this.partitionType.getTypeAt(this.getRealIndex(i));
    }

    public int size() {
        return this.map.length - 1;
    }
}

