/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class CastedRow
implements InternalRow {
    private final CastFieldGetter[] castMapping;
    private InternalRow row;

    protected CastedRow(CastFieldGetter[] castMapping) {
        this.castMapping = Preconditions.checkNotNull(castMapping);
    }

    public CastedRow replaceRow(InternalRow row) {
        this.row = row;
        return this;
    }

    @Override
    public int getFieldCount() {
        return this.row.getFieldCount();
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return (Boolean)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public byte getByte(int pos) {
        return (Byte)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public short getShort(int pos) {
        return (Short)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public int getInt(int pos) {
        return (Integer)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public long getLong(int pos) {
        return (Long)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public float getFloat(int pos) {
        return ((Float)this.castMapping[pos].getFieldOrNull(this.row)).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return (Double)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public BinaryString getString(int pos) {
        return (BinaryString)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return (Decimal)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return (Timestamp)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public Variant getVariant(int pos) {
        return (Variant)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public InternalArray getArray(int pos) {
        return (InternalArray)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public InternalMap getMap(int pos) {
        return (InternalMap)this.castMapping[pos].getFieldOrNull(this.row);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return (InternalRow)this.castMapping[pos].getFieldOrNull(this.row);
    }

    public static CastedRow from(CastFieldGetter[] castMapping) {
        return new CastedRow(castMapping);
    }
}

