/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.vfs.hadoop;

import java.io.IOException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.paimon.fs.SeekableInputStream;

public class VFSInputStream
extends FSInputStream {
    private SeekableInputStream in;
    private byte[] oneByteBuf = new byte[1];
    private FileSystem.Statistics statistics;

    public VFSInputStream(SeekableInputStream in, FileSystem.Statistics statistics) {
        this.in = in;
        this.statistics = statistics;
    }

    public void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public long getPos() throws IOException {
        return this.in.getPos();
    }

    public boolean seekToNewSource(long var1) throws IOException {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int byteRead = this.in.read(b, off, len);
        if (this.statistics != null && byteRead >= 0) {
            this.statistics.incrementBytesRead((long)byteRead);
        }
        return byteRead;
    }

    public int read() throws IOException {
        int n;
        while ((n = this.read(this.oneByteBuf, 0, 1)) == 0) {
        }
        if (this.statistics != null && n >= 0) {
            this.statistics.incrementBytesRead((long)n);
        }
        return n == -1 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

