/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.vfs.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.responses.GetDatabaseResponse;
import org.apache.paimon.vfs.VFSCatalogIdentifier;
import org.apache.paimon.vfs.VFSDatabaseIdentifier;
import org.apache.paimon.vfs.VFSIdentifier;
import org.apache.paimon.vfs.VFSOperations;
import org.apache.paimon.vfs.VFSTableIdentifier;
import org.apache.paimon.vfs.VFSTableInfo;
import org.apache.paimon.vfs.VFSTableObjectIdentifier;
import org.apache.paimon.vfs.VFSTableRootIdentifier;
import org.apache.paimon.vfs.hadoop.PaimonVirtualFileSystemConfiguration;
import org.apache.paimon.vfs.hadoop.VFSInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonVirtualFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(PaimonVirtualFileSystem.class);
    private Path workingDirectory;
    private URI uri;
    private VFSOperations vfsOperations;
    private Configuration conf;
    private static final String USER_AGENT = "HadoopPVFS";
    private static final long DEFAULT_BLOCK_SIZE = 0x8000000L;

    public void initialize(URI uri, Configuration conf) throws IOException {
        this.setConf(conf);
        this.conf = conf;
        super.initialize(uri, conf);
        this.workingDirectory = new Path(uri);
        if (uri.getAuthority() == null || uri.getAuthority().isEmpty()) {
            throw new IllegalArgumentException("URI authority is empty: " + uri);
        }
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority() + "/");
        this.initVFSOperations();
    }

    private void initVFSOperations() {
        Options options = PaimonVirtualFileSystemConfiguration.convertToCatalogOptions(this.conf);
        String authority = this.uri.getAuthority();
        int delimiterIndex = authority.indexOf(".");
        if (delimiterIndex == 0 || delimiterIndex == authority.length() - 1) {
            throw new IllegalArgumentException("Invalid URI authority: " + this.uri);
        }
        if (delimiterIndex < 0) {
            options.set(CatalogOptions.WAREHOUSE, (Object)authority);
        } else {
            String catalogName = authority.substring(0, delimiterIndex);
            String endpoint = authority.substring(delimiterIndex + 1);
            options.set(CatalogOptions.WAREHOUSE, (Object)catalogName);
            options.set(RESTCatalogOptions.URI, (Object)endpoint);
        }
        options.set(RESTCatalogOptions.HTTP_USER_AGENT, (Object)USER_AGENT);
        this.vfsOperations = new VFSOperations(options);
    }

    private String getVirtualPath(Path path) {
        Path qualifiedPath = path.makeQualified(this.uri, this.workingDirectory);
        return qualifiedPath.toUri().getPath();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        VFSIdentifier vfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(f));
        if (vfsIdentifier instanceof VFSCatalogIdentifier) {
            throw new IOException("Cannot create file for virtual path " + f + " which is a catalog");
        }
        if (vfsIdentifier instanceof VFSDatabaseIdentifier) {
            throw new IOException("Cannot create file for virtual path " + f + " which is a database");
        }
        if (vfsIdentifier instanceof VFSTableRootIdentifier) {
            throw new IOException("Cannot create file for table level virtual path " + f + " which is a table");
        }
        VFSTableObjectIdentifier identifier = (VFSTableObjectIdentifier)vfsIdentifier;
        if (identifier.tableInfo() == null) {
            this.vfsOperations.createObjectTable(identifier.databaseName(), identifier.tableName());
            identifier = (VFSTableObjectIdentifier)this.vfsOperations.getVFSIdentifier(this.getVirtualPath(f));
        }
        PositionOutputStream out = identifier.tableInfo().fileIO().newOutputStream(identifier.filePath(), overwrite);
        return new FSDataOutputStream((OutputStream)out, this.statistics);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        VFSIdentifier vfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(path));
        if (vfsIdentifier instanceof VFSCatalogIdentifier) {
            throw new FileNotFoundException("Cannot open file for virtual path " + path + " which is a catalog");
        }
        if (vfsIdentifier instanceof VFSDatabaseIdentifier) {
            throw new FileNotFoundException("Cannot open file for virtual path " + path + " which is a database");
        }
        if (vfsIdentifier instanceof VFSTableRootIdentifier) {
            throw new FileNotFoundException("Cannot open file for virtual path " + path + " which is a table");
        }
        VFSTableObjectIdentifier identifier = (VFSTableObjectIdentifier)vfsIdentifier;
        VFSTableInfo tableInfo = identifier.tableInfo();
        if (tableInfo == null) {
            throw new IOException("Cannot open file for virtual path " + path + " which is not in an existing table");
        }
        VFSInputStream in = new VFSInputStream(tableInfo.fileIO().newInputStream(identifier.filePath()), this.statistics);
        return new FSDataInputStream((InputStream)((Object)in));
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Append is not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        VFSIdentifier srcVfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(src));
        VFSIdentifier dstVfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(dst));
        if (srcVfsIdentifier instanceof VFSCatalogIdentifier) {
            LOG.debug("Rename root path is ignored");
            return false;
        }
        if (srcVfsIdentifier instanceof VFSDatabaseIdentifier) {
            throw new IOException("Cannot rename from virtual path " + src + " which is a database");
        }
        if (srcVfsIdentifier instanceof VFSTableRootIdentifier) {
            if (!(dstVfsIdentifier instanceof VFSTableRootIdentifier)) {
                throw new IOException("Cannot rename from table path " + src + " to non-table path " + dst);
            }
            return this.renameTable((VFSTableRootIdentifier)srcVfsIdentifier, (VFSTableRootIdentifier)dstVfsIdentifier);
        }
        if (!(dstVfsIdentifier instanceof VFSTableIdentifier)) {
            throw new IOException("Cannot rename to virtual path " + dst + " which is not a table");
        }
        VFSTableObjectIdentifier srcIdentifier = (VFSTableObjectIdentifier)srcVfsIdentifier;
        VFSTableIdentifier dstIdentifier = (VFSTableIdentifier)dstVfsIdentifier;
        VFSTableInfo srcTableInfo = srcIdentifier.tableInfo();
        VFSTableInfo dstTableInfo = dstIdentifier.tableInfo();
        if (srcTableInfo == null) {
            throw new IOException("Cannot rename from virtual path " + src + " which is not in an existing table");
        }
        if (dstTableInfo == null) {
            throw new IOException("Cannot rename to virtual path " + dst + " which is not in an existing table");
        }
        if (!srcTableInfo.tableId().equals(dstTableInfo.tableId())) {
            throw new IOException("Cannot rename from virtual path " + src + " to virtual path " + dst + " which is not in the same table");
        }
        return srcTableInfo.fileIO().rename(srcIdentifier.filePath(), dstIdentifier.filePath());
    }

    private boolean renameTable(VFSTableRootIdentifier srcIdentifier, VFSTableRootIdentifier dstIdentifier) throws IOException {
        if (!srcIdentifier.databaseName().equals(dstIdentifier.databaseName())) {
            throw new IOException("Do not support rename table with different database");
        }
        if (srcIdentifier.tableInfo() == null) {
            LOG.debug("Source table not found {}.{}", (Object)srcIdentifier.databaseName(), (Object)srcIdentifier.tableName());
            return false;
        }
        if (srcIdentifier.tableName().equals(dstIdentifier.tableName())) {
            return true;
        }
        try {
            this.vfsOperations.renameTable(srcIdentifier.databaseName(), srcIdentifier.tableName(), dstIdentifier.tableName());
            return true;
        }
        catch (FileNotFoundException e) {
            LOG.debug("Source table not found {}.{}", (Object)srcIdentifier.databaseName(), (Object)srcIdentifier.tableName());
            return false;
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        VFSIdentifier vfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(f));
        if (vfsIdentifier instanceof VFSCatalogIdentifier) {
            throw new IOException("Cannot delete virtual path " + f + " which is a catalog");
        }
        if (vfsIdentifier instanceof VFSDatabaseIdentifier) {
            String databaseName = ((VFSDatabaseIdentifier)vfsIdentifier).databaseName();
            try {
                this.vfsOperations.dropDatabase(databaseName, recursive);
            }
            catch (FileNotFoundException e) {
                LOG.debug("Database not found for deleting path " + f);
                return false;
            }
            return true;
        }
        if (vfsIdentifier instanceof VFSTableRootIdentifier) {
            VFSTableRootIdentifier vfsTableRootIdentifier = (VFSTableRootIdentifier)vfsIdentifier;
            try {
                this.vfsOperations.dropTable(vfsTableRootIdentifier.databaseName(), vfsTableRootIdentifier.tableName());
            }
            catch (FileNotFoundException e) {
                LOG.debug("Table not found for deleting path " + f);
                return false;
            }
            return true;
        }
        VFSTableObjectIdentifier identifier = (VFSTableObjectIdentifier)vfsIdentifier;
        VFSTableInfo tableInfo = identifier.tableInfo();
        if (tableInfo == null) {
            throw new IOException("Cannot delete virtual path " + f + " which is not in an existing table");
        }
        return tableInfo.fileIO().delete(identifier.filePath(), recursive);
    }

    public org.apache.hadoop.fs.FileStatus getFileStatus(Path f) throws IOException {
        VFSIdentifier vfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(f));
        if (vfsIdentifier instanceof VFSCatalogIdentifier) {
            return new org.apache.hadoop.fs.FileStatus(0L, true, 1, 0L, 0L, new Path(this.uri));
        }
        if (vfsIdentifier instanceof VFSDatabaseIdentifier) {
            String databaseName = ((VFSDatabaseIdentifier)vfsIdentifier).databaseName();
            GetDatabaseResponse database = this.vfsOperations.getDatabase(databaseName);
            return this.convertDatabase(database);
        }
        VFSTableIdentifier identifier = (VFSTableIdentifier)vfsIdentifier;
        VFSTableInfo tableInfo = identifier.tableInfo();
        if (tableInfo == null) {
            throw new FileNotFoundException("Table not found for path " + f);
        }
        FileStatus fileStatus = tableInfo.fileIO().getFileStatus(identifier.filePath());
        return this.convertFileStatus(identifier.databaseName(), identifier.tableName(), tableInfo, fileStatus);
    }

    private org.apache.hadoop.fs.FileStatus convertDatabase(GetDatabaseResponse database) {
        return new org.apache.hadoop.fs.FileStatus(0L, true, 1, 0L, 0L, new Path(new Path(this.uri), database.getName()));
    }

    private org.apache.hadoop.fs.FileStatus convertFileStatus(String databaseName, String tableName, VFSTableInfo tableInfo, FileStatus fileStatus) throws IOException {
        String tablePath = tableInfo.tablePath().toString();
        String filePath = fileStatus.getPath().toString();
        if (!filePath.startsWith(tablePath)) {
            throw new IOException("Result path " + filePath + " does not start with table location " + tablePath);
        }
        String childPath = filePath.substring(tablePath.length());
        if (!childPath.startsWith("/")) {
            childPath = "/" + childPath;
        }
        Path virtualPath = new Path(new Path(this.uri), databaseName + "/" + tableName + childPath);
        long blockSize = fileStatus.isDir() ? 0L : 0x8000000L;
        return new org.apache.hadoop.fs.FileStatus(fileStatus.getLen(), fileStatus.isDir(), 1, blockSize, fileStatus.getModificationTime(), virtualPath);
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        VFSIdentifier vfsIdentifier = this.vfsOperations.getVFSIdentifier(this.getVirtualPath(f));
        if (vfsIdentifier instanceof VFSCatalogIdentifier) {
            List<String> databases = this.vfsOperations.listDatabases();
            return this.convertDatabases(databases);
        }
        if (vfsIdentifier instanceof VFSDatabaseIdentifier) {
            String databaseName = ((VFSDatabaseIdentifier)vfsIdentifier).databaseName();
            List<String> tables = this.vfsOperations.listTables(databaseName);
            return this.convertTables(databaseName, tables);
        }
        VFSTableIdentifier identifier = (VFSTableIdentifier)vfsIdentifier;
        VFSTableInfo tableInfo = identifier.tableInfo();
        if (tableInfo == null) {
            throw new FileNotFoundException("Table not found for path " + f);
        }
        FileStatus[] fileStatuses = tableInfo.fileIO().listStatus(identifier.filePath());
        return this.convertFileStatuses(identifier.databaseName(), identifier.tableName(), tableInfo, fileStatuses);
    }

    private org.apache.hadoop.fs.FileStatus[] convertDatabases(List<String> databases) {
        org.apache.hadoop.fs.FileStatus[] fileStatuses = new org.apache.hadoop.fs.FileStatus[databases.size()];
        for (int i = 0; i < databases.size(); ++i) {
            org.apache.hadoop.fs.FileStatus fileStatus;
            String database = databases.get(i);
            fileStatuses[i] = fileStatus = new org.apache.hadoop.fs.FileStatus(0L, true, 1, 0L, 0L, new Path(new Path(this.uri), database));
        }
        return fileStatuses;
    }

    private org.apache.hadoop.fs.FileStatus[] convertTables(String database, List<String> tables) {
        org.apache.hadoop.fs.FileStatus[] fileStatuses = new org.apache.hadoop.fs.FileStatus[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            org.apache.hadoop.fs.FileStatus fileStatus;
            String table = tables.get(i);
            fileStatuses[i] = fileStatus = new org.apache.hadoop.fs.FileStatus(0L, true, 1, 0L, 0L, new Path(new Path(this.uri), database + "/" + table));
        }
        return fileStatuses;
    }

    private org.apache.hadoop.fs.FileStatus[] convertFileStatuses(String databaseName, String tableName, VFSTableInfo tableInfo, FileStatus[] fileStatuses) throws IOException {
        org.apache.hadoop.fs.FileStatus[] virtualStatues = new org.apache.hadoop.fs.FileStatus[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            virtualStatues[i] = this.convertFileStatus(databaseName, tableName, tableInfo, fileStatuses[i]);
        }
        return virtualStatues;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        String virtualPath = this.getVirtualPath(f);
        for (String component : virtualPath.split("/")) {
            if (!component.equals(".Trash")) continue;
            LOG.info("PVFS do not support trash directory {}", (Object)f);
            return false;
        }
        VFSIdentifier vfsIdentifier = this.vfsOperations.getVFSIdentifier(virtualPath);
        if (vfsIdentifier instanceof VFSCatalogIdentifier) {
            throw new IOException("Cannot mkdirs for virtual path " + f + " which is a catalog");
        }
        if (vfsIdentifier instanceof VFSDatabaseIdentifier) {
            String databaseName = ((VFSDatabaseIdentifier)vfsIdentifier).databaseName();
            this.vfsOperations.createDatabase(databaseName);
            return true;
        }
        if (vfsIdentifier instanceof VFSTableRootIdentifier) {
            VFSTableRootIdentifier identifier = (VFSTableRootIdentifier)vfsIdentifier;
            if (identifier.tableInfo() != null) {
                return true;
            }
            this.vfsOperations.createObjectTable(identifier.databaseName(), identifier.tableName());
            return true;
        }
        VFSTableObjectIdentifier identifier = (VFSTableObjectIdentifier)vfsIdentifier;
        if (identifier.tableInfo() == null) {
            this.vfsOperations.createObjectTable(identifier.databaseName(), identifier.tableName());
            identifier = (VFSTableObjectIdentifier)this.vfsOperations.getVFSIdentifier(this.getVirtualPath(f));
        }
        return identifier.tableInfo().fileIO().mkdirs(identifier.filePath());
    }

    public String getScheme() {
        return "pvfs";
    }

    public URI getUri() {
        return this.uri;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDirectory = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @VisibleForTesting
    public boolean isCacheEnabled() {
        return this.vfsOperations.isCacheEnabled();
    }
}

