/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.write;

import java.io.Serializable;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.tag.TagBatchCreation;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.PartitionStatisticsReporter;
import org.apache.paimon.utils.TypeUtils;
import org.apache.spark.internal.Logging;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001I3q\u0001C\u0005\u0011\u0002\u0007\u0005A\u0003C\u0003#\u0001\u0011\u00051\u0005C\u0004(\u0001\t\u0007i\u0011\u0001\u0015\t\u00119\u0002\u0001R1A\u0005\u0002=BQ\u0001\u000e\u0001\u0005\u0002UBQA\u0013\u0001\u0005\n-CQ!\u0014\u0001\u0005\n\rBQA\u0014\u0001\u0005\n=\u00131b\u0016:ji\u0016DU\r\u001c9fe*\u0011!bC\u0001\u0006oJLG/\u001a\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\rA\f\u0017.\\8o\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\ta\u0002%D\u0001\u001e\u0015\tqr$\u0001\u0005j]R,'O\\1m\u0015\taq\"\u0003\u0002\";\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001%!\t1R%\u0003\u0002'/\t!QK\\5u\u0003\u0015!\u0018M\u00197f+\u0005I\u0003C\u0001\u0016-\u001b\u0005Y#BA\u0014\u000e\u0013\ti3F\u0001\bGS2,7\u000b^8sKR\u000b'\r\\3\u0002\u0017\r|'/Z(qi&|gn]\u000b\u0002aA\u0011\u0011GM\u0007\u0002\u001b%\u00111'\u0004\u0002\f\u0007>\u0014Xm\u00149uS>t7/\u0001\u0006q_N$8i\\7nSR$\"\u0001\n\u001c\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\u00115,7o]1hKN\u00042!O!E\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>'\u00051AH]8pizJ\u0011\u0001G\u0005\u0003\u0001^\tq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\n\u00191+Z9\u000b\u0005\u0001;\u0002CA#I\u001b\u00051%BA$,\u0003\u0011\u0019\u0018N\\6\n\u0005%3%!D\"p[6LG/T3tg\u0006<W-A\u0006sKB|'\u000f\u001e+p\u00116\u001cHC\u0001\u0013M\u0011\u00159T\u00011\u00019\u00039\u0011\u0017\r^2i\u0007J,\u0017\r^3UC\u001e\f\u0001#\\1sW\u0012{g.Z%g\u001d\u0016,G-\u001a3\u0015\u0005\u0011\u0002\u0006\"B)\b\u0001\u0004A\u0014AD2p[6LG/T3tg\u0006<Wm\u001d")
public interface WriteHelper
extends Logging {
    public FileStoreTable table();

    public static /* synthetic */ CoreOptions coreOptions$(WriteHelper $this) {
        return $this.coreOptions();
    }

    default public CoreOptions coreOptions() {
        return this.table().coreOptions();
    }

    public static /* synthetic */ void postCommit$(WriteHelper $this, Seq messages) {
        $this.postCommit((Seq<CommitMessage>)messages);
    }

    default public void postCommit(Seq<CommitMessage> messages) {
        if (messages.isEmpty()) {
            return;
        }
        this.reportToHms(messages);
        this.batchCreateTag();
        this.markDoneIfNeeded(messages);
    }

    private void reportToHms(Seq<CommitMessage> messages) {
        Options config = this.coreOptions().toConfiguration();
        if (config.get(CoreOptions.PARTITION_IDLE_TIME_TO_REPORT_STATISTIC).toMillis() <= 0L || this.table().partitionKeys().isEmpty() || !this.coreOptions().partitionedTableInMetastore() || this.table().catalogEnvironment().partitionHandler() == null) {
            return;
        }
        InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(this.coreOptions().partitionDefaultName(), this.table().schema().logicalPartitionType(), (String[])this.table().partitionKeys().toArray((Object[])new String[0]), this.coreOptions().legacyPartitionName());
        PartitionStatisticsReporter hmsReporter = new PartitionStatisticsReporter(this.table(), this.table().catalogEnvironment().partitionHandler());
        Seq partitions = (Seq)((SeqLike)messages.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.partition(), Seq$.MODULE$.canBuildFrom())).distinct();
        long currentTime = System.currentTimeMillis();
        try {
            try {
                partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    WriteHelper.$anonfun$reportToHms$2(partitionComputer, hmsReporter, currentTime, partition);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable e) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Failed to report to hms", e);
            }
        }
        finally {
            hmsReporter.close();
        }
    }

    private void batchCreateTag() {
        CoreOptions.TagCreationMode tagCreationMode = this.coreOptions().tagCreationMode();
        CoreOptions.TagCreationMode tagCreationMode2 = CoreOptions.TagCreationMode.BATCH;
        if (!(tagCreationMode != null ? !tagCreationMode.equals(tagCreationMode2) : tagCreationMode2 != null)) {
            TagBatchCreation tagCreation = new TagBatchCreation(this.table());
            tagCreation.createTag();
            return;
        }
    }

    private void markDoneIfNeeded(Seq<CommitMessage> commitMessages) {
        if (Predef$.MODULE$.Boolean2boolean(this.coreOptions().toConfiguration().get(CoreOptions.PARTITION_MARK_DONE_WHEN_END_INPUT))) {
            List<PartitionMarkDoneAction> actions = PartitionMarkDoneAction.createActions(this.getClass().getClassLoader(), this.table(), this.coreOptions());
            InternalRowPartitionComputer partitionComputer = new InternalRowPartitionComputer(this.coreOptions().partitionDefaultName(), TypeUtils.project(this.table().rowType(), this.table().partitionKeys()), (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.table().partitionKeys()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.coreOptions().legacyPartitionName());
            Seq partitions = (Seq)((TraversableLike)((SeqLike)commitMessages.map((Function1 & Serializable & scala.Serializable)c -> c.partition(), Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)p -> PartitionPathUtils.generatePartitionPath(partitionComputer.generatePartValues((InternalRow)p)), Seq$.MODULE$.canBuildFrom());
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                actions.forEach(a -> a.markDone(partition));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static /* synthetic */ void $anonfun$reportToHms$2(InternalRowPartitionComputer partitionComputer$1, PartitionStatisticsReporter hmsReporter$1, long currentTime$1, BinaryRow partition) {
        String partitionPath = PartitionPathUtils.generatePartitionPath(partitionComputer$1.generatePartValues(partition));
        hmsReporter$1.report(partitionPath, currentTime$1);
    }

    public static void $init$(WriteHelper $this) {
    }
}

