/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.Arrays;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.spark.procedure.SparkRemoveUnexistingFiles;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveUnexistingFilesProcedure
extends BaseProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveUnexistingFilesProcedure.class);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("dry_run", DataTypes.BooleanType), ProcedureParameter.optional("parallelism", DataTypes.IntegerType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("fileName", DataTypes.StringType, false, Metadata.empty())});

    private RemoveUnexistingFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String tableId = args.getString(0);
        Preconditions.checkArgument(tableId != null && !tableId.isEmpty(), "Cannot handle an empty tableId for argument %s", tableId);
        Identifier identifier = Identifier.fromString(this.toIdentifier(args.getString(0), PARAMETERS[0].name()).toString());
        LOG.info("identifier is {}.", (Object)identifier);
        String[] result = SparkRemoveUnexistingFiles.execute(((WithPaimonCatalog)this.tableCatalog()).paimonCatalog(), identifier.getDatabaseName(), identifier.getTableName(), !args.isNullAt(1) && args.getBoolean(1), args.isNullAt(2) ? null : Integer.valueOf(args.getInt(2)));
        return (InternalRow[])Arrays.stream(result).map(path -> this.newInternalRow(UTF8String.fromString((String)path))).toArray(InternalRow[]::new);
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RemoveUnexistingFilesProcedure>(){

            @Override
            public RemoveUnexistingFilesProcedure doBuild() {
                return new RemoveUnexistingFilesProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RemoveUnexistingFilesProcedure";
    }
}

