/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.time.Duration;
import java.util.Set;
import org.apache.paimon.Snapshot;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.SnapshotNotExistException;
import org.apache.paimon.utils.TimeUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class CreateTagFromTimestampProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("tag", DataTypes.StringType), ProcedureParameter.optional("timestamp", DataTypes.LongType), ProcedureParameter.optional("time_retained", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("tagName", DataTypes.StringType, true, Metadata.empty()), new StructField("snapshot", DataTypes.LongType, true, Metadata.empty()), new StructField("commit_time", DataTypes.LongType, true, Metadata.empty()), new StructField("watermark", DataTypes.StringType, true, Metadata.empty())});

    protected CreateTagFromTimestampProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String tag = args.getString(1);
        Long timestamp = args.getLong(2);
        Duration timeRetained = args.isNullAt(3) ? null : TimeUtils.parseDuration(args.getString(3));
        return this.modifyPaimonTable(tableIdent, table -> {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            SnapshotManager snapshotManager = fileStoreTable.snapshotManager();
            Snapshot snapshot = snapshotManager.laterOrEqualTimeMills(timestamp);
            Set<Snapshot> sortedTagsSnapshots = fileStoreTable.tagManager().tags().keySet();
            for (Snapshot tagSnapshot : sortedTagsSnapshots) {
                if (timestamp > tagSnapshot.timeMillis()) continue;
                if (snapshot != null && tagSnapshot.timeMillis() >= snapshot.timeMillis()) break;
                snapshot = tagSnapshot;
                break;
            }
            SnapshotNotExistException.checkNotNull(snapshot, String.format("Could not find any snapshot whose commit-time later than %s.", timestamp));
            fileStoreTable.createTag(tag, snapshot.id(), timeRetained);
            InternalRow outputRow = this.newInternalRow(UTF8String.fromString((String)tag), snapshot.id(), snapshot.timeMillis(), UTF8String.fromString((String)String.valueOf(snapshot.watermark())));
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CreateTagFromTimestampProcedure>(){

            @Override
            public CreateTagFromTimestampProcedure doBuild() {
                return new CreateTagFromTimestampProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "CreateTagFromTimestampProcedure";
    }
}

