/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.execution.adaptive;

import java.io.Serializable;
import org.apache.paimon.spark.PaimonScan;
import org.apache.spark.sql.catalyst.plans.physical.AllTuples$;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.StoragePartitionJoinParams;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;

public final class DisableUnnecessaryPaimonBucketedScan$
extends Rule<SparkPlan> {
    public static DisableUnnecessaryPaimonBucketedScan$ MODULE$;

    static {
        new DisableUnnecessaryPaimonBucketedScan$();
    }

    private SparkPlan disableBucketScan(SparkPlan plan, boolean hashInterestingPartitionOrOrder, boolean hasExchange) {
        SparkPlan sparkPlan = plan;
        if (this.hasInterestingPartitionOrOrder(sparkPlan)) {
            return (SparkPlan)sparkPlan.mapChildren((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.disableBucketScan((SparkPlan)x$1, true, false));
        }
        if (sparkPlan instanceof ShuffleExchangeLike) {
            ShuffleExchangeLike shuffleExchangeLike = (ShuffleExchangeLike)sparkPlan;
            return (SparkPlan)((UnaryLike)shuffleExchangeLike).mapChildren((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.disableBucketScan((SparkPlan)x$2, hashInterestingPartitionOrOrder, true));
        }
        if (sparkPlan instanceof BatchScanExec) {
            BatchScanExec batchScanExec = (BatchScanExec)sparkPlan;
            Option<Tuple2<BatchScanExec, PaimonScan>> paimonBucketedScan = this.extractPaimonBucketedScan((SparkPlan)batchScanExec);
            if (paimonBucketedScan.isDefined() && (!hashInterestingPartitionOrOrder || hasExchange)) {
                Tuple2 tuple2 = (Tuple2)paimonBucketedScan.get();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BatchScanExec batch = (BatchScanExec)tuple2._1();
                PaimonScan paimonScan = (PaimonScan)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)batch, (Object)paimonScan);
                BatchScanExec batch2 = (BatchScanExec)tuple22._1();
                PaimonScan paimonScan2 = (PaimonScan)tuple22._2();
                PaimonScan x$12 = paimonScan2.disableBucketedScan();
                Seq x$22 = batch2.copy$default$1();
                Seq x$3 = batch2.copy$default$3();
                Option x$42 = batch2.copy$default$4();
                Table x$52 = batch2.copy$default$5();
                StoragePartitionJoinParams x$6 = batch2.copy$default$6();
                BatchScanExec newBatch = batch2.copy(x$22, (Scan)x$12, x$3, x$42, x$52, x$6);
                newBatch.copyTagsFrom((TreeNode)batch2);
                return newBatch;
            }
            return batchScanExec;
        }
        if (this.canPassThrough(sparkPlan)) {
            return (SparkPlan)sparkPlan.mapChildren((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.disableBucketScan((SparkPlan)x$4, hashInterestingPartitionOrOrder, hasExchange));
        }
        return (SparkPlan)sparkPlan.mapChildren((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.disableBucketScan((SparkPlan)x$5, false, false));
    }

    private boolean hasInterestingPartitionOrOrder(SparkPlan plan) {
        boolean hashPartition = plan.requiredChildDistribution().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DisableUnnecessaryPaimonBucketedScan$.$anonfun$hasInterestingPartitionOrOrder$1(x0$1)));
        boolean hashOrder = plan.requiredChildOrdering().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.nonEmpty()));
        return hashPartition || hashOrder;
    }

    private boolean canPassThrough(SparkPlan plan) {
        SortExec sortExec;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof ProjectExec ? true : sparkPlan instanceof FilterExec) {
            return true;
        }
        if (sparkPlan instanceof SortExec && !(sortExec = (SortExec)sparkPlan).global()) {
            return true;
        }
        if (sparkPlan instanceof BaseAggregateExec) {
            BaseAggregateExec baseAggregateExec = (BaseAggregateExec)sparkPlan;
            return baseAggregateExec.requiredChildDistributionExpressions().isEmpty();
        }
        return false;
    }

    public Option<Tuple2<BatchScanExec, PaimonScan>> extractPaimonBucketedScan(SparkPlan plan) {
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof BatchScanExec) {
            PaimonScan paimonScan;
            BatchScanExec batchScanExec = (BatchScanExec)sparkPlan;
            Scan scan = batchScanExec.scan();
            if (scan instanceof PaimonScan && (paimonScan = (PaimonScan)scan).lazyInputPartitions().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.bucketed()))) {
                return new Some((Object)new Tuple2((Object)batchScanExec, (Object)paimonScan));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public SparkPlan apply(SparkPlan plan) {
        LazyBoolean hasBucketedScan$lzy = new LazyBoolean();
        boolean v2BucketingEnabled = new StringOps(Predef$.MODULE$.augmentString(this.conf().getConfString("spark.sql.sources.v2.bucketing.enabled", "false"))).toBoolean();
        if (!(v2BucketingEnabled && this.conf().autoBucketedScanEnabled() && DisableUnnecessaryPaimonBucketedScan$.hasBucketedScan$1(hasBucketedScan$lzy, plan))) {
            return plan;
        }
        return this.disableBucketScan(plan, false, false);
    }

    public static final /* synthetic */ boolean $anonfun$hasInterestingPartitionOrOrder$1(Distribution x0$1) {
        Distribution distribution = x0$1;
        return distribution instanceof ClusteredDistribution ? true : AllTuples$.MODULE$.equals(distribution);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        return MODULE$.extractPaimonBucketedScan(sparkPlan).isDefined();
    }

    private static final /* synthetic */ boolean hasBucketedScan$lzycompute$1(LazyBoolean hasBucketedScan$lzy$1, SparkPlan plan$1) {
        boolean bl;
        LazyBoolean lazyBoolean = hasBucketedScan$lzy$1;
        synchronized (lazyBoolean) {
            bl = hasBucketedScan$lzy$1.initialized() ? hasBucketedScan$lzy$1.value() : hasBucketedScan$lzy$1.initialize(plan$1.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DisableUnnecessaryPaimonBucketedScan$.$anonfun$apply$1(x0$1))));
        }
        return bl;
    }

    private static final boolean hasBucketedScan$1(LazyBoolean hasBucketedScan$lzy$1, SparkPlan plan$1) {
        if (hasBucketedScan$lzy$1.initialized()) {
            return hasBucketedScan$lzy$1.value();
        }
        return DisableUnnecessaryPaimonBucketedScan$.hasBucketedScan$lzycompute$1(hasBucketedScan$lzy$1, plan$1);
    }

    private DisableUnnecessaryPaimonBucketedScan$() {
        MODULE$ = this;
    }
}

