/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.hc.client5.http.impl.classic;

import org.apache.paimon.shade.hc.client5.http.HttpRoute;
import org.apache.paimon.shade.hc.client5.http.impl.classic.AbstractBackoff;
import org.apache.paimon.shade.hc.core5.annotation.Contract;
import org.apache.paimon.shade.hc.core5.annotation.ThreadingBehavior;
import org.apache.paimon.shade.hc.core5.pool.ConnPoolControl;
import org.apache.paimon.shade.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class AIMDBackoffManager
extends AbstractBackoff {
    public AIMDBackoffManager(ConnPoolControl<HttpRoute> connPerRoute) {
        super(connPerRoute);
    }

    @Override
    protected int getBackedOffPoolSize(int curr) {
        if (curr <= 1) {
            return 1;
        }
        return (int)Math.floor(this.getBackoffFactor().get() * (double)curr);
    }

    @Override
    public void setBackoffFactor(double d) {
        Args.check(d > 0.0 && d < 1.0, "Backoff factor must be 0.0 < f < 1.0");
        this.getBackoffFactor().set(d);
    }
}

