/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockCompressionType;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.LookupStoreWriter;
import org.apache.paimon.lookup.sort.BlockHandle;
import org.apache.paimon.lookup.sort.BlockTrailer;
import org.apache.paimon.lookup.sort.BlockWriter;
import org.apache.paimon.lookup.sort.BloomFilterHandle;
import org.apache.paimon.lookup.sort.Footer;
import org.apache.paimon.lookup.sort.SortContext;
import org.apache.paimon.lookup.sort.SortLookupStoreUtils;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.BloomFilter;
import org.apache.paimon.utils.MurmurHashUtils;
import org.apache.paimon.utils.VarLengthIntUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortLookupStoreWriter
implements LookupStoreWriter {
    private static final Logger LOG = LoggerFactory.getLogger((String)SortLookupStoreWriter.class.getName());
    public static final int MAGIC_NUMBER = 1481571681;
    private final BufferedOutputStream fileOutputStream;
    private final int blockSize;
    private final BlockWriter dataBlockWriter;
    private final BlockWriter indexBlockWriter;
    @Nullable
    private final BloomFilter.Builder bloomFilter;
    private final BlockCompressionType compressionType;
    @Nullable
    private final BlockCompressor blockCompressor;
    private byte[] lastKey;
    private long position;
    private long recordCount;
    private long totalUncompressedSize;
    private long totalCompressedSize;

    SortLookupStoreWriter(File file, int blockSize, @Nullable BloomFilter.Builder bloomFilter, @Nullable BlockCompressionFactory compressionFactory) throws IOException {
        this.fileOutputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        this.blockSize = blockSize;
        this.dataBlockWriter = new BlockWriter((int)((double)blockSize * 1.1));
        int expectedNumberOfBlocks = 1024;
        this.indexBlockWriter = new BlockWriter(14 * expectedNumberOfBlocks);
        this.bloomFilter = bloomFilter;
        if (compressionFactory == null) {
            this.compressionType = BlockCompressionType.NONE;
            this.blockCompressor = null;
        } else {
            this.compressionType = compressionFactory.getCompressionType();
            this.blockCompressor = compressionFactory.getCompressor();
        }
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        this.dataBlockWriter.add(key, value);
        if (this.bloomFilter != null) {
            this.bloomFilter.addHash(MurmurHashUtils.hashBytes(key));
        }
        this.lastKey = key;
        if (this.dataBlockWriter.memory() > this.blockSize) {
            this.flush();
        }
        ++this.recordCount;
    }

    private void flush() throws IOException {
        if (this.dataBlockWriter.size() == 0) {
            return;
        }
        BlockHandle blockHandle = this.writeBlock(this.dataBlockWriter);
        MemorySlice handleEncoding = BlockHandle.writeBlockHandle(blockHandle);
        this.indexBlockWriter.add(this.lastKey, handleEncoding.copyBytes());
    }

    private BlockHandle writeBlock(BlockWriter blockWriter) throws IOException {
        int maxCompressedSize;
        byte[] compressed;
        int offset;
        int compressedSize;
        MemorySlice block = blockWriter.finish();
        this.totalUncompressedSize += (long)block.length();
        BlockCompressionType blockCompressionType = BlockCompressionType.NONE;
        if (this.blockCompressor != null && (compressedSize = (offset = VarLengthIntUtils.encodeInt(compressed = MemorySegmentUtils.allocateReuseBytes((maxCompressedSize = this.blockCompressor.getMaxCompressedSize(block.length())) + 5), 0, block.length())) + this.blockCompressor.compress(block.getHeapMemory(), block.offset(), block.length(), compressed, offset)) < block.length() - block.length() / 8) {
            block = new MemorySlice(MemorySegment.wrap(compressed), 0, compressedSize);
            blockCompressionType = this.compressionType;
        }
        this.totalCompressedSize += (long)block.length();
        BlockTrailer blockTrailer = new BlockTrailer(blockCompressionType, SortLookupStoreUtils.crc32c(block, blockCompressionType));
        MemorySlice trailer = BlockTrailer.writeBlockTrailer(blockTrailer);
        BlockHandle blockHandle = new BlockHandle(this.position, block.length());
        this.writeSlice(block);
        this.writeSlice(trailer);
        blockWriter.reset();
        return blockHandle;
    }

    @Override
    public LookupStoreFactory.Context close() throws IOException {
        this.flush();
        LOG.info("Number of record: {}", (Object)this.recordCount);
        BloomFilterHandle bloomFilterHandle = null;
        if (this.bloomFilter != null) {
            MemorySegment buffer = this.bloomFilter.getBuffer();
            bloomFilterHandle = new BloomFilterHandle(this.position, buffer.size(), this.bloomFilter.expectedEntries());
            this.writeSlice(MemorySlice.wrap(buffer));
            LOG.info("Bloom filter size: {} bytes", (Object)this.bloomFilter.getBuffer().size());
        }
        BlockHandle indexBlockHandle = this.writeBlock(this.indexBlockWriter);
        Footer footer = new Footer(bloomFilterHandle, indexBlockHandle);
        MemorySlice footerEncoding = Footer.writeFooter(footer);
        this.writeSlice(footerEncoding);
        this.fileOutputStream.close();
        LOG.info("totalUncompressedSize: {}", (Object)MemorySize.ofBytes(this.totalUncompressedSize));
        LOG.info("totalCompressedSize: {}", (Object)MemorySize.ofBytes(this.totalCompressedSize));
        return new SortContext(this.position);
    }

    private void writeSlice(MemorySlice slice) throws IOException {
        this.fileOutputStream.write(slice.getHeapMemory(), slice.offset(), slice.length());
        this.position += (long)slice.length();
    }
}

